/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.template.Bindings;
import org.openprovenance.prov.template.Groupings;
import org.openprovenance.prov.template.Using;

public class ExpandUtil {
    static Logger logger = Logger.getLogger(ExpandUtil.class);
    public static final String VAR_NS = "http://openprovenance.org/var#";
    public static final String VARGEN_NS = "http://openprovenance.org/vargen#";
    public static final String TMPL_NS = "http://openprovenance.org/tmpl#";
    public static final String TMPL_PREFIX = "tmpl";
    public static final String VAR_PREFIX = "var";
    public static final String VARGEN_PREFIX = "vargen";
    public static final String LINKED = "linked";
    public static final String LINKED_URI = "http://openprovenance.org/tmpl#linked";
    public static final String LABEL = "label";
    public static final String TIME = "time";
    public static final String STARTTIME = "startTime";
    public static final String ENDTIME = "endTime";
    public static final String LABEL_URI = "http://openprovenance.org/tmpl#label";
    public static final String TIME_URI = "http://openprovenance.org/tmpl#time";
    public static final String STARTTIME_URI = "http://openprovenance.org/tmpl#startTime";
    public static final String ENDTIME_URI = "http://openprovenance.org/tmpl#endTime";
    static ProvUtilities u = new ProvUtilities();

    public static int getFirstTimeIndex(Statement s) {
        StatementOrBundle.Kind kind = s.getKind();
        switch (kind) {
            case PROV_ACTIVITY: {
                return 1;
            }
            case PROV_AGENT: {
                return 1;
            }
            case PROV_ALTERNATE: {
                return 2;
            }
            case PROV_ASSOCIATION: {
                return 4;
            }
            case PROV_ATTRIBUTION: {
                return 3;
            }
            case PROV_BUNDLE: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + kind);
            }
            case PROV_COMMUNICATION: {
                return 3;
            }
            case PROV_DELEGATION: {
                return 4;
            }
            case PROV_DERIVATION: {
                return 6;
            }
            case PROV_DICTIONARY_INSERTION: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + kind);
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + kind);
            }
            case PROV_DICTIONARY_REMOVAL: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + kind);
            }
            case PROV_END: {
                return 4;
            }
            case PROV_ENTITY: {
                return 1;
            }
            case PROV_GENERATION: {
                return 3;
            }
            case PROV_INFLUENCE: {
                return 3;
            }
            case PROV_INVALIDATION: {
                return 3;
            }
            case PROV_MEMBERSHIP: {
                return 2;
            }
            case PROV_MENTION: {
                return 3;
            }
            case PROV_SPECIALIZATION: {
                return 2;
            }
            case PROV_START: {
                return 4;
            }
            case PROV_USAGE: {
                return 3;
            }
        }
        throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + kind);
    }

    public static Set<QualifiedName> freeVariables(Statement statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        for (int i = 0; i < ExpandUtil.getFirstTimeIndex(statement); ++i) {
            Object o = u.getter(statement, i);
            if (o instanceof QualifiedName) {
                QualifiedName name = (QualifiedName)o;
                if (name == null || !ExpandUtil.isVariable(name)) continue;
                result.add(name);
                continue;
            }
            if (!(o instanceof List)) continue;
            List ll = (List)o;
            for (QualifiedName name : ll) {
                if (name == null || !ExpandUtil.isVariable(name)) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static Set<QualifiedName> freeVariables(Bundle statement) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        QualifiedName name = statement.getId();
        if (name != null && ExpandUtil.isVariable(name)) {
            result.add(name);
        }
        return result;
    }

    public static HashSet<QualifiedName> freeAttributeVariables(Statement statement, ProvFactory pf) {
        HashSet<QualifiedName> result = new HashSet<QualifiedName>();
        Collection ll = pf.getAttributes(statement);
        for (Attribute attr : ll) {
            QualifiedName qn;
            Object o;
            if (!pf.getName().PROV_QUALIFIED_NAME.equals((Object)attr.getType()) || !((o = attr.getValue()) instanceof QualifiedName) || !ExpandUtil.isVariable(qn = (QualifiedName)o)) continue;
            result.add(qn);
        }
        return result;
    }

    public static Using usedGroups(Statement statement, Groupings groupings, Bindings bindings) {
        Set<QualifiedName> vars = ExpandUtil.freeVariables(statement);
        HashSet<Integer> groups = new HashSet<Integer>();
        for (QualifiedName var : vars) {
            for (int grp = 0; grp < groupings.size(); ++grp) {
                List<QualifiedName> names = groupings.get(grp);
                if (!names.contains(var)) continue;
                groups.add(grp);
            }
        }
        Using u = new Using();
        Object[] sorted = groups.toArray(new Integer[0]);
        Arrays.sort(sorted);
        for (Object g : sorted) {
            List<QualifiedName> vs = groupings.get((Integer)g);
            QualifiedName qn = vs.get(0);
            List<QualifiedName> vals = bindings.getVariables().get(qn);
            if (vals != null) {
                u.addGroup((Integer)g, vals.size());
                continue;
            }
            if (ExpandUtil.isGensymVariable(qn)) {
                u.addGroup((Integer)g, 1);
                continue;
            }
            List<List<TypedValue>> attrs = bindings.getAttributes().get(vs.get(0));
            if (attrs == null) continue;
            u.addGroup((Integer)g, attrs.size());
        }
        return u;
    }

    public static boolean isVariable(QualifiedName id) {
        if (id == null) {
            return false;
        }
        String namespaceURI = id.getNamespaceURI();
        return VAR_NS.equals(namespaceURI) || VARGEN_NS.equals(namespaceURI);
    }

    public static boolean isGensymVariable(QualifiedName id) {
        if (id == null) {
            return false;
        }
        String namespaceURI = id.getNamespaceURI();
        return VARGEN_NS.equals(namespaceURI);
    }
}

