/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.compiler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.compiler.StatementCompilerAction;
import org.openprovenance.prov.template.expander.ExpandAction;
import org.openprovenance.prov.template.expander.ExpandUtil;

public class TemplateCompiler {
    private final ProvFactory pFactory;
    static ProvUtilities u = new ProvUtilities();
    final CompilerUtil gu = new CompilerUtil();
    boolean withMain = true;
    static final ParameterizedTypeName hashmapType = ParameterizedTypeName.get((ClassName)ClassName.get(HashMap.class), (TypeName[])new TypeName[]{TypeName.get(Integer.class), TypeName.get(int[].class)});

    public TemplateCompiler(ProvFactory pFactory) {
        this.pFactory = pFactory;
    }

    public boolean generate(Document doc, String templateName, String packge, String cli_src_dir, String l2p_src_dir, String resource, JsonNode bindings_schema) {
        try {
            String bn = this.templateNameClass(templateName);
            String destinationDir = l2p_src_dir + "/" + packge.replace('.', '/') + "/";
            String destinationDir2 = cli_src_dir + "/" + packge.replace('.', '/') + "/client/";
            String destination = destinationDir + bn + ".java";
            String destination2 = destinationDir2 + bn + ".java";
            JavaFile spec = this.generateBuilderSpecification(doc, bn, templateName, packge, resource, bindings_schema);
            boolean val1 = this.saveToFile(destinationDir, destination, spec);
            JavaFile spec2 = this.generateClientLib(doc, bn, templateName, packge + ".client", resource, bindings_schema);
            boolean val2 = this.saveToFile(destinationDir2, destination2, spec2);
            return val1 & val2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveToFile(String destinationDir, String destination, JavaFile spec) {
        try {
            File dir = new File(destinationDir);
            if (!dir.exists() && !dir.mkdirs()) {
                System.err.println("failed to create directory " + destinationDir);
                return false;
            }
            PrintWriter out = new PrintWriter(destination);
            out.print(spec);
            out.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String templateNameClass(String templateName) {
        return this.gu.capitalize(templateName) + "Builder";
    }

    public JavaFile generateBuilderSpecification(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.gu.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        return this.generateBuilderSpecification_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema);
    }

    public JavaFile generateClientLib(Document doc, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        Bundle bun = (Bundle)u.getBundle(doc).get(0);
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        HashSet<QualifiedName> allAtts = new HashSet<QualifiedName>();
        this.gu.extractVariablesAndAttributes(bun, allVars, allAtts, this.pFactory);
        IndexedDocument indexed = new IndexedDocument(this.pFactory, this.pFactory.newDocument(), true);
        u.forAllStatement(bun.getStatement(), (StatementAction)indexed);
        return this.generateClientLib_aux(doc, allVars, allAtts, name, templateName, packge, resource, bindings_schema, indexed);
    }

    private JavaFile generateBuilderSpecification_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema) {
        TypeSpec.Builder builder = this.gu.generateClassBuilder2(name);
        Hashtable<QualifiedName, String> vmap = this.generateQualifiedNames(doc, builder);
        builder.addMethod(this.gu.generateConstructor2(vmap));
        builder.addMethod(this.generateTemplateGenerator(allVars, allAtts, doc, vmap));
        builder.addMethod(this.nameAccessorGenerator(templateName));
        if (this.withMain) {
            builder.addMethod(this.generateMain(allVars, allAtts, name, bindings_schema));
        }
        if (bindings_schema != null) {
            builder.addMethod(this.generateFactoryMethod(allVars, allAtts, name, bindings_schema));
            builder.addMethod(this.generateFactoryMethodWithArray(allVars, allAtts, name, bindings_schema));
        }
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox for template $S", new Object[]{templateName}).build();
        return myfile;
    }

    private JavaFile generateClientLib_aux(Document doc, Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String templateName, String packge, String resource, JsonNode bindings_schema, IndexedDocument indexed) {
        TypeSpec.Builder builder = this.gu.generateClassInit(name, "org.openprovenance.prov.client", "Builder");
        if (bindings_schema != null) {
            builder.addMethod(this.generateClientMethod(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod2(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3static(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod3(allVars, allAtts, name, templateName, bindings_schema));
            builder.addMethod(this.generateClientMethod4static(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addField(FieldSpec.builder((TypeName)hashmapType, (String)"__successors", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getSuccessors()", new Object[0]).build());
            builder.addField(FieldSpec.builder(int[].class, (String)"__nodes", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("__getNodes()", new Object[0]).build());
            builder.addMethod(this.generateClientMethod4(allVars, allAtts, name, templateName, bindings_schema, indexed));
            builder.addMethod(this.nameAccessorGenerator(templateName));
        }
        TypeSpec bean = builder.build();
        JavaFile myfile = JavaFile.builder((String)packge, (TypeSpec)bean).addFileComment("Generated Automatically by ProvToolbox for template $S", new Object[]{templateName}).build();
        return myfile;
    }

    public MethodSpec nameAccessorGenerator(String templateName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return $S", new Object[]{templateName});
        return builder.build();
    }

    public MethodSpec generateTemplateGenerator(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, Document doc, Hashtable<QualifiedName, String> vmap) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"generator").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class).addStatement("$T nullqn = null", new Object[]{QualifiedName.class}).addStatement("$T attrs=null", new Object[]{StatementCompilerAction.cl_collectionOfAttributes}).addStatement("$T document = pf.newDocument()", new Object[]{Document.class});
        for (QualifiedName qualifiedName : allVars) {
            builder.addParameter(QualifiedName.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allAtts) {
            if (allVars.contains(qualifiedName)) continue;
            builder.addParameter(Object.class, qualifiedName.getLocalPart(), new Modifier[0]);
        }
        for (QualifiedName qualifiedName : allVars) {
            if (!ExpandUtil.isGensymVariable(qualifiedName)) continue;
            String vgen = qualifiedName.getLocalPart();
            builder.addStatement("if ($N==null) $N=$T.getUUIDQualifiedName2(pf)", new Object[]{vgen, vgen, ExpandAction.class});
        }
        StatementCompilerAction action = new StatementCompilerAction(this.pFactory, allVars, allAtts, vmap, builder, "document.getStatementOrBundle()");
        for (StatementOrBundle s : doc.getStatementOrBundle()) {
            u.doAction(s, (StatementAction)action);
        }
        builder.addStatement("new $T().updateNamespaces(document)", new Object[]{ProvUtilities.class});
        builder.addStatement("return document", new Object[0]);
        MethodSpec methodSpec = builder.build();
        return methodSpec;
    }

    public Hashtable<QualifiedName, String> generateQualifiedNames(Document doc, TypeSpec.Builder builder) {
        Bundle bun = (Bundle)u.getBundle(doc).get(0);
        HashSet<QualifiedName> set = new HashSet<QualifiedName>();
        this.gu.allQualifiedNames(bun, set, this.pFactory);
        set.remove(this.pFactory.newQualifiedName("http://openprovenance.org/tmpl#", "label", "tmpl"));
        set.add(this.pFactory.getName().PROV_LABEL);
        Hashtable<QualifiedName, String> qnVariables = new Hashtable<QualifiedName, String>();
        for (QualifiedName qn : set) {
            if (ExpandUtil.isVariable(qn)) continue;
            String v = this.variableForQualifiedName(qn);
            qnVariables.put(qn, v);
            builder.addField(QualifiedName.class, v, new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        return qnVariables;
    }

    public String variableForQualifiedName(QualifiedName qn) {
        return "_Q_" + qn.getPrefix() + "_" + qn.getLocalPart();
    }

    public MethodSpec generateFactoryMethod(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        String key;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class).addStatement("$T document = null", new Object[]{Document.class}).addStatement("$T ns = new Namespace()", new Object[]{Namespace.class});
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        this.generateSpecializedParameters(builder, the_var);
        Iterator iter2 = the_context.fieldNames();
        while (iter2.hasNext()) {
            String prefix = (String)iter2.next();
            String uri = the_context.get(prefix).textValue();
            builder.addStatement("ns.register($S,$S)", new Object[]{prefix, uri});
        }
        String args = "";
        boolean first = true;
        for (QualifiedName q : allVars) {
            key = q.getLocalPart();
            String newName = "__" + key;
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                String s = entry.get(0).get("@id").textValue();
                String s2 = "\"" + s.replace("*", "\" + $N + \"") + "\"";
                builder.addStatement("$T $N=($N==null)?null:ns.stringToQualifiedName(" + s2 + ",pf)", new Object[]{QualifiedName.class, newName, key, key});
            } else {
                builder.addStatement("$T $N=null", new Object[]{QualifiedName.class, newName});
            }
            if (first) {
                first = false;
                args = newName;
                continue;
            }
            args = args + ", " + newName;
        }
        for (QualifiedName q : allAtts) {
            key = q.getLocalPart();
            if (first) {
                first = false;
                args = key;
                continue;
            }
            args = args + ", " + key;
        }
        builder.addStatement("document = generator(" + args + ")", new Object[0]);
        builder.addStatement("return document", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public void generateSpecializedParameters(MethodSpec.Builder builder, JsonNode the_var) {
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            builder.addParameter(this.getJavaTypeForDeclaredType(the_var, key), key, new Modifier[0]);
        }
    }

    public void generateSpecializedParametersJavadoc(MethodSpec.Builder builder, JsonNode the_var) {
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            JsonNode entry = the_var.path(key);
            if (entry != null && !(entry instanceof MissingNode)) {
                JsonNode jsonNode;
                JsonNode firstNode = entry.get(0);
                if (firstNode instanceof ArrayNode) {
                    firstNode = ((ArrayNode)firstNode).get(0);
                }
                String documentation = this.noNode(jsonNode = firstNode.get("@documentation")) ? "-- no @documentation" : jsonNode.textValue();
                JsonNode jsonNode2 = firstNode.get("@type");
                String type = this.noNode(jsonNode2) ? "xsd:string" : jsonNode2.textValue();
                builder.addJavadoc("@param $N $L (expected type: $L)\n", new Object[]{key, documentation, type});
                continue;
            }
            builder.addJavadoc("@param $N -- no bindings schemas \n", new Object[]{key});
        }
    }

    public boolean noNode(JsonNode jsonNode2) {
        return jsonNode2 == null || jsonNode2 instanceof MissingNode || jsonNode2 instanceof NullNode;
    }

    public MethodSpec generateClientMethod(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        String loggerName = this.loggerName(template);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)loggerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        String var = "sb";
        builder.addStatement("$T $N=new $T()", new Object[]{StringBuffer.class, var, StringBuffer.class});
        String args = "" + var;
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
            args = args + ", " + newkey;
        }
        builder.addStatement("$N(" + args + ")", new Object[]{loggerName});
        builder.addStatement("return $N.toString()", new Object[]{var});
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod2(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.loggerName(template)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE);
        String var = "sb";
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(StringBuffer.class, var, new Modifier[0]);
        Iterator iter = the_var.fieldNames();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newkey = "__" + key;
            builder.addParameter(this.getJavaTypeForDeclaredType(the_var, key), newkey, new Modifier[0]);
        }
        iter = the_var.fieldNames();
        String constant = "[\"" + template + "\"";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String newName = "__" + key;
            Class<?> clazz = this.getJavaTypeForDeclaredType(the_var, key);
            constant = constant + ',';
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            constant = "";
            if (String.class.equals(clazz)) {
                builder.beginControlFlow("if ($N==null)", new Object[]{newName}).addStatement("$N.append($N)", new Object[]{var, newName}).nextControlFlow("else", new Object[0]).addStatement("$N.append($S)", new Object[]{var, "\""}).addStatement("$N.append($N)", new Object[]{var, newName}).addStatement("$N.append($S)", new Object[]{var, "\""}).endControlFlow();
                continue;
            }
            builder.addStatement("$N.append($S)", new Object[]{var, constant});
            builder.addStatement("$N.append($N)", new Object[]{var, newName});
        }
        constant = constant + ']';
        builder.addStatement("$N.append($S)", new Object[]{var, constant});
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod3static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(int[].class);
        String var = "sb";
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter = the_var.fieldNames();
        int count = 0;
        LinkedList<Integer> ll = new LinkedList<Integer>();
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            ll.add(count);
        }
        String nodes = "";
        boolean first = true;
        Iterator iterator = ll.iterator();
        while (iterator.hasNext()) {
            int elem = (Integer)iterator.next();
            if (first) {
                first = false;
            } else {
                nodes = nodes + ", ";
            }
            nodes = nodes + elem;
        }
        builder.addStatement("return new int[] {" + nodes + "}", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod3(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getNodes").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(int[].class);
        builder.addStatement("return __nodes", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod4(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)hashmapType);
        builder.addStatement("return __successors", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public MethodSpec generateClientMethod4static(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, String template, JsonNode bindings_schema, IndexedDocument indexed) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"__getSuccessors").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)hashmapType);
        String var = "sb";
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        Iterator iter2 = the_var.fieldNames();
        int count2 = 0;
        HashMap<QualifiedName, Integer> index = new HashMap<QualifiedName, Integer>();
        while (iter2.hasNext()) {
            ++count2;
            String key = (String)iter2.next();
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                index.put(qn, count2);
            }
        }
        builder.addStatement("$T table = new $T()", new Object[]{hashmapType, hashmapType});
        Iterator iter = the_var.fieldNames();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            String key = (String)iter.next();
            if (the_var.get(key).get(0).get("@id") == null) continue;
            Set successors = null;
            for (QualifiedName qn : allVars) {
                if (!key.equals(qn.getLocalPart())) continue;
                successors = indexed.traverseDerivations(qn);
                break;
            }
            String initializer = "";
            boolean first = true;
            for (QualifiedName successor : successors) {
                int i = (Integer)index.get(successor);
                if (first) {
                    first = false;
                } else {
                    initializer = initializer + ", ";
                }
                initializer = initializer + i;
            }
            builder.addStatement("table.put($L,new int[] { " + initializer + "})", new Object[]{count});
        }
        builder.addStatement("return table", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public String loggerName(String template) {
        return "log" + this.gu.capitalize(template);
    }

    public MethodSpec generateFactoryMethodWithArray(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"make").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Document.class);
        JsonNode the_var = bindings_schema.get("var");
        JsonNode the_context = bindings_schema.get("context");
        builder.addParameter(Object[].class, "record", new Modifier[0]);
        int count = 1;
        Iterator iter = the_var.fieldNames();
        String args = "";
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Class<?> atype = this.getJavaTypeForDeclaredType(the_var, key);
            String statement = "$T $N=($T)record[" + count + "]";
            builder.addStatement(statement, new Object[]{atype, key, atype});
            if (count > 1) {
                args = args + ", ";
            }
            args = args + key;
            ++count;
        }
        builder.addStatement("return make(" + args + ")", new Object[0]);
        MethodSpec method = builder.build();
        return method;
    }

    public Class<?> getJavaTypeForDeclaredType(JsonNode the_var, String key) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return String.class;
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType;
            switch (keyType = hasType.textValue()) {
                case "xsd:int": {
                    return Integer.class;
                }
                case "xsd:long": {
                    return Long.class;
                }
                case "xsd:string": {
                    return String.class;
                }
                case "xsd:boolean": {
                    return Boolean.class;
                }
                case "xsd:float": {
                    return Float.class;
                }
                case "xsd:double": {
                    return Double.class;
                }
                case "xsd:dateTime": {
                    return String.class;
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }

    public String getDeclaredType(JsonNode the_var, String key) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return "prov:QualifiedName";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType = hasType.textValue();
            return keyType;
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public MethodSpec generateMain(Set<QualifiedName> allVars, Set<QualifiedName> allAtts, String name, JsonNode bindings_schema) {
        void var7_14;
        String key;
        Iterator iter;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addStatement("$T pf=org.openprovenance.prov.xml.ProvFactory.getFactory()", new Object[]{ProvFactory.class}).addStatement("$N me=new $N(pf)", new Object[]{name, name});
        for (QualifiedName qualifiedName : allVars) {
            builder.addStatement("$T $N=pf.newQualifiedName($S,$S,$S)", new Object[]{QualifiedName.class, qualifiedName.getLocalPart(), "http://example.org/", qualifiedName.getLocalPart(), "ex"});
        }
        JsonNode the_var2 = bindings_schema == null ? null : bindings_schema.get("var");
        for (QualifiedName q : allAtts) {
            Object declaredType = null;
            if (the_var2 != null) {
                iter = the_var2.fieldNames();
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    if (!q.getLocalPart().equals(key)) continue;
                    declaredType = this.getDeclaredType(the_var2, key);
                }
            }
            String example = this.generateExampleForType((String)declaredType, q.getLocalPart());
            builder.addStatement("$T $N=$S", new Object[]{String.class, q.getLocalPart(), example});
        }
        String string = "";
        boolean first = true;
        for (QualifiedName q : allVars) {
            void var7_10;
            if (first) {
                first = false;
                String string2 = q.getLocalPart();
                continue;
            }
            String string3 = (String)var7_10 + ", " + q.getLocalPart();
        }
        for (QualifiedName q : allAtts) {
            key = q.getLocalPart();
            if (first) {
                first = false;
                String string4 = key;
                continue;
            }
            String string5 = (String)var7_14 + ", " + key;
        }
        builder.addStatement("$T document=me.generator(" + (String)var7_14 + ")", new Object[]{Document.class});
        builder.addStatement("new org.openprovenance.prov.interop.InteropFramework().writeDocument(System.out,org.openprovenance.prov.interop.InteropFramework.ProvFormat.PROVN,document)", new Object[0]);
        if (bindings_schema != null) {
            void var7_19;
            JsonNode the_var = bindings_schema.get("var");
            iter = the_var.fieldNames();
            String string6 = "";
            first = true;
            int count = 0;
            while (iter.hasNext()) {
                String key2 = (String)iter.next();
                if (first) {
                    first = false;
                    String string7 = this.createExamplar(the_var, key2, count++);
                    continue;
                }
                String string8 = (String)var7_19 + ", " + this.createExamplar(the_var, key2, count++);
            }
            builder.addStatement("document=me.make(" + (String)var7_19 + ")", new Object[0]);
            builder.addStatement("new org.openprovenance.prov.interop.InteropFramework().writeDocument(System.out,org.openprovenance.prov.interop.InteropFramework.ProvFormat.PROVN,document)", new Object[0]);
        }
        MethodSpec method = builder.build();
        return method;
    }

    public String generateExampleForType(String declaredType, String localPart) {
        if (declaredType == null) {
            return "test_" + localPart;
        }
        switch (declaredType) {
            case "xsd:dateTime": {
                return this.pFactory.newTimeNow().toXMLFormat();
            }
            case "xsd:float": {
                return "123.00f";
            }
            case "xsd:int": {
                return "12345";
            }
        }
        return "test_" + localPart;
    }

    public String createExamplar(JsonNode the_var, String key, int num) {
        if (the_var.get(key).get(0).get("@id") != null) {
            return "\"v" + num + "\"";
        }
        if (the_var.get(key).get(0).get(0) == null) {
            System.out.println("key is " + key);
            System.out.println("decl is " + the_var);
            throw new UnsupportedOperationException();
        }
        JsonNode hasType = the_var.get(key).get(0).get(0).get("@type");
        if (hasType != null) {
            String keyType;
            switch (keyType = hasType.textValue()) {
                case "xsd:int": {
                    return "" + num;
                }
                case "xsd:long": {
                    return "" + num + "L";
                }
                case "xsd:string": {
                    return "\"v" + num + "\"";
                }
                case "xsd:boolean": {
                    return "true";
                }
                case "xsd:float": {
                    return "" + num + ".01f";
                }
                case "xsd:double": {
                    return "" + num + ".01d";
                }
                case "xsd:dateTime": {
                    return "\"" + this.pFactory.newTimeNow().toXMLFormat() + "\"";
                }
            }
            throw new UnsupportedOperationException();
        }
        System.out.println("key is " + key);
        System.out.println("decl is " + the_var);
        throw new UnsupportedOperationException();
    }
}

