/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.log2prov;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.template.compiler.CompilerUtil;
import org.openprovenance.prov.template.log2prov.DocumentConcatenatorProcessor;
import org.openprovenance.prov.template.log2prov.DocumentDiscarderProcessor;
import org.openprovenance.prov.template.log2prov.DocumentMergerProcessor;
import org.openprovenance.prov.template.log2prov.DocumentProcessor;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.xml.ProvFactory;

public class Runner {
    static final boolean debug = false;
    private final org.openprovenance.prov.model.ProvFactory pf;
    final CompilerUtil cu = new CompilerUtil();

    public Runner(org.openprovenance.prov.model.ProvFactory pf) {
        this.pf = pf;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String in = args[0];
        String out = args[1];
        String flag = args[2];
        new Runner((org.openprovenance.prov.model.ProvFactory)ProvFactory.getFactory()).processLogWithTime(in, out, flag);
    }

    public void processLogWithTime(String in, String out, String flag) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long currentTime1 = System.currentTimeMillis();
        long currentTime2 = this.processLog(in, out, flag);
        long currentTime3 = System.currentTimeMillis();
    }

    public long processLog(String in, String out, String flag) throws FileNotFoundException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        IndexedDocument iDoc = new IndexedDocument(this.pf, this.pf.newDocument(), true);
        InputStream is = "-".equals(in) ? System.in : new FileInputStream(in);
        DocumentProcessor dp = null;
        if ("-merge".equals(flag)) {
            dp = new DocumentMergerProcessor(iDoc);
        }
        if ("-nomerge".equals(flag)) {
            dp = new DocumentConcatenatorProcessor(this.pf.newDocument());
        }
        if ("-discard".equals(flag)) {
            dp = new DocumentDiscarderProcessor(this.pf.newDocument());
        }
        FileBuilder.reader(is, dp);
        is.close();
        long currentTime2 = System.currentTimeMillis();
        this.cu.writeDocument(out, dp.getDocument());
        return currentTime2;
    }
}

