/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.template.expander.BindingsJson;

public class Bindings {
    public static final String VALUE = "value_";
    public static final String VALUE2 = "2dvalue_";
    public static final String APP_VALUE = "http://openprovenance.org/tmpl#value_";
    public static final String VALUE_v2 = "binding_";
    public static final String APP_VALUE_v2 = "http://openprovenance.org/tmpl#binding_";
    public static final String APP_VALUE2 = "http://openprovenance.org/tmpl#2dvalue_";
    private final Hashtable<QualifiedName, List<QualifiedName>> variables;
    private final Hashtable<QualifiedName, List<List<TypedValue>>> attributes;
    private final ProvFactory pf;
    private final Name name;
    static ProvUtilities u = new ProvUtilities();

    public Bindings(ProvFactory pf) {
        this(new Hashtable<QualifiedName, List<QualifiedName>>(), new Hashtable<QualifiedName, List<List<TypedValue>>>(), pf);
    }

    public Bindings(Hashtable<QualifiedName, List<QualifiedName>> variables, Hashtable<QualifiedName, List<List<TypedValue>>> attributes, ProvFactory pf) {
        this.variables = variables;
        this.attributes = attributes;
        this.pf = pf;
        this.name = pf.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Bindings)) {
            return false;
        }
        Bindings b = (Bindings)o;
        return b.variables.equals(this.variables) && b.attributes.equals(this.attributes);
    }

    public Hashtable<QualifiedName, List<QualifiedName>> getVariables() {
        return this.variables;
    }

    public Hashtable<QualifiedName, List<List<TypedValue>>> getAttributes() {
        return this.attributes;
    }

    public void addVariable(QualifiedName name, QualifiedName val) {
        List<QualifiedName> v = this.variables.get(name);
        if (v == null) {
            this.variables.put(name, new LinkedList());
        }
        this.variables.get(name).add(val);
    }

    public void addVariable(String name, QualifiedName val) {
        this.addVariable(this.b_var(name), val);
    }

    public void addAttribute(QualifiedName name, List<TypedValue> values) {
        List<List<TypedValue>> v = this.attributes.get(name);
        if (v == null) {
            this.attributes.put(name, new LinkedList());
        }
        this.attributes.get(name).add(values);
    }

    public void addAttribute(String name, QualifiedName value) {
        this.addAttribute(this.b_var(name), this.a_val(value));
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(this.b_var(name), this.a_val(value));
    }

    public QualifiedName b_var(String name) {
        return this.pf.newQualifiedName("http://openprovenance.org/var#", name, "var");
    }

    public List<TypedValue> a_val(String s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pf.newAttribute(this.pf.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.XSD_STRING));
        return ll;
    }

    public List<TypedValue> a_val(QualifiedName s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pf.newAttribute(this.pf.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.PROV_QUALIFIED_NAME));
        return ll;
    }

    public String toString() {
        return "[" + this.getVariables() + " -- " + this.getAttributes() + "]";
    }

    public Document toDocument() {
        LinkedList<Statement> ll = new LinkedList<Statement>();
        this.add1DValues(ll, this.variables);
        this.add2Dvalues(ll, this.attributes);
        Document dummy = this.pf.newDocument(null, ll, new LinkedList());
        Document result = this.pf.newDocument(this.pf.newNamespace(Namespace.gatherNamespaces((Document)dummy)), ll, new LinkedList());
        return result;
    }

    public Document toDocument_v2() {
        LinkedList<Statement> ll = new LinkedList<Statement>();
        this.add1DValues_v2(ll, this.variables);
        this.add2Dvalues_v2(ll, this.attributes);
        Document dummy = this.pf.newDocument(null, ll, new LinkedList());
        Document result = this.pf.newDocument(this.pf.newNamespace(Namespace.gatherNamespaces((Document)dummy)), ll, new LinkedList());
        return result;
    }

    public void add2DvaluesOLD(List<StatementOrBundle> ll, Hashtable<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            Entity e = this.pf.newEntity(entry.getKey());
            int count1 = 0;
            LinkedList<Other> attrs = new LinkedList<Other>();
            for (List<TypedValue> vals : entry.getValue()) {
                int count2 = 0;
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newOther("http://openprovenance.org/tmpl#", VALUE2 + count1 + "_" + count2, "tmpl", val.getValue(), val.getType()));
                    ++count2;
                }
                ++count1;
            }
            e.getOther().addAll(attrs);
            ll.add((StatementOrBundle)e);
        }
    }

    public void add2Dvalues(List<Statement> ll, Hashtable<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            int count1 = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (List<TypedValue> vals : entry.getValue()) {
                int count2 = 0;
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE2 + count1 + "_" + count2, "tmpl", val.getValue(), val.getType()));
                    ++count2;
                }
                ++count1;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public void add2Dvalues_v2(List<Statement> ll, Hashtable<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            int count1 = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (List<TypedValue> vals : entry.getValue()) {
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE_v2 + count1, "tmpl", val.getValue(), val.getType()));
                }
                ++count1;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public void add1DValuesOLD(List<StatementOrBundle> ll, Hashtable<QualifiedName, List<QualifiedName>> variables) {
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : variables.entrySet()) {
            Entity e = this.pf.newEntity(entry.getKey());
            int count = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (QualifiedName qn : entry.getValue()) {
                attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE + count, "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
            }
            this.pf.setAttributes((HasOther)e, attrs);
            ll.add((StatementOrBundle)e);
        }
    }

    public void add1DValues(List<Statement> ll, Hashtable<QualifiedName, List<QualifiedName>> variables) {
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : variables.entrySet()) {
            int count = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (QualifiedName qn : entry.getValue()) {
                attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE + count, "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public void add1DValues_v2(List<Statement> ll, Hashtable<QualifiedName, List<QualifiedName>> variables) {
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : variables.entrySet()) {
            int count = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (QualifiedName qn : entry.getValue()) {
                attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE_v2 + count, "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public static Bindings fromDocument(Document doc, ProvFactory pf) {
        Bindings result = new Bindings(pf);
        List entities = u.getEntity(doc);
        for (Entity entity : entities) {
            int size2;
            Hashtable<Integer, QualifiedName> map = new Hashtable<Integer, QualifiedName>();
            Hashtable map2 = new Hashtable();
            for (Other attr : entity.getOther()) {
                String uri = attr.getElementName().getUri();
                if (uri.startsWith(APP_VALUE)) {
                    Integer n = Integer.valueOf(uri.substring(APP_VALUE.length()));
                    if (!(attr.getValue() instanceof QualifiedName)) continue;
                    map.put(n, (QualifiedName)attr.getValue());
                    continue;
                }
                if (!uri.startsWith(APP_VALUE2)) continue;
                String string = uri.substring(APP_VALUE2.length());
                String[] nums = string.split("_");
                Integer i = Integer.valueOf(nums[0]);
                Integer j = Integer.valueOf(nums[1]);
                Hashtable row = (Hashtable)map2.get(i);
                if (row == null) {
                    map2.put(i, new Hashtable());
                }
                ((Hashtable)map2.get(i)).put(j, attr);
            }
            ArrayList ll = new ArrayList();
            int size = map.entrySet().size();
            if (size > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    Bindings.set((Integer)entry.getKey(), ll, (QualifiedName)entry.getValue());
                }
                result.getVariables().put(entity.getId(), ll);
            }
            if ((size2 = map2.entrySet().size()) <= 0) continue;
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry1 : map2.entrySet()) {
                LinkedList values = new LinkedList();
                for (Map.Entry entry2 : ((Hashtable)entry1.getValue()).entrySet()) {
                    Bindings.set((Integer)entry2.getKey(), values, (TypedValue)entry2.getValue());
                }
                Bindings.set((Integer)entry1.getKey(), linkedList, values);
            }
            result.getAttributes().put(entity.getId(), linkedList);
        }
        return result;
    }

    public static Bindings fromDocument_v2(Document doc, ProvFactory pf) {
        Bindings result = new Bindings(pf);
        List entities = u.getEntity(doc);
        for (Entity entity : entities) {
            int size2;
            Object attr22;
            Hashtable<Integer, QualifiedName> map = new Hashtable<Integer, QualifiedName>();
            Hashtable map_v2 = new Hashtable();
            for (Object attr22 : entity.getOther()) {
                String uri = attr22.getElementName().getUri();
                if (uri.startsWith(APP_VALUE_v2)) {
                    String index = uri.substring(APP_VALUE_v2.length());
                    Integer n = Integer.valueOf(index);
                    Set row = (Set)map_v2.get(n);
                    if (row == null) {
                        map_v2.put(n, new HashSet());
                    }
                    ((Set)map_v2.get(n)).add(attr22);
                    continue;
                }
                if (!uri.startsWith(APP_VALUE)) continue;
                Integer i = Integer.valueOf(uri.substring(APP_VALUE.length()));
                Set set = (Set)map_v2.get(i);
                if (set == null) {
                    map_v2.put(i, new HashSet());
                }
                ((Set)map_v2.get(i)).add(attr22);
            }
            boolean single_map = true;
            attr22 = map_v2.keySet().iterator();
            while (attr22.hasNext()) {
                int i = (Integer)attr22.next();
                if (!(single_map = single_map && ((Set)map_v2.get(i)).size() == 1)) continue;
                for (TypedValue typedValue : (Set)map_v2.get(i)) {
                    single_map = typedValue.getValue() instanceof QualifiedName;
                }
            }
            if (single_map) {
                attr22 = map_v2.keySet().iterator();
                while (attr22.hasNext()) {
                    int i = (Integer)attr22.next();
                    for (TypedValue typedValue : (Set)map_v2.get(i)) {
                        map.put(i, (QualifiedName)typedValue.getValue());
                    }
                }
            }
            ArrayList ll = new ArrayList();
            int size = map.entrySet().size();
            if (size > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    Bindings.set((Integer)entry.getKey(), ll, (QualifiedName)entry.getValue());
                }
                result.getVariables().put(entity.getId(), ll);
            }
            if ((size2 = map_v2.entrySet().size()) <= 0) continue;
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry1 : map_v2.entrySet()) {
                LinkedList<Attribute> values = new LinkedList<Attribute>();
                int count = 0;
                for (TypedValue tv : (Set)entry1.getValue()) {
                    Other o;
                    String uri;
                    if (tv instanceof Other && (uri = (o = (Other)tv).getElementName().getUri()).startsWith(APP_VALUE_v2)) {
                        Integer i = Integer.valueOf(uri.substring(APP_VALUE_v2.length()));
                        values.add(pf.newAttribute("http://openprovenance.org/tmpl#", VALUE2 + i + "_" + count, "tmpl", o.getValue(), o.getType()));
                    }
                    ++count;
                }
                Bindings.set((Integer)entry1.getKey(), linkedList, values);
            }
            result.getAttributes().put(entity.getId(), linkedList);
        }
        return result;
    }

    public void addVariableBindingsAsAttributeBindings() {
        Hashtable<QualifiedName, List<QualifiedName>> vb = this.getVariables();
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : vb.entrySet()) {
            int count = 0;
            for (QualifiedName qn : entry.getValue()) {
                LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
                ll.add((TypedValue)this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE2 + count + "_" + 0, "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
                this.addAttribute(entry.getKey(), ll);
            }
        }
    }

    public static <E> void set(int pos, List<E> ll, E val) {
        int size;
        for (int i = size = ll.size(); i <= pos; ++i) {
            ll.add(null);
        }
        ll.set(pos, val);
    }

    public void exportToJson(String filename) {
        BindingsJson.BindingsBean bb = BindingsJson.toBean(this);
        BindingsJson.exportBean(filename, bb, true);
    }
}

