/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.expander.Conversions;
import org.openprovenance.prov.template.expander.OldBindings;
import org.openprovenance.prov.template.expander.deprecated.BindingsBean;
import org.openprovenance.prov.template.json.Bindings;
import org.openprovenance.prov.template.json.Descriptor;
import org.openprovenance.prov.template.json.Descriptors;
import org.openprovenance.prov.template.json.QDescriptor;
import org.openprovenance.prov.template.json.SingleDescriptor;
import org.openprovenance.prov.template.json.SingleDescriptors;
import org.openprovenance.prov.template.json.VDescriptor;

public class BindingsJson {
    static final ObjectMapper mapper = new ObjectMapper();

    public static Object[] convertBeanToValue(Descriptor v, Map<String, String> context, Namespace ns, ProvFactory pf) {
        if (v instanceof QDescriptor) {
            QDescriptor qd = (QDescriptor)v;
            return new Object[]{ns.stringToQualifiedName(qd.id, pf), pf.getName().PROV_QUALIFIED_NAME};
        }
        if (v instanceof VDescriptor) {
            VDescriptor vd = (VDescriptor)v;
            if (vd.language != null) {
                return new Object[]{pf.newInternationalizedString(vd.value, vd.language), pf.getName().XSD_STRING};
            }
            if (vd.type != null) {
                String[] strings = vd.type.split(":");
                String prefix = "";
                String local = vd.type;
                if (strings.length > 1) {
                    prefix = strings[0];
                    local = strings[1];
                }
                String namespace = "http://foo/";
                namespace = context.getOrDefault(prefix, namespace);
                if ("xsd".equals(prefix)) {
                    namespace = "http://www.w3.org/2001/XMLSchema#";
                }
                return new Object[]{vd.value, pf.newQualifiedName(namespace, local, prefix)};
            }
            return new Object[]{vd.value, pf.getName().XSD_STRING};
        }
        throw new UnsupportedOperationException("bean is " + v.getClass());
    }

    public static OldBindings fromBean(Bindings bean, ProvFactory pf) {
        OldBindings result = new OldBindings(pf);
        Namespace ns = new Namespace(bean.context);
        if (bean.var != null) {
            BindingsJson.fromBeanForVariables(bean, pf, bean.var, ns, result, VAR_KIND.IS_VAR);
        }
        if (bean.vargen != null) {
            BindingsJson.fromBeanForVariables(bean, pf, bean.vargen, ns, result, VAR_KIND.IS_VARGEN);
        }
        return result;
    }

    private static void fromBeanForVariables(Bindings bean, ProvFactory pf, Map<String, Descriptors> var, Namespace ns, OldBindings result, VAR_KIND varKind) {
        for (String key : var.keySet()) {
            int i = 0;
            LinkedList allvalues = new LinkedList();
            boolean single_value = true;
            Descriptors descriptors = var.get(key);
            for (Descriptor descriptor : descriptors.values) {
                SingleDescriptors wrapped;
                if (descriptor instanceof SingleDescriptor) {
                    wrapped = new SingleDescriptors();
                    wrapped.values = new LinkedList<SingleDescriptor>();
                    wrapped.values.add((SingleDescriptor)descriptor);
                } else if (descriptor instanceof SingleDescriptors) {
                    wrapped = (SingleDescriptors)descriptor;
                    single_value = false;
                } else {
                    throw new IllegalArgumentException("Unexpected type " + descriptor.getClass());
                }
                int count = 0;
                LinkedList<Attribute> values = new LinkedList<Attribute>();
                for (SingleDescriptor o : wrapped.values) {
                    Object[] conversion = BindingsJson.convertBeanToValue(o, bean.context, ns, pf);
                    Object theValue = conversion[0];
                    QualifiedName type = (QualifiedName)conversion[1];
                    if (!type.equals((Object)pf.getName().PROV_QUALIFIED_NAME)) {
                        single_value = false;
                    }
                    values.add(pf.newAttribute("http://openprovenance.org/tmpl#", "2dvalue_" + i + "_" + count, "tmpl", theValue, type));
                    ++count;
                }
                allvalues.add(values);
                ++i;
            }
            QualifiedName myvar = varKind.equals((Object)VAR_KIND.IS_VAR) ? pf.newQualifiedName("http://openprovenance.org/var#", key, "var") : pf.newQualifiedName("http://openprovenance.org/vargen#", key, "vargen");
            result.getAttributes().put(myvar, allvalues);
            if (!single_value) continue;
            LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
            for (Descriptor o : descriptors.values) {
                Object[] conversion = BindingsJson.convertBeanToValue(o, bean.context, ns, pf);
                Object theValue = conversion[0];
                ll.add((QualifiedName)theValue);
            }
            result.getVariables().put(myvar, ll);
        }
    }

    private static BindingsBean importBean(JsonNode json) {
        try {
            return (BindingsBean)mapper.treeToValue((TreeNode)json, BindingsBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON conversion to bean failed", (Exception)e);
        }
    }

    public static Bindings importBindings(JsonNode json) {
        try {
            return (Bindings)mapper.treeToValue((TreeNode)json, Bindings.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON conversion to bean failed", (Exception)e);
        }
    }

    public static OldBindings getOldBindingsFromSchema(JsonNode bindings_schema, ProvFactory provFactory) {
        return Conversions.fromBean(BindingsJson.importBean(bindings_schema), provFactory);
    }

    public static OldBindings getBindingsFromSchema(JsonNode bindings_schema, ProvFactory provFactory) {
        return BindingsJson.fromBean(BindingsJson.importBindings(bindings_schema), provFactory);
    }

    static enum VAR_KIND {
        IS_VAR,
        IS_VARGEN;

    }
}

