/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.LangString;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.expander.BindingsJson;
import org.openprovenance.prov.template.expander.OldBindings;
import org.openprovenance.prov.template.expander.deprecated.BindingsBean;

@Deprecated
public class Conversions {
    static OldBindings fromBean(BindingsBean bean, ProvFactory pf) {
        OldBindings result = new OldBindings(pf);
        Namespace ns = new Namespace(bean.context);
        for (Map.Entry<String, List<Object>> bindings : bean.var.entrySet()) {
            String var = bindings.getKey();
            int i = 0;
            LinkedList allvalues = new LinkedList();
            boolean single_value = true;
            for (Object value : bindings.getValue()) {
                LinkedList<Object> wrapped;
                if (!(value instanceof List)) {
                    wrapped = new LinkedList<Object>();
                    wrapped.add(value);
                } else {
                    wrapped = (LinkedList<Object>)value;
                    single_value = false;
                }
                int count = 0;
                LinkedList<Attribute> values = new LinkedList<Attribute>();
                for (Object e : wrapped) {
                    Object[] conversion = Conversions.convertBeanToValue(e, bean.context, ns, pf);
                    Object theValue = conversion[0];
                    QualifiedName type = (QualifiedName)conversion[1];
                    if (!type.equals((Object)pf.getName().PROV_QUALIFIED_NAME)) {
                        single_value = false;
                    }
                    values.add(pf.newAttribute("http://openprovenance.org/tmpl#", "2dvalue_" + i + "_" + count, "tmpl", theValue, type));
                    ++count;
                }
                allvalues.add(values);
                ++i;
            }
            QualifiedName myvar = pf.newQualifiedName("http://openprovenance.org/var#", var, "var");
            result.getAttributes().put(myvar, allvalues);
            if (!single_value) continue;
            LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
            for (Object o : bindings.getValue()) {
                Object[] conversion = Conversions.convertBeanToValue(o, bean.context, ns, pf);
                Object theValue = conversion[0];
                ll.add((QualifiedName)theValue);
            }
            result.getVariables().put(myvar, ll);
        }
        return result;
    }

    public static void exportBean(String output_file1, BindingsBean bean, boolean pretty) {
        try {
            if (pretty) {
                BindingsJson.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(output_file1), (Object)bean);
            } else {
                BindingsJson.mapper.writeValue(new File(output_file1), (Object)bean);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", (Exception)e);
        }
    }

    public static BindingsBean importBean(File input_file1) {
        try {
            return (BindingsBean)BindingsJson.mapper.readValue(input_file1, BindingsBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", (Exception)e);
        }
    }

    public static OldBindings fromDocument_v2(Document doc, ProvFactory pf) {
        OldBindings result = new OldBindings(pf);
        List entities = OldBindings.u.getEntity(doc);
        for (Entity entity : entities) {
            int size2;
            Object attr22;
            HashMap<Integer, QualifiedName> map = new HashMap<Integer, QualifiedName>();
            HashMap<Integer, Set> map_v2 = new HashMap<Integer, Set>();
            for (Object attr22 : entity.getOther()) {
                String uri = attr22.getElementName().getUri();
                if (uri.startsWith("http://openprovenance.org/tmpl#binding_")) {
                    String index = uri.substring("http://openprovenance.org/tmpl#binding_".length());
                    Integer n = Integer.valueOf(index);
                    map_v2.computeIfAbsent(n, k -> new HashSet());
                    ((Set)map_v2.get(n)).add(attr22);
                    continue;
                }
                if (!uri.startsWith("http://openprovenance.org/tmpl#value_")) continue;
                Iterator i = Integer.valueOf(uri.substring("http://openprovenance.org/tmpl#value_".length()));
                map_v2.computeIfAbsent((Integer)((Object)i), k -> new HashSet());
                ((Set)map_v2.get(i)).add(attr22);
            }
            boolean single_map = true;
            attr22 = map_v2.keySet().iterator();
            while (attr22.hasNext()) {
                int i = (Integer)attr22.next();
                if (!(single_map = single_map && ((Set)map_v2.get(i)).size() == 1)) continue;
                for (TypedValue typedValue : (Set)map_v2.get(i)) {
                    single_map = typedValue.getValue() instanceof QualifiedName;
                }
            }
            if (single_map) {
                attr22 = map_v2.keySet().iterator();
                while (attr22.hasNext()) {
                    int i = (Integer)attr22.next();
                    for (TypedValue typedValue : (Set)map_v2.get(i)) {
                        map.put(i, (QualifiedName)typedValue.getValue());
                    }
                }
            }
            ArrayList ll = new ArrayList();
            int size = map.entrySet().size();
            if (size > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    OldBindings.set((Integer)entry.getKey(), ll, (QualifiedName)entry.getValue());
                }
                result.getVariables().put(entity.getId(), ll);
            }
            if ((size2 = map_v2.entrySet().size()) <= 0) continue;
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry1 : map_v2.entrySet()) {
                LinkedList<Attribute> values = new LinkedList<Attribute>();
                int count = 0;
                for (TypedValue tv : (Set)entry1.getValue()) {
                    Other o;
                    String uri;
                    if (tv instanceof Other && (uri = (o = (Other)tv).getElementName().getUri()).startsWith("http://openprovenance.org/tmpl#binding_")) {
                        Integer i = Integer.valueOf(uri.substring("http://openprovenance.org/tmpl#binding_".length()));
                        values.add(pf.newAttribute("http://openprovenance.org/tmpl#", "2dvalue_" + i + "_" + count, "tmpl", o.getValue(), o.getType()));
                    }
                    ++count;
                }
                OldBindings.set((Integer)entry1.getKey(), linkedList, values);
            }
            result.getAttributes().put(entity.getId(), linkedList);
        }
        return result;
    }

    private static Object[] convertBeanToValue(Object v, Map<String, String> context, Namespace ns, ProvFactory pf) {
        if (v instanceof Integer) {
            return new Object[]{v, pf.getName().XSD_INT};
        }
        if (v instanceof Float) {
            return new Object[]{v, pf.getName().XSD_FLOAT};
        }
        if (v instanceof Boolean) {
            return new Object[]{v, pf.getName().XSD_BOOLEAN};
        }
        if (v instanceof QualifiedName) {
            return new Object[]{v, pf.getName().PROV_QUALIFIED_NAME};
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.startsWith("{")) {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    v = mapper.readValue((String)v, Hashtable.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                return new Object[]{v, pf.getName().XSD_STRING};
            }
        }
        if (v instanceof Map) {
            Map table = (Map)v;
            String lang = (String)table.get("@language");
            String value = (String)table.get("@value");
            String type = (String)table.get("@type");
            String id = (String)table.get("@id");
            if (lang != null) {
                return new Object[]{pf.newInternationalizedString(value, lang), pf.getName().XSD_STRING};
            }
            if (id != null) {
                return new Object[]{ns.stringToQualifiedName(id, pf), pf.getName().PROV_QUALIFIED_NAME};
            }
            if (type != null) {
                String[] strings = type.split(":");
                String prefix = "";
                String local = type;
                if (strings.length > 1) {
                    prefix = strings[0];
                    local = strings[1];
                }
                String namespace = "http://foo/";
                namespace = context.getOrDefault(prefix, namespace);
                if ("xsd".equals(prefix)) {
                    namespace = "http://www.w3.org/2001/XMLSchema#";
                }
                return new Object[]{value, pf.newQualifiedName(namespace, local, prefix)};
            }
            System.out.println("===> ?? " + table);
            return new Object[]{value, pf.newQualifiedName("xal", "xbl", "cxl")};
        }
        throw new UnsupportedOperationException("bean is " + v.getClass());
    }

    public static BindingsBean toBean(OldBindings bindings) {
        LinkedList<Object> l1;
        BindingsBean bean = new BindingsBean();
        bean.var = new HashMap<String, List<Object>>();
        bean.vargen = new HashMap<String, List<Object>>();
        bean.context = new HashMap<String, String>();
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : bindings.getVariables().entrySet()) {
            l1 = new LinkedList<Object>();
            for (QualifiedName qualifiedName : entry.getValue()) {
                l1.add(Conversions.convertValueToBean(qualifiedName, null, bean.context));
                if (entry.getKey().getNamespaceURI().startsWith("http://openprovenance.org/vargen#")) {
                    bean.vargen.put(entry.getKey().getLocalPart(), l1);
                    continue;
                }
                bean.var.put(entry.getKey().getLocalPart(), l1);
            }
        }
        for (Map.Entry<QualifiedName, List<Object>> entry : bindings.getAttributes().entrySet()) {
            l1 = new LinkedList();
            for (List list : entry.getValue()) {
                if (list.size() == 1) {
                    l1.add(Conversions.convertValueToBean(((TypedValue)list.get(0)).getValue(), ((TypedValue)list.get(0)).getType(), bean.context));
                    continue;
                }
                LinkedList<Object> l2 = new LinkedList<Object>();
                for (TypedValue tv : list) {
                    l2.add(Conversions.convertValueToBean(tv.getValue(), tv.getType(), bean.context));
                }
                l1.add(l2);
            }
            if (entry.getKey().getNamespaceURI().startsWith("http://openprovenance.org/vargen#")) {
                bean.vargen.put(entry.getKey().getLocalPart(), l1);
                continue;
            }
            bean.var.put(entry.getKey().getLocalPart(), l1);
        }
        return bean;
    }

    static Object convertValueToBean(Object o, QualifiedName type, Map<String, String> context) {
        if (o instanceof Integer) {
            return o;
        }
        if (o instanceof Float) {
            return o;
        }
        if (o instanceof Boolean) {
            return o;
        }
        if (o instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)o;
            HashMap<String, CallSite> table = new HashMap<String, CallSite>();
            table.put("@id", (CallSite)((Object)(qn.getPrefix() + ":" + qn.getLocalPart())));
            context.put(qn.getPrefix(), qn.getNamespaceURI());
            return table;
        }
        if (o instanceof LangString) {
            LangString qn = (LangString)o;
            HashMap<String, String> table = new HashMap<String, String>();
            if (qn.getLang() != null) {
                table.put("@language", qn.getLang());
            }
            table.put("@value", qn.getValue());
            return table;
        }
        if (o instanceof String) {
            if (type == null || type.getUri().equals("http://www.w3.org/2001/XMLSchema#string")) {
                return o;
            }
            HashMap<String, Object> table = new HashMap<String, Object>();
            table.put("@type", type.getPrefix() + ":" + type.getLocalPart());
            table.put("@value", o.toString());
            return table;
        }
        throw new UnsupportedOperationException("type is " + o);
    }

    public static BindingsBean importBean(InputStream input_file1) {
        try {
            return (BindingsBean)BindingsJson.mapper.readValue(input_file1, BindingsBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UncheckedException("JSON serialization failed", (Exception)e);
        }
    }
}

