/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.Other;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.template.expander.Conversions;
import org.openprovenance.prov.template.expander.deprecated.BindingsBean;

public class OldBindings {
    public static final String VALUE = "value_";
    public static final String VALUE2 = "2dvalue_";
    public static final String APP_VALUE = "http://openprovenance.org/tmpl#value_";
    public static final String VALUE_v2 = "binding_";
    public static final String APP_VALUE_v2 = "http://openprovenance.org/tmpl#binding_";
    public static final String APP_VALUE2 = "http://openprovenance.org/tmpl#2dvalue_";
    private final Map<QualifiedName, List<QualifiedName>> variables;
    private final Map<QualifiedName, List<List<TypedValue>>> attributes;
    private final ProvFactory pf;
    private final Name name;
    static ProvUtilities u = new ProvUtilities();

    public OldBindings(ProvFactory pf) {
        this(new HashMap<QualifiedName, List<QualifiedName>>(), new HashMap<QualifiedName, List<List<TypedValue>>>(), pf);
    }

    public OldBindings(HashMap<QualifiedName, List<QualifiedName>> variables, HashMap<QualifiedName, List<List<TypedValue>>> attributes, ProvFactory pf) {
        this.variables = variables;
        this.attributes = attributes;
        this.pf = pf;
        this.name = pf.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof OldBindings)) {
            return false;
        }
        OldBindings b = (OldBindings)o;
        return b.variables.equals(this.variables) && b.attributes.equals(this.attributes);
    }

    public Map<QualifiedName, List<QualifiedName>> getVariables() {
        return this.variables;
    }

    public Map<QualifiedName, List<List<TypedValue>>> getAttributes() {
        return this.attributes;
    }

    public void addVariable(QualifiedName name, QualifiedName val) {
        this.variables.computeIfAbsent(name, k -> new LinkedList());
        this.variables.get(name).add(val);
    }

    public void addVariable(String name, QualifiedName val) {
        this.addVariable(this.b_var(name), val);
    }

    public void addAttribute(QualifiedName name, List<TypedValue> values) {
        this.attributes.computeIfAbsent(name, k -> new LinkedList());
        this.attributes.get(name).add(values);
    }

    public void addAttribute(String name, QualifiedName value) {
        this.addAttribute(this.b_var(name), this.a_val(value));
    }

    public void addAttribute(String name, String value) {
        this.addAttribute(this.b_var(name), this.a_val(value));
    }

    public QualifiedName b_var(String name) {
        return this.pf.newQualifiedName("http://openprovenance.org/var#", name, "var");
    }

    public List<TypedValue> a_val(String s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pf.newAttribute(this.pf.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.XSD_STRING));
        return ll;
    }

    public List<TypedValue> a_val(QualifiedName s) {
        LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
        ll.add((TypedValue)this.pf.newAttribute(this.pf.newQualifiedName("http://openprovenance.org/tmpl#", "ignore", "app"), (Object)s, this.name.PROV_QUALIFIED_NAME));
        return ll;
    }

    public String toString() {
        return "[" + this.getVariables() + " -- " + this.getAttributes() + "]";
    }

    @Deprecated
    public Document toDocument_v1() {
        LinkedList<Statement> ll = new LinkedList<Statement>();
        this.add1DValues_v1(ll, this.variables);
        this.add2Dvalues_v1(ll, this.attributes);
        Document dummy = this.pf.newDocument(null, ll, new LinkedList());
        return this.pf.newDocument(this.pf.newNamespace(Namespace.gatherNamespaces((Document)dummy)), ll, new LinkedList());
    }

    public Document toDocument_v2() {
        LinkedList<Statement> ll = new LinkedList<Statement>();
        this.add1DValues_v2(ll, this.variables);
        this.add2Dvalues_v2(ll, this.attributes);
        Document dummy = this.pf.newDocument(null, ll, new LinkedList());
        return this.pf.newDocument(this.pf.newNamespace(Namespace.gatherNamespaces((Document)dummy)), ll, new LinkedList());
    }

    public void add2Dvalues_v1(List<Statement> ll, Map<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            int count1 = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (List<TypedValue> vals : entry.getValue()) {
                int count2 = 0;
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE2 + count1 + "_" + count2, "tmpl", val.getValue(), val.getType()));
                    ++count2;
                }
                ++count1;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public void add2Dvalues_v2(List<Statement> ll, Map<QualifiedName, List<List<TypedValue>>> attributes) {
        for (Map.Entry<QualifiedName, List<List<TypedValue>>> entry : attributes.entrySet()) {
            int count1 = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (List<TypedValue> vals : entry.getValue()) {
                for (TypedValue val : vals) {
                    attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE_v2 + count1, "tmpl", val.getValue(), val.getType()));
                }
                ++count1;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public void add1DValues_v1(List<Statement> ll, Map<QualifiedName, List<QualifiedName>> variables) {
        this.add1DValues(ll, variables, VALUE);
    }

    public void add1DValues_v2(List<Statement> ll, Map<QualifiedName, List<QualifiedName>> variables) {
        this.add1DValues(ll, variables, VALUE_v2);
    }

    private void add1DValues(List<Statement> ll, Map<QualifiedName, List<QualifiedName>> variables, String valuev2) {
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : variables.entrySet()) {
            int count = 0;
            LinkedList<Attribute> attrs = new LinkedList<Attribute>();
            for (QualifiedName qn : entry.getValue()) {
                attrs.add(this.pf.newAttribute("http://openprovenance.org/tmpl#", valuev2 + count, "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
            }
            Entity e = this.pf.newEntity(entry.getKey(), attrs);
            ll.add((Statement)e);
        }
    }

    public static OldBindings fromDocument_v1(Document doc, ProvFactory pf) {
        OldBindings result = new OldBindings(pf);
        List entities = u.getEntity(doc);
        for (Entity entity : entities) {
            int size2;
            HashMap<Integer, QualifiedName> map = new HashMap<Integer, QualifiedName>();
            HashMap<Integer, Map> map2 = new HashMap<Integer, Map>();
            for (Other attr : entity.getOther()) {
                String uri = attr.getElementName().getUri();
                if (uri.startsWith(APP_VALUE)) {
                    Integer n = Integer.valueOf(uri.substring(APP_VALUE.length()));
                    if (!(attr.getValue() instanceof QualifiedName)) continue;
                    map.put(n, (QualifiedName)attr.getValue());
                    continue;
                }
                if (!uri.startsWith(APP_VALUE2)) continue;
                String string = uri.substring(APP_VALUE2.length());
                String[] nums = string.split("_");
                Integer i = Integer.valueOf(nums[0]);
                Integer j = Integer.valueOf(nums[1]);
                map2.computeIfAbsent(i, k -> new HashMap());
                ((Map)map2.get(i)).put(j, attr);
            }
            ArrayList ll = new ArrayList();
            int size = map.entrySet().size();
            if (size > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    OldBindings.set((Integer)entry.getKey(), ll, (QualifiedName)entry.getValue());
                }
                result.getVariables().put(entity.getId(), ll);
            }
            if ((size2 = map2.entrySet().size()) <= 0) continue;
            LinkedList linkedList = new LinkedList();
            for (Map.Entry entry1 : map2.entrySet()) {
                LinkedList values = new LinkedList();
                for (Map.Entry entry2 : ((Map)entry1.getValue()).entrySet()) {
                    OldBindings.set((Integer)entry2.getKey(), values, (TypedValue)entry2.getValue());
                }
                OldBindings.set((Integer)entry1.getKey(), linkedList, values);
            }
            result.getAttributes().put(entity.getId(), linkedList);
        }
        return result;
    }

    public void addVariableBindingsAsAttributeBindings() {
        Map<QualifiedName, List<QualifiedName>> vb = this.getVariables();
        for (Map.Entry<QualifiedName, List<QualifiedName>> entry : vb.entrySet()) {
            int count = 0;
            for (QualifiedName qn : entry.getValue()) {
                LinkedList<TypedValue> ll = new LinkedList<TypedValue>();
                ll.add((TypedValue)this.pf.newAttribute("http://openprovenance.org/tmpl#", VALUE2 + count + "_0", "tmpl", (Object)qn, this.pf.getName().PROV_QUALIFIED_NAME));
                ++count;
                this.addAttribute(entry.getKey(), ll);
            }
        }
    }

    public static <E> void set(int pos, List<E> ll, E val) {
        int size;
        for (int i = size = ll.size(); i <= pos; ++i) {
            ll.add(null);
        }
        ll.set(pos, val);
    }

    public void exportToJson(String filename) {
        BindingsBean bb = Conversions.toBean(this);
        Conversions.exportBean(filename, bb, true);
    }
}

