/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.template.expander.BindingsJson;
import org.openprovenance.prov.template.expander.ExpandAction;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.expander.Groupings;
import org.openprovenance.prov.template.expander.OldBindings;
import org.openprovenance.prov.template.expander.Using;
import org.openprovenance.prov.template.json.Bindings;

public class Expand {
    static Logger logger = LogManager.getLogger(Expand.class);
    private final boolean addOrderp;
    private final boolean allUpdatedRequired;
    private final ProvFactory pf;
    static ProvUtilities u = new ProvUtilities();
    boolean allExpanded = true;

    public Expand(ProvFactory pf, boolean addOrderp, boolean allUpdatedRequired) {
        this.pf = pf;
        this.addOrderp = addOrderp;
        this.allUpdatedRequired = allUpdatedRequired;
    }

    public Document expander(Document docIn, Bindings bindings) {
        Bundle bun;
        logger.info("expander: expander " + bindings);
        try {
            bun = (Bundle)u.getBundle(docIn).get(0);
        }
        catch (RuntimeException e) {
            throw new UncheckedException("Bundle missing in template", (Exception)e);
        }
        Groupings grp1 = Groupings.fromDocument(docIn);
        logger.debug("expander: Found groupings " + grp1);
        Bundle bun1 = (Bundle)this.expand(bun, bindings, grp1).get(0);
        Document doc1 = this.pf.newDocument();
        doc1.getStatementOrBundle().add(bun1);
        logger.info("expander: id uri " + bun1.getId().getNamespaceURI());
        logger.info("expander: id pre " + bun1.getId().getPrefix());
        logger.info("expander: id loc " + bun1.getId().getLocalPart());
        bun1.setNamespace(Namespace.gatherNamespaces((Bundle)bun1));
        doc1.setNamespace(new Namespace());
        return doc1;
    }

    public List<StatementOrBundle> expand(Statement statement, OldBindings oldBindings, Groupings grp1) {
        Using us1 = ExpandUtil.usedGroups(statement, grp1, oldBindings);
        return this.expand(statement, oldBindings, grp1, us1);
    }

    public boolean getAllExpanded() {
        return this.allExpanded;
    }

    public List<StatementOrBundle> expand(Bundle bun, Bindings bindings, Groupings grp1) {
        OldBindings legacyBindings = BindingsJson.fromBean(bindings, this.pf);
        HashMap<QualifiedName, QualifiedName> env0 = new HashMap<QualifiedName, QualifiedName>();
        HashMap<QualifiedName, List<TypedValue>> env1 = new HashMap<QualifiedName, List<TypedValue>>();
        ExpandAction action = new ExpandAction(this.pf, u, this, env0, env1, null, legacyBindings, grp1, this.addOrderp, this.allUpdatedRequired);
        u.doAction((StatementOrBundle)bun, (StatementAction)action);
        this.allExpanded = this.allExpanded && action.getAllExpanded();
        return action.getList();
    }

    public List<StatementOrBundle> expand(Statement statement, OldBindings bindings1, Groupings grp1, Using us1) {
        LinkedList<StatementOrBundle> results = new LinkedList<StatementOrBundle>();
        Iterator<List<Integer>> iter = us1.iterator();
        while (iter.hasNext()) {
            List<Integer> index = iter.next();
            Map<QualifiedName, QualifiedName> env = us1.get(bindings1, grp1, index);
            Map<QualifiedName, List<TypedValue>> env2 = us1.getAttr(ExpandUtil.freeAttributeVariables(statement, this.pf), bindings1, (Using.UsingIterator)iter);
            ExpandAction action = new ExpandAction(this.pf, u, this, env, env2, index, bindings1, grp1, this.addOrderp, this.allUpdatedRequired);
            u.doAction((StatementOrBundle)statement, (StatementAction)action);
            this.allExpanded = this.allExpanded && action.getAllExpanded();
            results.addAll(action.getList());
        }
        return results;
    }
}

