/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.json.Bindings;

public class Groupings {
    private final List<List<QualifiedName>> variables = new LinkedList<List<QualifiedName>>();
    static ProvUtilities u = new ProvUtilities();

    public List<QualifiedName> get(int group) {
        return this.variables.get(group);
    }

    public int size() {
        return this.variables.size();
    }

    public void addVariable(QualifiedName name) {
        LinkedList<QualifiedName> ll = new LinkedList<QualifiedName>();
        ll.add(name);
        this.variables.add(ll);
    }

    public void addVariable(int group, QualifiedName name) {
        List<QualifiedName> v = this.variables.get(group);
        v.add(name);
    }

    public String toString() {
        return "" + this.variables;
    }

    public static Groupings fromDocument(Document doc, Bindings bindings, ProvFactory pf) {
        Object blinked;
        Hashtable<QualifiedName, Set<QualifiedName>> linked = new Hashtable<QualifiedName, Set<QualifiedName>>();
        Hashtable<QualifiedName, Integer> linkedGroups = new Hashtable<QualifiedName, Integer>();
        Bundle bun = (Bundle)u.getBundle(doc).get(0);
        Groupings grps = new Groupings();
        HashSet<QualifiedName> allVars = new HashSet<QualifiedName>();
        for (Object statement : bun.getStatement()) {
            Set<QualifiedName> vars = ExpandUtil.freeVariables((Statement)statement);
            allVars.addAll(vars);
            if (!(statement instanceof HasOther)) continue;
            HasOther stmt2 = (HasOther)statement;
            for (Object other : stmt2.getOther()) {
                if (!"http://openprovenance.org/tmpl#linked".equals(other.getElementName().getUri())) continue;
                QualifiedName id = ((Identifiable)statement).getId();
                QualifiedName otherId = (QualifiedName)other.getValue();
                Groupings.addEntry(linked, otherId, id);
                Groupings.addEntry(linked, id, otherId);
            }
        }
        if (bindings != null && (blinked = bindings.linked) != null) {
            for (String key : blinked.keySet()) {
                Groupings.addEntry(linked, ExpandUtil.newVariable(key, pf), ExpandUtil.newVariable((String)blinked.get(key), pf));
                Groupings.addEntry(linked, ExpandUtil.newVariable((String)blinked.get(key), pf), ExpandUtil.newVariable(key, pf));
            }
        }
        for (QualifiedName visit : linked.keySet()) {
            Stack<QualifiedName> toVisit = new Stack<QualifiedName>();
            toVisit.push(visit);
            HashSet<QualifiedName> reachable = new HashSet<QualifiedName>();
            while (!toVisit.isEmpty()) {
                QualifiedName local_qn = (QualifiedName)toVisit.pop();
                for (QualifiedName neighbour : (Set)linked.get(local_qn)) {
                    if (reachable.contains(neighbour)) continue;
                    reachable.add(neighbour);
                    toVisit.push(neighbour);
                }
            }
            ((Set)linked.get(visit)).addAll(reachable);
        }
        QualifiedName[] sorted = allVars.toArray(new QualifiedName[0]);
        Arrays.sort(sorted, Comparator.comparing(QualifiedName::getUri));
        int currentGroup = 0;
        for (QualifiedName qn : sorted) {
            Set links = (Set)linked.get(qn);
            if (links == null || links.isEmpty()) {
                grps.addVariable(qn);
            } else {
                Integer aGroup = (Integer)linkedGroups.get(qn);
                if (aGroup != null) {
                    grps.addVariable(aGroup, qn);
                } else {
                    grps.addVariable(qn);
                    for (QualifiedName otherQn : links) {
                        linkedGroups.put(otherQn, currentGroup);
                    }
                }
            }
            ++currentGroup;
        }
        return grps;
    }

    static void addEntry(Map<QualifiedName, Set<QualifiedName>> linked, QualifiedName id, QualifiedName otherId) {
        linked.computeIfAbsent(otherId, k -> new HashSet());
        linked.get(otherId).add(id);
    }
}

