/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander.meta;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.FileUtils;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.model.ProvDeserialiser;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.expander.meta.Config;
import org.openprovenance.prov.template.json.Bindings;
import org.openprovenance.prov.template.library.ptm_copy.client.common.Ptm_expandingBean;
import org.openprovenance.prov.template.library.ptm_copy.client.common.Ptm_expandingBuilder;
import org.openprovenance.prov.vanilla.ProvFactory;

public class Executor {
    private final Map<String, ProvSerialiser> serializerMap = new HashMap<String, ProvSerialiser>();
    private final Map<String, ProvDeserialiser> deserializerMap = new HashMap<String, ProvDeserialiser>();
    static Logger logger = LogManager.getLogger(Executor.class);
    private static final org.openprovenance.prov.model.ProvFactory pf = ProvFactory.getFactory();
    private static final ObjectMapper om = new ObjectMapper();
    private ProvDeserialiser deserialiser;
    Ptm_expandingBuilder builder = new Ptm_expandingBuilder();

    public Executor() {
        this.initializeSerializerDispatcher();
    }

    public void initializeSerializerDispatcher() {
        try {
            Class<?> c = Class.forName("org.openprovenance.prov.notation.ProvSerialiser");
            Constructor<?> cons = c.getConstructor(org.openprovenance.prov.model.ProvFactory.class);
            ProvSerialiser serialiser = (ProvSerialiser)cons.newInstance(pf);
            this.serializerMap.put("provn", serialiser);
            c = Class.forName("org.openprovenance.prov.dot.ProvSerialiser");
            cons = c.getConstructor(org.openprovenance.prov.model.ProvFactory.class, String.class);
            ProvSerialiser serialiser2 = (ProvSerialiser)cons.newInstance(pf, "png");
            this.serializerMap.put("png", serialiser2);
            ProvSerialiser serialiser3 = (ProvSerialiser)cons.newInstance(pf, "svg");
            this.serializerMap.put("svg", serialiser3);
            c = Class.forName("org.openprovenance.prov.notation.ProvDeserialiser");
            cons = c.getConstructor(org.openprovenance.prov.model.ProvFactory.class);
            this.deserialiser = (ProvDeserialiser)cons.newInstance(pf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.throwing((Throwable)e);
        }
    }

    public static Config load(String configurationPath, ObjectMapper objectMapper) {
        try {
            return (Config)objectMapper.readValue(new File(configurationPath), Config.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int execute(String basedir, String configurationPath) {
        try {
            configurationPath = basedir + "/" + (String)configurationPath;
            System.out.println("In executor " + (String)configurationPath);
            Config config = Executor.load((String)configurationPath, om);
            String localdir = new File((String)configurationPath).getParent();
            HashMap<String, String> variableMap = new HashMap<String, String>();
            if (config.variableMaps != null) {
                for (String string : config.variableMaps) {
                    String string2 = localdir + "/" + string;
                    System.out.println("loading variable map " + string2);
                    variableMap.putAll((Map)om.readValue((InputStream)new FileInputStream(string2), Map.class));
                }
            }
            return this.execute(config, basedir, variableMap);
        }
        catch (Exception e) {
            logger.error("Error while executing", (Throwable)e);
            return 1;
        }
    }

    public int execute(Config config, String basedir, Map<String, String> variableMap) throws IOException {
        config.mtemplate_dir = Config.addBaseDir(basedir, config.mtemplate_dir);
        config.mbindings_dir = Config.addBaseDir(basedir, config.mbindings_dir);
        config.expand_dir = Config.addBaseDir(basedir, config.expand_dir);
        logger.info("mtemplate_dirs: " + config.mtemplate_dir);
        logger.info("mbindings_dir: " + config.mbindings_dir);
        logger.info("expand_dir: " + config.expand_dir);
        FileUtils.mkdir((File)new File(config.expand_dir), (boolean)true);
        block8: for (Config.ConfigTask task : config.tasks) {
            task.mtemplate_dir = Config.addBaseDir(basedir, task.mtemplate_dir);
            logger.info("task: " + task);
            switch (task.type) {
                case "expansion": {
                    this.executeExpandTask(config, task, variableMap);
                    continue block8;
                }
                case "merge": {
                    this.executeMergeTask(config, task, variableMap);
                    continue block8;
                }
            }
            logger.error("Unknown task type " + task.type);
            return 1;
        }
        return 0;
    }

    public void executeExpandTask(Config config, Config.ConfigTask task, Map<String, String> variableMap) throws IOException {
        String bindingsFilename = config.mbindings_dir + "/" + task.bindings;
        InputStream is = this.substituteVariablesInFile(variableMap, bindingsFilename);
        Expand expand = new Expand(pf, false, false);
        List<String> mtemplate_dir = task.mtemplate_dir == null ? config.mtemplate_dir : task.mtemplate_dir;
        Pair<FileInputStream, File> fileinDirs = this.findFileinDirs2(mtemplate_dir, task.input);
        long secondsSince2023_01_01 = (System.currentTimeMillis() - 1672531200000L) / 1000L;
        LinkedList<String> loggedRecords = new LinkedList<String>();
        Document doc = expand.expander(this.deserialise((FileInputStream)fileinDirs.getLeft()), (Bindings)om.readValue(is, Bindings.class));
        for (String format : task.formats) {
            String documentFilename = config.expand_dir + "/" + task.output + "." + format;
            this.serialize(new FileOutputStream(documentFilename), format, doc, false);
            if (task.copyinput != null && task.copyinput.booleanValue()) {
                this.serialize(new FileOutputStream(config.expand_dir + "/" + task.input.replace(".provn", "." + format)), format, doc, false);
            }
            String csvRecord = this.createExpansionCsvRecord(task, format, fileinDirs, secondsSince2023_01_01);
            loggedRecords.add(csvRecord);
        }
        this.exportProvenanceAsCsv(config, task, loggedRecords);
    }

    private void exportProvenanceAsCsv(Config config, Config.ConfigTask task, List<String> loggedRecords) throws IOException {
        if (task.hasProvenance != null) {
            try (FileOutputStream fos = new FileOutputStream(config.expand_dir + "/" + task.hasProvenance);){
                for (String csvRecord : loggedRecords) {
                    fos.write(csvRecord.getBytes(StandardCharsets.UTF_8));
                    fos.write("\n".getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    private String createExpansionCsvRecord(Config.ConfigTask task, String format, Pair<FileInputStream, File> fileinDirs, long secondsSince2023_01_01) {
        Ptm_expandingBean bean = new Ptm_expandingBean();
        bean.bindings = task.bindings;
        bean.provenance = task.hasProvenance;
        bean.time = pf.newTimeNow().toString();
        bean.template = ((File)fileinDirs.getRight()).getName();
        bean.document = task.output + "." + format;
        bean.expanding = Long.valueOf(secondsSince2023_01_01).intValue();
        return bean.process(this.builder.args2csv());
    }

    public void executeMergeTask(Config config, Config.ConfigTask task, Map<String, String> variableMap) throws IOException {
        Expand expand = new Expand(pf, false, false);
        List<String> mtemplate_dir = task.mtemplate_dir == null ? config.mtemplate_dir : task.mtemplate_dir;
        Document doc1 = this.deserialise(this.findFileinDirs(mtemplate_dir, task.input));
        Document doc2 = this.deserialise(this.findFileinDirs(mtemplate_dir, task.input2));
        Document doc3 = new IndexedDocument(pf, doc1, false).merge(doc2).toDocument();
        for (String format : task.formats) {
            this.serialize(new FileOutputStream(config.expand_dir + "/" + task.output + "." + format), format, doc3, false);
        }
        if (task.clean2 != null && task.clean2.booleanValue()) {
            for (String format : task.formats) {
                for (String dir : mtemplate_dir) {
                    File f = new File(dir + "/" + task.input2.replace(".provn", "." + format));
                    if (!f.exists()) continue;
                    f.delete();
                }
            }
        }
    }

    private FileInputStream findFileinDirs(List<String> mtemplate_dir, String filename) throws FileNotFoundException {
        for (String dir : mtemplate_dir) {
            File f = new File(dir + "/" + filename);
            if (!f.exists()) continue;
            return new FileInputStream(f);
        }
        throw new FileNotFoundException(filename);
    }

    private Pair<FileInputStream, File> findFileinDirs2(List<String> mtemplate_dir, String filename) throws FileNotFoundException {
        for (String dir : mtemplate_dir) {
            File f = new File(dir + "/" + filename);
            if (!f.exists()) continue;
            return Pair.of((Object)new FileInputStream(f), (Object)f);
        }
        throw new FileNotFoundException(filename);
    }

    private InputStream substituteVariablesInFile(Map<String, String> variableMap, String filename) throws IOException {
        int numRead;
        StringSubstitutor subst = new StringSubstitutor(variableMap);
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8);
        while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, numRead);
        }
        subst.replaceIn(out);
        ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes(StandardCharsets.UTF_8));
        return is;
    }

    public Document deserialise(FileInputStream fileInputStream) {
        try {
            return this.deserialiser.deserialiseDocument((InputStream)fileInputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serialize(OutputStream fileOutputStream, String format, Document doc, boolean b) {
        this.serializerMap.get(format).serialiseDocument(fileOutputStream, doc, b);
    }

    public static void main(String[] args) {
        Executor executor = new Executor();
        String basedir = args[0];
        for (int i = 1; i < args.length; ++i) {
            executor.execute(basedir, args[i]);
        }
    }
}

