/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.template.expander.Groupings;
import org.openprovenance.prov.template.expander.OldBindings;
import org.openprovenance.prov.template.expander.exception.MissingAttributeValue;

public class Using
implements Iterable<List<Integer>> {
    private final List<Integer> groups = new LinkedList<Integer>();
    private final List<Integer> lengths = new LinkedList<Integer>();

    public void addGroup(Integer group, Integer length) {
        this.groups.add(group);
        this.lengths.add(length);
    }

    public List<Integer> zeroIndex() {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (Integer o : this.lengths) {
            result.add(0);
        }
        return result;
    }

    public boolean checkIndex(List<Integer> index) {
        if (index == null) {
            return this.groups.isEmpty();
        }
        if (index.size() == this.groups.size()) {
            int count = 0;
            for (Integer in : index) {
                if (in >= this.lengths.get(count)) {
                    return false;
                }
                ++count;
            }
            return true;
        }
        return false;
    }

    public List<Integer> nextIndex(List<Integer> index) {
        if (!this.checkIndex(index)) {
            throw new IllegalArgumentException(String.valueOf(index));
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        int count = 0;
        int carryOver = 1;
        for (Integer in : index) {
            int next = in + carryOver;
            if (next >= this.lengths.get(count)) {
                next = 0;
                carryOver = 1;
            } else {
                carryOver = 0;
            }
            ++count;
            result.add(next);
        }
        if (carryOver == 0) {
            return result;
        }
        return null;
    }

    public String toString() {
        return "<using:" + String.valueOf(this.groups) + "," + String.valueOf(this.lengths) + ">";
    }

    Map<QualifiedName, QualifiedName> get(OldBindings b, Groupings gr, List<Integer> index) {
        HashMap<QualifiedName, QualifiedName> result = new HashMap<QualifiedName, QualifiedName>();
        int count = 0;
        for (int ind : index) {
            int group = this.groups.get(count);
            for (QualifiedName var : gr.get(group)) {
                List<QualifiedName> ll = b.getVariables().get(var);
                if (ll == null) continue;
                QualifiedName val = ll.get(ind);
                result.put(var, val);
            }
            ++count;
        }
        return result;
    }

    public Map<QualifiedName, List<TypedValue>> getAttr(Set<QualifiedName> variables, OldBindings b, UsingIterator iter) {
        HashMap<QualifiedName, List<TypedValue>> result = new HashMap<QualifiedName, List<TypedValue>>();
        int ind = iter.getCount();
        for (QualifiedName var : variables) {
            List<List<TypedValue>> val = b.getAttributes().get(var);
            if (val == null) continue;
            try {
                List<TypedValue> attVal = val.get(ind);
                if (attVal == null) {
                    throw new MissingAttributeValue("Missing attribute value for variable " + String.valueOf(var) + ": index is " + ind + " and values are " + String.valueOf(val));
                }
                result.put(var, val.get(ind));
            }
            catch (IndexOutOfBoundsException excp) {
                throw new MissingAttributeValue("Missing attribute value for variable " + String.valueOf(var) + ": index is " + ind + " and values are " + String.valueOf(val), excp);
            }
        }
        return result;
    }

    @Override
    public Iterator<List<Integer>> iterator() {
        return new UsingIterator(this);
    }

    public class UsingIterator
    implements Iterator<List<Integer>> {
        List<Integer> currentIndex;
        boolean initialized = false;
        private Using u;
        private int count = -1;

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                return true;
            }
            return this.currentIndex != null && Using.this.nextIndex(this.currentIndex) != null;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public List<Integer> next() {
            if (!this.initialized) {
                this.currentIndex = this.u.zeroIndex();
                this.initialized = true;
                this.count = 0;
                return this.currentIndex;
            }
            if (this.currentIndex != null) {
                this.currentIndex = Using.this.nextIndex(this.currentIndex);
                if (this.currentIndex == null) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return this.currentIndex;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public UsingIterator(Using u) {
            this.u = u;
        }
    }
}

