/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.template.expander;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasOther;
import org.openprovenance.prov.model.HasTime;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.QualifiedNameUtils;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.TypedValue;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.template.expander.Expand;
import org.openprovenance.prov.template.expander.ExpandUtil;
import org.openprovenance.prov.template.expander.Groupings;
import org.openprovenance.prov.template.expander.OldBindings;
import org.openprovenance.prov.template.expander.exception.BundleVariableHasMultipleValues;
import org.openprovenance.prov.template.expander.exception.BundleVariableHasNoValue;

public class ExpandAction
implements StatementAction {
    public static final String UUID_PREFIX = "uuid";
    public static final String URN_UUID_NS = "urn:uuid:";
    private final ProvFactory pf;
    private final Expand expand;
    private final Map<QualifiedName, QualifiedName> env;
    private final ProvUtilities u;
    private final List<StatementOrBundle> ll = new LinkedList<StatementOrBundle>();
    private final List<Integer> index;
    private final OldBindings oldBindings;
    private final Groupings grp1;
    private final Map<QualifiedName, List<TypedValue>> env2;
    private final boolean addOrderp;
    private final String qualifiedNameURI;
    private final boolean allUpdatedRequired;
    private boolean allExpanded = true;
    boolean allowVariableInLabelAndTime = true;
    static final QualifiedNameUtils qnU = new QualifiedNameUtils();

    public boolean getAllExpanded() {
        return this.allExpanded;
    }

    public ExpandAction(ProvFactory pf, ProvUtilities u, Expand expand, Map<QualifiedName, QualifiedName> env, Map<QualifiedName, List<TypedValue>> env2, List<Integer> index, OldBindings oldBindings, Groupings grp1, boolean addOrderp, boolean allUpdatedRequired) {
        this.pf = pf;
        this.expand = expand;
        this.env = env;
        this.u = u;
        this.index = index;
        this.oldBindings = oldBindings;
        this.grp1 = grp1;
        this.env2 = env2;
        this.addOrderp = addOrderp;
        this.qualifiedNameURI = pf.getName().PROV_QUALIFIED_NAME.getUri();
        this.allUpdatedRequired = allUpdatedRequired;
    }

    public void doAction(Activity s) {
        Activity res = this.pf.newActivity(s.getId(), s.getStartTime(), s.getEndTime(), null);
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        boolean updated2 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2;
        boolean allUpdated = updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && updated1 && res.getId() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(Used s) {
        Used res = this.pf.newUsed(s.getId(), s.getActivity(), s.getEntity());
        res.setTime(s.getTime());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getActivity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName ag = res.getEntity();
        boolean updated3 = this.setExpand((Statement)res, ag, 2);
        boolean updated4 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4;
        boolean allUpdated = updated1 && updated2 && updated3;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(WasStartedBy s) {
        WasStartedBy res = this.pf.newWasStartedBy(s.getId(), s.getActivity(), s.getTrigger(), s.getStarter());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getActivity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName ag = res.getTrigger();
        boolean updated3 = this.setExpand((Statement)res, ag, 2);
        QualifiedName st = res.getStarter();
        boolean updated4 = this.setExpand((Statement)res, st, 3);
        boolean updated5 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4 || updated5;
        boolean allUpdated = updated1 && updated2 && updated3 && updated4;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(Agent e) {
        Agent res = this.pf.newAgent(e.getId());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        boolean updated2 = this.expandAttributes((Statement)e, (Statement)res);
        boolean updated = updated1 || updated2;
        boolean allUpdated = updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && updated1 && res.getId() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(AlternateOf s) {
        AlternateOf res = this.pf.newAlternateOf(s.getAlternate1(), s.getAlternate2());
        QualifiedName alt1 = res.getAlternate1();
        boolean updated0 = this.setExpand((Statement)res, alt1, 0);
        QualifiedName alt2 = res.getAlternate2();
        boolean updated1 = this.setExpand((Statement)res, alt2, 1);
        boolean updated = updated0 || updated1;
        boolean allUpdated = updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
    }

    public void doAction(WasAssociatedWith s) {
        WasAssociatedWith res = this.pf.newWasAssociatedWith(s.getId(), s.getActivity(), s.getAgent(), s.getPlan());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getActivity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName ag = res.getAgent();
        boolean updated3 = this.setExpand((Statement)res, ag, 2);
        QualifiedName pl = res.getPlan();
        boolean updated4 = this.setExpand((Statement)res, pl, 3);
        boolean updated5 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4 || updated5;
        boolean allUpdated = updated1 && updated2 && updated3 && updated4;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && updated3 && res.getAgent() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(WasAttributedTo s) {
        WasAttributedTo res = this.pf.newWasAttributedTo(s.getId(), s.getEntity(), s.getAgent());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getEntity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName ag = res.getAgent();
        boolean updated3 = this.setExpand((Statement)res, ag, 2);
        boolean updated4 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4;
        boolean allUpdated = updated1 && updated2 && updated3;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && res.getAgent() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(WasInfluencedBy s) {
    }

    public void doAction(ActedOnBehalfOf s) {
        ActedOnBehalfOf res = this.pf.newActedOnBehalfOf(s.getId(), s.getDelegate(), s.getResponsible(), s.getActivity());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName del = res.getDelegate();
        boolean updated2 = this.setExpand((Statement)res, del, 1);
        QualifiedName resp = res.getResponsible();
        boolean updated3 = this.setExpand((Statement)res, resp, 2);
        QualifiedName act = res.getActivity();
        boolean updated4 = this.setExpand((Statement)res, act, 3);
        boolean updated5 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4 || updated5;
        boolean allUpdated = updated1 && updated2 && updated3 && updated4;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && updated3 && res.getResponsible() != null && res.getDelegate() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(WasDerivedFrom s) {
        WasDerivedFrom res = this.pf.newWasDerivedFrom(s.getId(), s.getGeneratedEntity(), s.getUsedEntity());
        res.setActivity(s.getActivity());
        res.setUsage(s.getUsage());
        res.setGeneration(s.getGeneration());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en2 = res.getGeneratedEntity();
        boolean updated2 = this.setExpand((Statement)res, en2, 1);
        QualifiedName en1 = res.getUsedEntity();
        boolean updated3 = this.setExpand((Statement)res, en1, 2);
        QualifiedName act = res.getActivity();
        boolean updated4 = this.setExpand((Statement)res, act, 3);
        QualifiedName gen = res.getGeneration();
        boolean updated5 = this.setExpand((Statement)res, gen, 4);
        QualifiedName use = res.getUsage();
        boolean updated6 = this.setExpand((Statement)res, use, 5);
        boolean updated7 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4 || updated5 || updated6 || updated7;
        boolean allUpdated = updated1 && updated2 && updated3 && updated4 && updated5 && updated6;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(DictionaryMembership s) {
    }

    public void doAction(DerivedByRemovalFrom s) {
    }

    public void doAction(WasEndedBy s) {
        WasEndedBy res = this.pf.newWasEndedBy(s.getId(), s.getActivity(), s.getTrigger(), s.getEnder());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getActivity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName ag = res.getTrigger();
        boolean updated3 = this.setExpand((Statement)res, ag, 2);
        QualifiedName st = res.getEnder();
        boolean updated4 = this.setExpand((Statement)res, st, 3);
        boolean updated5 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4 || updated5;
        boolean allUpdated = updated1 && updated2 && updated3 && updated4;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(Entity e) {
        Entity res = this.pf.newEntity(e.getId());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        boolean updated2 = this.expandAttributes((Statement)e, (Statement)res);
        boolean updated = updated1 || updated2;
        boolean allUpdated = updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if ((!this.allUpdatedRequired || allUpdated) && updated1 && res.getId() != null) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public boolean expandAttributes(Statement srcStatement, Statement dstStatement) {
        boolean found = false;
        if (dstStatement instanceof HasOther) {
            Collection attributes = this.pf.getAttributes(srcStatement);
            LinkedList<Attribute> dstAttributes = new LinkedList<Attribute>();
            for (Attribute attribute : attributes) {
                if (ExpandUtil.isVariable(attribute.getElementName())) {
                    int count = 0;
                    List<TypedValue> typedValues = this.env2.get(attribute.getElementName());
                    if (typedValues == null) continue;
                    for (TypedValue val : typedValues) {
                        if (!this.qualifiedNameURI.equals(val.getType().getUri())) continue;
                        QualifiedName qn1 = (QualifiedName)val.getValue();
                        attribute = this.pf.newAttribute(qn1, attribute.getValue(), attribute.getType());
                        found = this.expandAttribute(dstStatement, attribute, dstAttributes, found, count);
                        ++count;
                    }
                    continue;
                }
                found = this.expandAttribute(dstStatement, attribute, dstAttributes, found, null);
            }
            this.pf.setAttributes((HasOther)dstStatement, dstAttributes);
        }
        return found;
    }

    private boolean expandAttribute(Statement dstStatement, Attribute attribute, Collection<Attribute> dstAttributes, boolean found, Integer count) {
        if (this.qualifiedNameURI.equals(attribute.getType().getUri())) {
            Object o = attribute.getValue();
            if (o instanceof QualifiedName) {
                QualifiedName qn1 = (QualifiedName)o;
                if (ExpandUtil.isVariable(qn1)) {
                    List<TypedValue> vals = this.env2.get(qn1);
                    if (vals == null) {
                        if (ExpandUtil.isGensymVariable(qn1)) {
                            dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), (Object)this.getUUIDQualifiedName(), this.pf.getName().PROV_QUALIFIED_NAME));
                        }
                    } else {
                        found = true;
                        if (count != null) {
                            this.processTemplateAttributes(dstStatement, dstAttributes, attribute, List.of(vals.get(count)));
                        } else {
                            this.processTemplateAttributes(dstStatement, dstAttributes, attribute, vals);
                        }
                    }
                } else {
                    dstAttributes.add(attribute);
                }
            } else {
                dstAttributes.add(attribute);
            }
        } else {
            dstAttributes.add(attribute);
        }
        return found;
    }

    public void processTemplateAttributes(Statement dstStatement, Collection<Attribute> dstAttributes, Attribute attribute, List<TypedValue> vals) {
        for (TypedValue val : vals) {
            Object value;
            String elementName = attribute.getElementName().getUri();
            if ("http://openprovenance.org/tmpl#label".equals(elementName)) {
                value = val.getValue();
                if (this.allowVariableInLabelAndTime && value instanceof QualifiedName && ((QualifiedName)value).getNamespaceURI().equals("http://openprovenance.org/var#")) {
                    dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), value, val.getType()));
                    continue;
                }
                dstAttributes.add(this.pf.newAttribute(this.pf.getName().PROV_LABEL, value, val.getType()));
                continue;
            }
            if ("http://openprovenance.org/tmpl#time".equals(elementName)) {
                value = val.getValue();
                if (this.allowVariableInLabelAndTime && value instanceof QualifiedName && ((QualifiedName)value).getNamespaceURI().equals("http://openprovenance.org/var#")) {
                    dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), value, val.getType()));
                    continue;
                }
                if (!(dstStatement instanceof HasTime)) continue;
                ((HasTime)dstStatement).setTime(this.pf.newISOTime((String)value));
                continue;
            }
            if ("http://openprovenance.org/tmpl#startTime".equals(elementName)) {
                if (!(dstStatement instanceof Activity)) continue;
                value = val.getValue();
                if (this.allowVariableInLabelAndTime && value instanceof QualifiedName && ((QualifiedName)value).getNamespaceURI().equals("http://openprovenance.org/var#")) {
                    dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), value, val.getType()));
                    continue;
                }
                ((Activity)dstStatement).setStartTime(this.pf.newISOTime((String)val.getValue()));
                continue;
            }
            if ("http://openprovenance.org/tmpl#endTime".equals(elementName)) {
                if (!(dstStatement instanceof Activity)) continue;
                value = val.getValue();
                if (this.allowVariableInLabelAndTime && value instanceof QualifiedName && ((QualifiedName)value).getNamespaceURI().equals("http://openprovenance.org/var#")) {
                    dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), value, val.getType()));
                    continue;
                }
                ((Activity)dstStatement).setEndTime(this.pf.newISOTime((String)val.getValue()));
                continue;
            }
            dstAttributes.add(this.pf.newAttribute(attribute.getElementName(), val.getValue(), val.getType()));
        }
    }

    public QualifiedName getUUIDQualifiedName() {
        UUID uuid = UUID.randomUUID();
        return this.pf.newQualifiedName(URN_UUID_NS, qnU.escapeProvLocalName(uuid.toString()), UUID_PREFIX);
    }

    public static QualifiedName getUUIDQualifiedName2(ProvFactory pf) {
        UUID uuid = UUID.randomUUID();
        return pf.newQualifiedName(URN_UUID_NS, qnU.escapeProvLocalName(uuid.toString()), UUID_PREFIX);
    }

    public void addOrderAttribute(HasOther res) {
        if (this.addOrderp) {
            res.getOther().add(this.pf.newOther("http://openprovenance.org/tmpl#", "order", "tmpl", this.index, this.pf.getName().XSD_STRING));
        }
    }

    private boolean setExpand(Statement res, QualifiedName id, int position) {
        if (ExpandUtil.isVariable(id)) {
            QualifiedName val = this.env.get(id);
            if (val != null || this.env.containsKey(id)) {
                this.u.setter(res, position, (Object)val);
                return true;
            }
            if (ExpandUtil.isGensymVariable(id)) {
                QualifiedName uuid = this.getUUIDQualifiedName();
                this.u.setter(res, position, (Object)uuid);
                this.oldBindings.addVariable(id, uuid);
                return true;
            }
            return false;
        }
        return true;
    }

    public void doAction(WasGeneratedBy s) {
        WasGeneratedBy res = this.pf.newWasGeneratedBy(s.getId(), s.getEntity(), s.getActivity());
        res.setTime(s.getTime());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getEntity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName act = res.getActivity();
        boolean updated3 = this.setExpand((Statement)res, act, 2);
        boolean updated4 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4;
        boolean allUpdated = updated1 && updated2 && updated3;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(WasInvalidatedBy s) {
        WasInvalidatedBy res = this.pf.newWasInvalidatedBy(s.getId(), s.getEntity(), s.getActivity());
        res.setTime(s.getTime());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName en = res.getEntity();
        boolean updated2 = this.setExpand((Statement)res, en, 1);
        QualifiedName act = res.getActivity();
        boolean updated3 = this.setExpand((Statement)res, act, 2);
        boolean updated4 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4;
        boolean allUpdated = updated1 && updated2 && updated3;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(HadMember s) {
        HadMember res = this.pf.newHadMember(s.getCollection(), (Collection)s.getEntity());
        QualifiedName col = res.getCollection();
        boolean updated0 = this.setExpand((Statement)res, col, 0);
        List ent = res.getEntity();
        if (ent.size() > 1) {
            throw new UnsupportedOperationException("can't expand HadMember with more than one members");
        }
        boolean updated1 = this.setExpand((Statement)res, (QualifiedName)ent.get(0), 1);
        boolean updated = updated0 || updated1;
        boolean allUpdated = updated0 && updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
    }

    public void doAction(MentionOf s) {
    }

    public void doAction(SpecializationOf s) {
        SpecializationOf res = this.pf.newSpecializationOf(s.getSpecificEntity(), s.getGeneralEntity());
        QualifiedName spe = res.getSpecificEntity();
        boolean updated0 = this.setExpand((Statement)res, spe, 0);
        QualifiedName gen = res.getGeneralEntity();
        boolean updated1 = this.setExpand((Statement)res, gen, 1);
        boolean updated = updated0 || updated1;
        boolean allUpdated = updated0 && updated1;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
    }

    public void doAction(QualifiedSpecializationOf s) {
        QualifiedSpecializationOf res = this.pf.newQualifiedSpecializationOf(s.getId(), s.getSpecificEntity(), s.getGeneralEntity(), null);
        QualifiedName spe = res.getSpecificEntity();
        boolean updated0 = this.setExpand((Statement)res, spe, 0);
        QualifiedName gen = res.getGeneralEntity();
        boolean updated1 = this.setExpand((Statement)res, gen, 1);
        boolean updated2 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated0 || updated1 || updated2;
        boolean allUpdated = updated0 && updated1 && updated2;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(QualifiedAlternateOf s) {
        QualifiedAlternateOf res = this.pf.newQualifiedAlternateOf(s.getId(), s.getAlternate1(), s.getAlternate2(), null);
        QualifiedName alt1 = res.getAlternate1();
        boolean updated0 = this.setExpand((Statement)res, alt1, 0);
        QualifiedName alt2 = res.getAlternate2();
        boolean updated1 = this.setExpand((Statement)res, alt2, 1);
        boolean updated2 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated0 || updated1 || updated2;
        boolean allUpdated = updated0 && updated1 && updated2;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(QualifiedHadMember s) {
        QualifiedHadMember res = this.pf.newQualifiedHadMember(s.getId(), s.getCollection(), (Collection)s.getEntity(), null);
        QualifiedName col = res.getCollection();
        boolean updated0 = this.setExpand((Statement)res, col, 0);
        List ent = res.getEntity();
        if (ent.size() > 1) {
            throw new UnsupportedOperationException("can't expand QualfiedHadMember with more than one members");
        }
        boolean updated1 = this.setExpand((Statement)res, (QualifiedName)ent.get(0), 1);
        boolean updated2 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated0 || updated1 || updated2;
        boolean allUpdated = updated0 && updated1 && updated2;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(DerivedByInsertionFrom s) {
    }

    public void doAction(WasInformedBy s) {
        WasInformedBy res = this.pf.newWasInformedBy(s.getId(), s.getInformed(), s.getInformant());
        QualifiedName id = res.getId();
        boolean updated1 = this.setExpand((Statement)res, id, 0);
        QualifiedName a2 = res.getInformed();
        boolean updated2 = this.setExpand((Statement)res, a2, 1);
        QualifiedName a1 = res.getInformant();
        boolean updated3 = this.setExpand((Statement)res, a1, 2);
        boolean updated4 = this.expandAttributes((Statement)s, (Statement)res);
        boolean updated = updated1 || updated2 || updated3 || updated4;
        boolean allUpdated = updated1 && updated2 && updated3;
        boolean bl = this.allExpanded = this.allExpanded && allUpdated;
        if (!this.allUpdatedRequired || allUpdated) {
            this.ll.add((StatementOrBundle)res);
        }
        if (updated) {
            this.addOrderAttribute((HasOther)res);
        }
    }

    public void doAction(Bundle bun, ProvUtilities provUtilities) {
        QualifiedName newId;
        List statements = bun.getStatement();
        LinkedList<Statement> newStatements = new LinkedList<Statement>();
        for (Statement s : statements) {
            for (StatementOrBundle sb : this.expand.expand(s, this.oldBindings, this.grp1)) {
                newStatements.add((Statement)sb);
            }
        }
        this.updateEnvironmentForBundleId(bun, this.oldBindings, this.env);
        QualifiedName bunId = bun.getId();
        if (ExpandUtil.isVariable(bunId)) {
            QualifiedName val = this.env.get(bunId);
            if (val != null) {
                newId = val;
            } else if (ExpandUtil.isGensymVariable(bunId)) {
                QualifiedName uuid;
                newId = uuid = this.getUUIDQualifiedName();
                this.oldBindings.addVariable(bunId, uuid);
            } else {
                newId = bunId;
            }
        } else {
            newId = bunId;
        }
        this.ll.add((StatementOrBundle)this.pf.newNamedBundle(newId, newStatements));
    }

    public void updateEnvironmentForBundleId(Bundle bun, OldBindings bindings1, Map<QualifiedName, QualifiedName> env0) {
        QualifiedName id = bun.getId();
        if (ExpandUtil.isVariable(id)) {
            List<QualifiedName> vals = bindings1.getVariables().get(id);
            if (vals == null) {
                if (!ExpandUtil.isGensymVariable(id)) {
                    throw new BundleVariableHasNoValue(id);
                }
            } else {
                if (vals.size() > 1) {
                    throw new BundleVariableHasMultipleValues(id, vals);
                }
                env0.put(id, vals.get(0));
            }
        }
    }

    public List<StatementOrBundle> getList() {
        return this.ll;
    }
}

