/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.plugin.project;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openprovenance.prov.template.compiler.CompilerSQL;

@Mojo(name="validate-template-project", defaultPhase=LifecyclePhase.INTEGRATION_TEST)
public class TemplateProjectSchemaValidator
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="validate-template-project.warning", defaultValue="false")
    private boolean warning;
    @Parameter(property="validate-template-project.args")
    private List<String> args = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new URL("file://" + (String)classpathElements.get(i));
            }
            String projectVersion = this.project.getVersion();
            String tempFileName = "openprovenance-template-project-schema-" + projectVersion + ".json";
            Path tempFilePath = Paths.get(System.getProperty("java.io.tmpdir"), tempFileName);
            IOUtils.copy((InputStream)CompilerSQL.class.getClassLoader().getResourceAsStream("schema/template-project-schema.json"), (OutputStream)Files.newOutputStream(tempFilePath, new OpenOption[0]));
            for (String arg : this.args) {
                ProcessBuilder pb = new ProcessBuilder("ajv", "validate", "-s", tempFilePath.toString(), "-d", arg);
                pb.inheritIO();
                Process p = pb.start();
                int exitCode = p.waitFor();
                if (exitCode == 0) continue;
                if (this.warning) {
                    this.getLog().warn((CharSequence)("Failed to validate " + arg));
                    continue;
                }
                throw new MojoExecutionException("Failed to validate " + arg);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute class ", e);
        }
    }
}

