/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.plugin.ttb;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="execute-ttb", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class BatchExecutor
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="execute-ttb.baseDir")
    private String baseDir;
    @Parameter(property="execute-ttb.inputBaseDir")
    private String inputBaseDir;
    @Parameter(property="execute-ttb.outputBaseDir")
    private String outputBaseDir;
    @Parameter(property="execute-ttb.configs", required=true)
    private List<String> configs = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        String className = org.openprovenance.prov.template.expander.meta.BatchExecutor.class.getName();
        try {
            if (this.baseDir != null && this.inputBaseDir != null) {
                throw new MojoExecutionException("Both baseDir and inputBaseDir are defined");
            }
            if (this.baseDir != null && this.outputBaseDir != null) {
                throw new MojoExecutionException("Both baseDir and outputBaseDir are defined");
            }
            List classpathElements = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new URL("file://" + (String)classpathElements.get(i));
            }
            System.out.println("urls=" + String.valueOf(urls));
            System.out.println("className=" + className);
            LinkedList<String> finalList = new LinkedList<String>();
            if (this.baseDir != null) {
                finalList.add(this.baseDir);
            } else {
                if (this.outputBaseDir == null) {
                    this.outputBaseDir = "";
                }
                if (this.inputBaseDir == null) {
                    this.inputBaseDir = "";
                }
                finalList.add(this.inputBaseDir);
                finalList.add(this.outputBaseDir);
            }
            finalList.add("-configs");
            finalList.addAll(this.configs);
            System.out.println("configs:=" + String.valueOf(finalList));
            URLClassLoader loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            Class<?> clazz = Class.forName(className, true, loader);
            Method method = clazz.getMethod("main", String[].class);
            String[] argsArray = finalList.toArray(new String[0]);
            method.invoke(null, new Object[]{argsArray});
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute class " + className, e);
        }
    }
}

