/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.plugin.project;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openprovenance.prov.template.compiler.ConfigProcessor;

@Mojo(name="generate-template-project", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class TemplateProjectExecutor
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="generate-template-project.baseDir")
    private String baseDir;
    @Parameter(property="generate-template-project.inputBaseDir")
    private String inputBaseDir;
    @Parameter(property="generate-template-project.outputBaseDir")
    private String outputBaseDir;
    @Parameter(property="generate-template-project.configs", required=true)
    private List<String> configs = new ArrayList<String>();

    public void execute() throws MojoExecutionException {
        String className = ConfigProcessor.class.getName();
        try {
            if (this.baseDir != null && this.inputBaseDir != null) {
                throw new MojoExecutionException("Both baseDir and inputBaseDir are defined");
            }
            if (this.baseDir != null && this.outputBaseDir != null) {
                throw new MojoExecutionException("Both baseDir and outputBaseDir are defined");
            }
            if (this.baseDir != null) {
                this.inputBaseDir = this.baseDir;
                this.outputBaseDir = this.baseDir;
            }
            List classpathElements = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new URL("file://" + (String)classpathElements.get(i));
            }
            for (String config : this.configs) {
                String[] argArray = new String[]{config, this.inputBaseDir, this.outputBaseDir};
                URLClassLoader loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
                Class<?> clazz = Class.forName(className, true, loader);
                Method method = clazz.getMethod("main", String[].class);
                method.invoke(null, new Object[]{argArray});
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute class ", e);
        }
    }
}

