/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.validation.Indexer;

public class EventIndexer {
    static final Logger logger = LogManager.getLogger(EventIndexer.class);
    public static final int MAX_VALUE = 70000;
    private final Indexer indexer;
    final ModelConstructor p;
    final ProvUtilities u;
    Vector<String> events;
    Vector<String> eventKinds;
    public Map<String, Integer> eventIndex;
    public Map<String, Statement> eventTable;
    int count = 0;

    public EventIndexer(Indexer indexer) {
        this.indexer = indexer;
        this.p = indexer.p;
        this.u = indexer.u;
    }

    public void createEventIndex() {
        LinkedList<String> eventsList = new LinkedList<String>();
        LinkedList<String> eventKindsList = new LinkedList<String>();
        this.eventIndex = new Hashtable<String, Integer>();
        this.eventTable = new Hashtable<String, Statement>();
        int for_wgb = Math.min(this.indexer.wasGeneratedByTable.keySet().size(), 70000);
        int others = Math.max(0, 70000 - for_wgb);
        for (String key : this.indexer.wasStartedByTable.keySet()) {
            if (others > 0) {
                eventsList.add(key);
                eventKindsList.add("s");
                this.eventIndex.put(key, this.count++);
                --others;
            }
            this.eventTable.put(key, (Statement)this.indexer.wasStartedByTable.get(key));
        }
        for (String key : this.indexer.wasGeneratedByTable.keySet()) {
            if (for_wgb > 0) {
                eventsList.add(key);
                eventKindsList.add("g");
                this.eventIndex.put(key, this.count++);
                --for_wgb;
            }
            this.eventTable.put(key, (Statement)this.indexer.wasGeneratedByTable.get(key));
        }
        for (String key : this.indexer.usedTable.keySet()) {
            if (others > 0) {
                eventsList.add(key);
                eventKindsList.add("u");
                this.eventIndex.put(key, this.count++);
                --others;
            }
            this.eventTable.put(key, (Statement)this.indexer.usedTable.get(key));
        }
        for (String key : this.indexer.wasEndedByTable.keySet()) {
            if (others > 0) {
                eventsList.add(key);
                eventKindsList.add("e");
                this.eventIndex.put(key, this.count++);
                --others;
            }
            this.eventTable.put(key, (Statement)this.indexer.wasEndedByTable.get(key));
        }
        for (String key : this.indexer.wasInvalidatedByTable.keySet()) {
            if (others > 0) {
                eventsList.add(key);
                eventKindsList.add("i");
                this.eventIndex.put(key, this.count++);
                --others;
            }
            this.eventTable.put(key, (Statement)this.indexer.wasInvalidatedByTable.get(key));
        }
        if (this.count > 70000) {
            this.count = 70000;
        }
        this.events = new Vector(eventsList);
        this.eventKinds = new Vector(eventKindsList);
        logger.debug("allocating ");
        logger.debug("events: " + this.events);
        logger.debug("eventIndex: " + this.eventIndex);
    }
}

