/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.validation.ActivityEntry;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.EntityEntry;
import org.openprovenance.prov.validation.Gensym;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.Types;
import org.openprovenance.prov.validation.VarQName;

public class Inference {
    static final Logger logger = LogManager.getLogger(Inference.class);
    final Indexer indexer;
    final Gensym g;
    final ProvFactory p;
    final ProvUtilities u;
    final Types typeChecker;
    public Hashtable<QualifiedName, Set<QualifiedName>> specializationTable;
    Hashtable<QualifiedName, Set<QualifiedName>> alternateTable;
    List<SpecializationOf> failedSpecialization = new LinkedList<SpecializationOf>();
    public Hashtable<String, ActivityEntry> activityEntries = new Hashtable();
    public Hashtable<String, EntityEntry> entityEntries = new Hashtable();

    public Inference(Indexer indexer, Types typeChecker) {
        this.indexer = indexer;
        this.g = indexer.g;
        this.p = indexer.p;
        this.u = indexer.u;
        this.typeChecker = typeChecker;
    }

    public void inferIntervalBeginningAndEnds(Config config) {
        for (String key : this.indexer.wasGeneratedByTable.keySet()) {
            WasGeneratedBy gen = this.indexer.wasGeneratedByTable.get(key);
            this.getOrCreateEntityEntry(gen.getEntity().getUri()).addGenerationKey(key);
        }
        for (String key : this.indexer.wasInvalidatedByTable.keySet()) {
            WasInvalidatedBy inv = this.indexer.wasInvalidatedByTable.get(key);
            this.getOrCreateEntityEntry(inv.getEntity().getUri()).addInvalidationKey(key);
        }
        for (String key : this.indexer.wasStartedByTable.keySet()) {
            WasStartedBy start = this.indexer.wasStartedByTable.get(key);
            this.getOrCreateActivityEntry(start.getActivity().getUri()).addStartKey(key);
        }
        for (String key : this.indexer.wasEndedByTable.keySet()) {
            WasEndedBy end = this.indexer.wasEndedByTable.get(key);
            this.getOrCreateActivityEntry(end.getActivity().getUri()).addEndKey(key);
        }
        for (String entity : this.indexer.entityTable.keySet()) {
            QualifiedName entityId = this.indexer.entityTable.get(entity).getId();
            EntityEntry ee = this.entityEntries.get(entity);
            if (ee == null) {
                ee = new EntityEntry();
                this.entityEntries.put(entity, ee);
            }
            if (ee.getGenerationKey().isEmpty()) {
                VarQName generationId = this.g.newId((WasGeneratedBy)null);
                WasGeneratedBy wgb = this.p.newWasGeneratedBy((QualifiedName)generationId, entityId, null, null);
                String generationUri = generationId.getUri();
                this.indexer.wasGeneratedByTable.put(generationUri, wgb);
                ee.addGenerationKey(generationUri);
            }
            if (!ee.getInvalidationKey().isEmpty()) continue;
            VarQName invalidationId = this.g.newId((WasInvalidatedBy)null);
            WasInvalidatedBy wib = this.p.newWasInvalidatedBy((QualifiedName)invalidationId, entityId, null);
            String invalidationUri = invalidationId.getUri();
            this.indexer.wasInvalidatedByTable.put(invalidationUri, wib);
            ee.addInvalidationKey(invalidationUri);
        }
        for (String activity : this.indexer.activityTable.keySet()) {
            WasStartedBy wsb;
            QualifiedName activityId = this.indexer.activityTable.get(activity).getId();
            ActivityEntry ae = this.activityEntries.get(activity);
            if (ae == null) {
                ae = new ActivityEntry();
                this.activityEntries.put(activity, ae);
            }
            if (ae.getStartKey().isEmpty()) {
                VarQName startId = this.g.newId((WasStartedBy)null);
                wsb = this.p.newWasStartedBy((QualifiedName)startId, activityId, null);
                String startUri = startId.getUri();
                this.indexer.wasStartedByTable.put(startUri, wsb);
                ae.addStartKey(startUri);
            }
            if (!ae.getEndKey().isEmpty()) continue;
            VarQName endId = this.g.newId((WasEndedBy)null);
            wsb = this.p.newWasEndedBy((QualifiedName)endId, activityId, null);
            String endUri = endId.getUri();
            this.indexer.wasEndedByTable.put(endUri, (WasEndedBy)wsb);
            ae.addEndKey(endUri);
        }
    }

    public boolean addEntry(Hashtable<QualifiedName, Set<QualifiedName>> table, QualifiedName specific, QualifiedName general) {
        Set tmp = table.computeIfAbsent(specific, k -> new HashSet());
        return tmp.add(general);
    }

    public Hashtable<QualifiedName, Set<QualifiedName>> computeSpecializationClosure(Config config) {
        Hashtable<QualifiedName, Set<QualifiedName>> table = new Hashtable<QualifiedName, Set<QualifiedName>>();
        for (SpecializationOf spec : this.indexer.specializationOfList) {
            QualifiedName general = spec.getGeneralEntity();
            QualifiedName specific = spec.getSpecificEntity();
            this.addEntry(table, specific, general);
        }
        if (config.isTrue("specialization_transitive")) {
            logger.debug("specialization_transitive");
            this.computeTransitiveClosure(table);
        }
        this.specializationTable = table;
        return table;
    }

    public Hashtable<QualifiedName, Set<QualifiedName>> computeAlternateClosure(Config config) {
        Hashtable<QualifiedName, Set<QualifiedName>> table = new Hashtable<QualifiedName, Set<QualifiedName>>();
        for (AlternateOf alternateOf : this.indexer.alternateOfList) {
            QualifiedName e1 = alternateOf.getAlternate2();
            QualifiedName e2 = alternateOf.getAlternate1();
            this.addEntry(table, e2, e1);
            if (config.isTrue("alternate_symmetric")) {
                this.addEntry(table, e1, e2);
            }
            if (config.isTrue("alternate_reflexive")) {
                this.addEntry(table, e1, e1);
                this.addEntry(table, e2, e2);
            }
            this.addEntry(table, e2, e1);
        }
        for (SpecializationOf specializationOf : this.indexer.specializationOfList) {
            QualifiedName general = specializationOf.getGeneralEntity();
            QualifiedName specific = specializationOf.getSpecificEntity();
            if (!config.isTrue("specialization_alternate")) continue;
            this.addEntry(table, specific, general);
            if (!config.isTrue("alternate_symmetric")) continue;
            this.addEntry(table, general, specific);
        }
        if (config.isTrue("alternate_transitive")) {
            logger.debug("alternate_transitive");
            this.computeTransitiveClosure(table);
        }
        this.alternateTable = table;
        return table;
    }

    public void computeTransitiveClosure(Hashtable<QualifiedName, Set<QualifiedName>> table) {
        boolean updated = true;
        while (updated) {
            logger.debug("table is " + table);
            updated = false;
            for (QualifiedName i : new LinkedList<QualifiedName>(table.keySet())) {
                for (QualifiedName j : new LinkedList(table.get(i))) {
                    Set<QualifiedName> set = table.get(j);
                    if (set == null) continue;
                    for (QualifiedName k : set) {
                        updated = updated || this.addEntry(table, i, k);
                    }
                }
            }
        }
    }

    public void specializationIsNotReflexive(Config config) {
        if (config.isTrue("impossible_specialization_reflexive")) {
            logger.debug("impossible_specialization_reflexive");
            this.specializationIsNotReflexive();
        }
    }

    public void specializationIsNotReflexive() {
        LinkedList<QualifiedName> fails = new LinkedList<QualifiedName>();
        for (QualifiedName key : this.specializationTable.keySet()) {
            if (!this.specializationTable.get(key).contains(key)) continue;
            fails.add(key);
        }
        for (QualifiedName fail : fails) {
            this.failedSpecialization.add(this.p.newSpecializationOf(fail, fail));
        }
    }

    public void specializationAttributesInference(Config config) {
        if (config.isTrue("specialization_attributes_inference")) {
            logger.debug("%%% specialization_attributes_inference");
            for (QualifiedName key : this.specializationTable.keySet()) {
                String specific = key.getUri();
                Set<QualifiedName> set = this.specializationTable.get(key);
                for (QualifiedName name : set) {
                    String general = name.getUri();
                    this.typeChecker.aggregatedTypes.get(specific).addAll((Collection<String>)this.typeChecker.aggregatedTypes.get(general));
                }
            }
        }
    }

    public String summary() {
        return this.activityEntries + "\n" + this.entityEntries;
    }

    public ActivityEntry getOrCreateActivityEntry(String activityURI) {
        ActivityEntry entry = this.activityEntries.get(activityURI);
        if (entry == null) {
            entry = new ActivityEntry();
            this.activityEntries.put(activityURI, entry);
        }
        return entry;
    }

    public EntityEntry getOrCreateEntityEntry(String entityURI) {
        EntityEntry entry = this.entityEntries.get(entityURI);
        if (entry == null) {
            entry = new EntityEntry();
            this.entityEntries.put(entityURI, entry);
        }
        return entry;
    }
}

