/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation.matrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openprovenance.prov.validation.matrix.Pair;

public final class SparseMatrix {
    private final int size1;
    private final int size2;
    private final List<Pair>[] rows;
    private final List<Pair>[] cols;
    private final Map<Pair, Pair> matrixMap = new HashMap<Pair, Pair>();
    private int maximum = 0;

    public SparseMatrix(int size1, int size2) {
        this.size1 = size1;
        this.size2 = size2;
        this.rows = new List[size1];
        this.cols = new List[size2];
        for (int i = 0; i < size1; ++i) {
            this.rows[i] = new ArrayList<Pair>();
        }
        for (int j = 0; j < size1; ++j) {
            this.cols[j] = new ArrayList<Pair>();
        }
    }

    public List<Pair> getRow(int row) {
        return this.rows[row];
    }

    public List<Pair> getCol(int col) {
        return this.cols[col];
    }

    public Pair g(int row, int col) {
        Pair res = this.matrixMap.get(new Pair(row, col));
        return res;
    }

    public void set(int row, int col, int value) {
        Pair p = new Pair(row, col, value);
        this.matrixMap.put(p, p);
        this.rows[row].add(p);
        this.cols[col].add(p);
    }

    public void setNoUpdate(int row, int col, int value) {
        Pair p = new Pair(row, col, value);
        this.matrixMap.put(p, p);
    }

    public void remove(int row, int col) {
        Pair p = new Pair(row, col);
        this.matrixMap.remove(p);
        this.rows[row].remove(p);
        this.cols[col].remove(p);
    }

    public Set<Integer> colSet() {
        HashSet<Integer> colSet = new HashSet<Integer>();
        for (Pair pair : this.matrixMap.keySet()) {
            colSet.add(pair.getSecond());
        }
        return colSet;
    }

    public Set<Integer> rowSet() {
        HashSet<Integer> rowSet = new HashSet<Integer>();
        for (Pair pair : this.matrixMap.keySet()) {
            rowSet.add(pair.getFirst());
        }
        return rowSet;
    }

    public void clear() {
        this.matrixMap.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseMatrix)) {
            return false;
        }
        SparseMatrix other = (SparseMatrix)obj;
        return this.matrixMap.equals(other.matrixMap);
    }

    public int hashCode() {
        return this.matrixMap.hashCode();
    }

    public String toString() {
        return "SparseMatrix (" + this.size1 + "," + this.size2 + " (" + this.matrixMap.size() + " ," + this.matrixMap + ") elements)";
    }

    public void floydWarshall(SparseMatrix next) {
        this.floydWarshallWithIterator(next);
    }

    public int getMaximum() {
        return this.maximum;
    }

    final boolean isStrictOrdering(int n) {
        return n % 2 == 1;
    }

    public static final boolean isNonStrictOrdering(int n) {
        return n % 2 == 0;
    }

    public final int addAndPreserveStrictOrdering(int n1, int n2) {
        boolean strict1 = this.isStrictOrdering(n1);
        boolean strict2 = this.isStrictOrdering(n2);
        int val1 = strict1 ? n1 + 1 : n1;
        int val2 = strict2 ? n2 + 1 : n2;
        return strict1 || strict2 ? val1 + val2 - 1 : val1 + val2;
    }

    public final int roundedOrder(int n) {
        boolean strict = this.isStrictOrdering(n);
        int val = strict ? n + 1 : n;
        return val;
    }

    public final void floydWarshallWithIterator(SparseMatrix next) {
        int[] col = new int[this.size1];
        int[] val = new int[this.size1];
        for (int k = 0; k < this.size1; ++k) {
            List<Pair> col_k = this.getCol(k);
            for (Pair pair_i_k : col_k) {
                int i = pair_i_k.getFirst();
                int count = 0;
                int d_i_k = pair_i_k.getValue();
                List<Pair> row_k = this.getRow(k);
                for (Pair pair_k_j : row_k) {
                    int j = pair_k_j.getSecond();
                    int d_k_j = pair_k_j.getValue();
                    if (i == k || k == j) break;
                    int d_i_j = this.addAndPreserveStrictOrdering(d_i_k, d_k_j);
                    Pair m_i_j = this.g(i, j);
                    if (m_i_j == null) {
                        this.setNoUpdate(i, j, d_i_j);
                        col[count] = j;
                        val[count] = d_i_j;
                        ++count;
                        this.maximum = Math.max(this.maximum, d_i_j);
                        continue;
                    }
                    if (!this.isStrictOrdering(d_i_j) || this.isStrictOrdering(m_i_j.getValue())) continue;
                    m_i_j.value = d_i_j;
                    this.maximum = Math.max(this.maximum, d_i_j);
                }
                for (int c = 0; c < count; ++c) {
                    Pair pair = new Pair(i, col[c], val[c]);
                    this.rows[i].add(pair);
                    this.cols[col[c]].add(pair);
                }
            }
        }
    }
}

