/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.TwoKeys;
import org.openprovenance.prov.validation.Uniqueness;
import org.openprovenance.prov.validation.VarQNameWrapper;

public class Unification {
    static Logger logger = LogManager.getLogger(Unification.class);
    private final Indexer indexer;
    final ProvFactory p;
    final ProvUtilities u;
    final Uniqueness uniq;

    public Unification(Indexer indexer, Uniqueness uniq) {
        this.indexer = indexer;
        this.uniq = uniq;
        this.p = indexer.p;
        this.u = indexer.u;
    }

    public void removeUnifiedEntries() {
        logger.debug("removeUnifiedEntry1  TODO !!!!!!!!!!!!" + this.indexer.merger.unificationSubstitution);
        this.removeUnifiedEntry1(WasStartedBy.class, this.indexer.wasStartedByTable, this.uniq.wasStartedByTable);
        this.removeUnifiedEntry1(WasEndedBy.class, this.indexer.wasEndedByTable, this.uniq.wasEndedByTable);
        this.removeUnifiedEntry1(WasGeneratedBy.class, this.indexer.wasGeneratedByTable, this.uniq.wasGeneratedByTable);
        this.removeUnifiedEntry1(WasInvalidatedBy.class, this.indexer.wasInvalidatedByTable, this.uniq.wasInvalidatedByTable);
        this.removeUnifiedEntry2(WasDerivedFrom.class, this.indexer.wasDerivedFromTable);
        this.removeUnifiedEntry2(WasAttributedTo.class, this.indexer.wasAttributedToTable);
        this.removeUnifiedEntry2(WasAssociatedWith.class, this.indexer.wasAssociatedWithTable);
        this.removeUnifiedEntry2(ActedOnBehalfOf.class, this.indexer.actedOnBehalfOfTable);
        this.removeUnifiedEntry2(Used.class, this.indexer.usedTable);
    }

    public <T> void removeUnifiedEntry1(Class<T> class1, Hashtable<String, T> table1, Hashtable<TwoKeys, T> table2) {
        for (VarQNameWrapper key : this.indexer.merger.unificationSubstitution.keySet()) {
            T entry = table1.remove(key.getVarQName().getUri());
            if (entry == null) continue;
            logger.debug("removeUnifiedEntry1  removed " + key);
            TwoKeys tk = TwoKeys.makeTwoKeys(entry);
            T entry2 = table2.remove(tk);
            if (entry2 == null) continue;
            logger.debug("removeUnifiedEntry1  removed twoKey " + tk);
        }
    }

    public <T> void removeUnifiedEntry2(Class<T> class1, Hashtable<String, T> table1) {
        for (VarQNameWrapper key : this.indexer.merger.unificationSubstitution.keySet()) {
            T entry = table1.remove(key);
            if (entry == null) continue;
            logger.debug("removeUnifiedEntry2  removed " + key);
        }
    }

    public void applyUnification() {
        logger.debug("applyUnification: " + this.indexer.merger.unificationSubstitution);
        this.applyUnification(WasStartedBy.class, this.indexer.wasStartedByTable);
        this.applyUnification(WasEndedBy.class, this.indexer.wasEndedByTable);
        this.applyUnification(WasGeneratedBy.class, this.indexer.wasGeneratedByTable);
        this.applyUnification(WasInvalidatedBy.class, this.indexer.wasInvalidatedByTable);
        this.applyUnification(WasDerivedFrom.class, this.indexer.wasDerivedFromTable);
        this.applyUnification(WasAttributedTo.class, this.indexer.wasAttributedToTable);
        this.applyUnification(WasAssociatedWith.class, this.indexer.wasAssociatedWithTable);
        this.applyUnification(ActedOnBehalfOf.class, this.indexer.actedOnBehalfOfTable);
        this.applyUnification(Used.class, this.indexer.usedTable);
        this.applyUnification(Activity.class, this.indexer.activityTable);
    }

    public <T extends Statement> void applyUnification(Class<T> class1, Hashtable<String, T> table1) {
        for (String key : table1.keySet()) {
            Statement entry = (Statement)table1.get(key);
            if (entry != null) {
                logger.debug("applyUnification <T>  to " + key);
                this.indexer.merger.applySubstitution(entry, this.indexer.merger.unificationSubstitution, this.indexer.merger.unificationTimeSubstitution);
                continue;
            }
            logger.debug("applyUnification  coudln't find entry " + key);
            throw new UnsupportedOperationException();
        }
    }
}

