/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.Gensym;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.Types;
import org.openprovenance.prov.validation.report.MalformedStatements;

public class Expansion {
    static Logger logger = LogManager.getLogger(Expansion.class);
    final ProvFactory p;
    final ProvUtilities u;
    private final Indexer indexer;
    private final Gensym g;
    private final Config config;
    private final Types typeChecker;
    private final MalformedStatements malformed = new MalformedStatements();

    public Expansion(Indexer indexer, Config config, Types typeChecker) {
        this.indexer = indexer;
        this.g = indexer.g;
        this.p = indexer.p;
        this.u = indexer.u;
        this.config = config;
        this.typeChecker = typeChecker;
    }

    public void expansion(Config config, List<Statement> records) {
        this.u.forAllStatement(records, (StatementAction)new ExpansionAction(config));
        List<Statement> toremove = this.malformed.getStatement();
        if (!toremove.isEmpty()) {
            logger.debug("removing " + toremove.size());
            logger.debug("removing before " + records.size());
            records.removeAll(toremove);
            logger.debug("removing before " + records.size());
        }
    }

    public MalformedStatements getMalformed() {
        return this.malformed;
    }

    public boolean checkEntityArgument(Config config, Statement o, int i) {
        boolean res;
        QualifiedName entity = (QualifiedName)this.u.getter(o, i);
        boolean bl = res = entity != null;
        if (res) {
            this.typeChecker.addInferredType(entity, Types.entityURI);
        }
        return res;
    }

    public boolean checkAgentArgument(Config config, Statement o, int i) {
        boolean res;
        QualifiedName agent = (QualifiedName)this.u.getter(o, i);
        boolean bl = res = agent != null;
        if (res) {
            this.typeChecker.addInferredType(agent, Types.agentURI);
        }
        return res;
    }

    public boolean checkActivityArgument(Config config, Statement o, int i) {
        boolean res;
        QualifiedName activity = (QualifiedName)this.u.getter(o, i);
        boolean bl = res = activity != null;
        if (res) {
            this.typeChecker.addInferredType(activity, Types.activityURI);
        }
        return res;
    }

    public void checkActivityIsDeclared(QualifiedName activity1) {
        if (activity1 != null) {
            String activity1URI = activity1.getUri();
            if (this.indexer.activityTable.get(activity1URI) == null) {
                this.indexer.activityTable.put(activity1URI, this.p.newActivity(activity1));
            }
            this.typeChecker.addInferredType(activity1, Types.activityURI);
        }
    }

    public void checkEntityIsDeclared(QualifiedName entity1) {
        if (entity1 != null) {
            String entity1URI = entity1.getUri();
            if (this.indexer.entityTable.get(entity1URI) == null) {
                this.indexer.entityTable.put(entity1URI, this.p.newEntity(entity1));
            }
            this.typeChecker.addInferredType(entity1, Types.entityURI);
        }
    }

    public void checkAgentIsDeclared(QualifiedName agent1) {
        if (agent1 != null) {
            String agent1URI = agent1.getUri();
            if (this.indexer.agentTable.get(agent1URI) == null) {
                this.indexer.agentTable.put(agent1URI, this.p.newAgent(agent1));
            }
            this.typeChecker.addInferredType(agent1, Types.agentURI);
        }
    }

    public void expand_entityArgument(Config config, Statement o, int i) {
        QualifiedName entity = (QualifiedName)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && entity == null) {
            entity = this.g.newId(entity);
            this.u.setter(o, i, (Object)entity);
        }
        this.typeChecker.addInferredType(entity, Types.entityURI);
    }

    public void expand_activityArgument(Config config, Statement o, int i) {
        QualifiedName activity = (QualifiedName)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && activity == null) {
            activity = this.g.newId(activity);
            this.u.setter(o, i, (Object)activity);
        }
        this.typeChecker.addInferredType(activity, Types.activityURI);
    }

    public void expand_timeArgument(Config config, Statement o, int i) {
        XMLGregorianCalendar time = (XMLGregorianCalendar)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && time == null) {
            time = this.g.newVarTime();
            this.u.setter(o, i, (Object)time);
        }
    }

    public void expand_agentArgument(Config config, Statement o, int i) {
        QualifiedName agent = (QualifiedName)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && agent == null) {
            agent = this.g.newId(agent);
            this.u.setter(o, i, (Object)agent);
        }
        this.typeChecker.addInferredType(agent, Types.agentURI);
    }

    public void expand_usageArgument(Config config, Statement o, int i) {
        QualifiedName dep = (QualifiedName)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && dep == null) {
            dep = this.g.newId(dep);
            this.u.setter(o, i, (Object)dep);
        }
        this.typeChecker.addInferredType(dep, Types.usageURI);
    }

    public void expand_generationArgument(Config config, Statement o, int i) {
        QualifiedName dep = (QualifiedName)this.u.getter(o, i);
        if (config.isTrue("optional_placeholders") && dep == null) {
            dep = this.g.newId(dep);
            this.u.setter(o, i, (Object)dep);
        }
        this.typeChecker.addInferredType(dep, Types.generationURI);
    }

    public void expansion_specializationOf(Config config, SpecializationOf spec) {
        if (!this.checkEntityArgument(config, (Statement)spec, 0)) {
            this.malformedExpression(spec);
            return;
        }
        if (!this.checkEntityArgument(config, (Statement)spec, 1)) {
            this.malformedExpression(spec);
            return;
        }
        this.typeChecker.addInferredType(spec.getGeneralEntity(), Types.entityURI);
        this.typeChecker.addInferredType(spec.getSpecificEntity(), Types.entityURI);
    }

    public void expansion_mentionOf(Config config, MentionOf men) {
        if (!this.checkEntityArgument(config, (Statement)men, 1)) {
            this.malformedExpression(men);
            return;
        }
        if (!this.checkEntityArgument(config, (Statement)men, 2)) {
            this.malformedExpression(men);
            return;
        }
        if (!this.checkEntityArgument(config, (Statement)men, 3)) {
            this.malformedExpression(men);
            return;
        }
        this.typeChecker.addInferredType(men.getGeneralEntity(), Types.entityURI);
        this.typeChecker.addInferredType(men.getSpecificEntity(), Types.entityURI);
        this.typeChecker.addInferredType(men.getBundle(), Types.entityURI);
        this.typeChecker.addInferredType(men.getBundle(), Types.bundleURI);
    }

    public void expansion_alternateOf(Config config, AlternateOf alt) {
    }

    public void expansion_agent(Config config, Agent ag) {
        this.typeChecker.addInferredType(ag.getId(), Types.agentURI);
    }

    public void expansion_activity(Config config, Activity a) {
        this.typeChecker.addInferredType(a.getId(), Types.activityURI);
        this.expand_timeArgument(config, (Statement)a, 1);
        this.expand_timeArgument(config, (Statement)a, 2);
    }

    public void expansion_entity(Config config, Entity e) {
        this.typeChecker.addInferredType(e.getId(), Types.entityURI);
    }

    public void expansion_wasStartedBy(Config config, WasStartedBy start) {
        if (start.getId() == null) {
            this.g.setId(start);
        }
        this.typeChecker.addInferredType(start.getId(), Types.startURI);
        if (!this.checkActivityArgument(config, (Statement)start, 1)) {
            this.malformedExpression(start);
        }
        this.expand_entityArgument(config, (Statement)start, 2);
        this.expand_activityArgument(config, (Statement)start, 3);
        this.expand_timeArgument(config, (Statement)start, 4);
    }

    public void expansion_wasEndedBy(Config config, WasEndedBy end) {
        if (end.getId() == null) {
            this.g.setId(end);
        }
        this.typeChecker.addInferredType(end.getId(), Types.endURI);
        if (!this.checkActivityArgument(config, (Statement)end, 1)) {
            this.malformedExpression(end);
        }
        this.expand_entityArgument(config, (Statement)end, 2);
        this.expand_activityArgument(config, (Statement)end, 3);
        this.expand_timeArgument(config, (Statement)end, 4);
    }

    public void expansion_used(Config config, Used use) {
        if (use.getId() == null) {
            this.g.setId(use);
        }
        this.typeChecker.addInferredType(use.getId(), Types.usageURI);
        if (!this.checkActivityArgument(config, (Statement)use, 1)) {
            this.malformedExpression(use);
        }
        this.expand_entityArgument(config, (Statement)use, 2);
        this.expand_timeArgument(config, (Statement)use, 3);
    }

    public void expansion_wasGeneratedBy(Config config, WasGeneratedBy gen) {
        if (gen.getId() == null) {
            this.g.setId(gen);
        }
        this.typeChecker.addInferredType(gen.getId(), Types.generationURI);
        if (!this.checkEntityArgument(config, (Statement)gen, 1)) {
            this.malformedExpression(gen);
        }
        this.expand_activityArgument(config, (Statement)gen, 2);
        this.expand_timeArgument(config, (Statement)gen, 3);
    }

    public void expansion_wasInvalidatedBy(Config config, WasInvalidatedBy inv) {
        if (inv.getId() == null) {
            this.g.setId(inv);
        }
        this.typeChecker.addInferredType(inv.getId(), Types.invalidationURI);
        if (!this.checkEntityArgument(config, (Statement)inv, 1)) {
            this.malformedExpression(inv);
        }
        this.expand_activityArgument(config, (Statement)inv, 2);
        this.expand_timeArgument(config, (Statement)inv, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void expansion_wasDerivedFrom(Config config, WasDerivedFrom der) {
        if (der.getId() == null) {
            this.g.setId(der);
        }
        this.typeChecker.addInferredType(der.getId(), Types.derivationURI);
        if (!this.checkEntityArgument(config, (Statement)der, 1)) {
            this.malformedExpression(der);
        }
        if (!this.checkEntityArgument(config, (Statement)der, 2)) {
            this.malformedExpression(der);
        }
        if (der.getActivity() != null) {
            String generationURI;
            QualifiedName generation;
            String usageURI;
            this.expand_generationArgument(config, (Statement)der, 4);
            this.expand_usageArgument(config, (Statement)der, 5);
            QualifiedName usage = der.getUsage();
            if (usage == null || this.indexer.usedTable.get(usageURI = usage.getUri()) == null) {
                // empty if block
            }
            if ((generation = der.getGeneration()) != null && this.indexer.wasGeneratedByTable.get(generationURI = generation.getUri()) != null) return;
        }
        der.setActivity((QualifiedName)this.g.newUnknown());
        if (der.getGeneration() != null) {
            this.malformedExpression(der, false);
        } else {
            der.setGeneration((QualifiedName)this.g.newUnknown());
        }
        if (der.getUsage() != null) {
            this.malformedExpression(der, false);
            return;
        } else {
            der.setUsage((QualifiedName)this.g.newUnknown());
        }
    }

    public void expansion_wasAssociatedWith(Config config, WasAssociatedWith assoc) {
        if (assoc.getId() == null) {
            this.g.setId(assoc);
        }
        if (!this.checkActivityArgument(config, (Statement)assoc, 1)) {
            this.malformedExpression(assoc);
        }
        this.expand_agentArgument(config, (Statement)assoc, 2);
        if (assoc.getPlan() == null) {
            assoc.setPlan((QualifiedName)this.g.newUnknown());
        }
    }

    public void expansion_actedOnBehalfOf(Config config, ActedOnBehalfOf del) {
        if (del.getId() == null) {
            this.g.setId(del);
        }
        if (!this.checkAgentArgument(config, (Statement)del, 1)) {
            this.malformedExpression(del);
        }
        this.expand_agentArgument(config, (Statement)del, 2);
        this.expand_activityArgument(config, (Statement)del, 3);
    }

    public void expansion_wasAttributedTo(Config config, WasAttributedTo attr) {
        if (attr.getId() == null) {
            this.g.setId(attr);
        }
        if (!this.checkEntityArgument(config, (Statement)attr, 1)) {
            this.malformedExpression(attr);
        }
        if (!this.checkAgentArgument(config, (Statement)attr, 2)) {
            this.malformedExpression(attr);
        }
    }

    public void expansion_wasInformedBy(Config config, WasInformedBy inf) {
        if (inf.getId() == null) {
            this.g.setId(inf);
        }
        if (!this.checkActivityArgument(config, (Statement)inf, 1)) {
            this.malformedExpression(inf);
        }
        if (!this.checkActivityArgument(config, (Statement)inf, 2)) {
            this.malformedExpression(inf);
        }
    }

    public void expansion_wasInfluencedBy(Config config, WasInfluencedBy infl) {
        if (infl.getId() == null) {
            this.g.setId(infl);
        }
        if (infl.getInfluencer() == null) {
            this.malformedExpression(infl);
        }
        if (infl.getInfluencee() == null) {
            this.malformedExpression(infl);
        }
    }

    public void expansion_membership(Config config, HadMember mem) {
        if (mem.getCollection() == null) {
            this.malformedExpression(mem);
            return;
        }
        if (mem.getEntity() == null || mem.getEntity().isEmpty() || mem.getEntity().size() == 1 && mem.getEntity().get(0) == null) {
            this.malformedExpression(mem);
            return;
        }
        this.typeChecker.addInferredType(mem.getCollection(), Types.entityURI);
        this.typeChecker.addInferredType(mem.getCollection(), Types.collectionURI);
        boolean empty = true;
        for (QualifiedName entity : mem.getEntity()) {
            if (entity == null) continue;
            this.typeChecker.addInferredType(entity, Types.entityURI);
            empty = false;
        }
        if (!empty) {
            this.typeChecker.addInferredType(mem.getCollection(), Types.nonEmptyCollectionURI);
        }
    }

    public <T> void malformedExpression(T tmp) {
        this.malformedExpression(tmp, true);
    }

    public <T> void malformedExpression(T tmp, boolean stop) {
        if (this.malformed != null) {
            this.malformed.getStatement().add((Statement)tmp);
        }
    }

    class ExpansionAction
    implements StatementAction {
        Config config;

        public ExpansionAction(Config config) {
            this.config = config;
        }

        public void doAction(Entity e) {
            Expansion.this.expansion_entity(this.config, e);
        }

        public void doAction(Activity a) {
            Expansion.this.expansion_activity(this.config, a);
        }

        public void doAction(Agent ag) {
            Expansion.this.expansion_agent(this.config, ag);
        }

        public void doAction(WasGeneratedBy gen) {
            Expansion.this.expansion_wasGeneratedBy(this.config, gen);
        }

        public void doAction(Used use) {
            Expansion.this.expansion_used(this.config, use);
        }

        public void doAction(WasInvalidatedBy inv) {
            Expansion.this.expansion_wasInvalidatedBy(this.config, inv);
        }

        public void doAction(WasStartedBy start) {
            Expansion.this.expansion_wasStartedBy(this.config, start);
        }

        public void doAction(WasEndedBy end) {
            Expansion.this.expansion_wasEndedBy(this.config, end);
        }

        public void doAction(WasInformedBy inf) {
            Expansion.this.expansion_wasInformedBy(this.config, inf);
        }

        public void doAction(WasDerivedFrom der) {
            Expansion.this.expansion_wasDerivedFrom(this.config, der);
        }

        public void doAction(WasAssociatedWith assoc) {
            Expansion.this.expansion_wasAssociatedWith(this.config, assoc);
        }

        public void doAction(WasAttributedTo attr) {
            Expansion.this.expansion_wasAttributedTo(this.config, attr);
        }

        public void doAction(ActedOnBehalfOf del) {
            Expansion.this.expansion_actedOnBehalfOf(this.config, del);
        }

        public void doAction(WasInfluencedBy infl) {
            Expansion.this.expansion_wasInfluencedBy(this.config, infl);
        }

        public void doAction(AlternateOf alt) {
            Expansion.this.expansion_alternateOf(this.config, alt);
        }

        public void doAction(QualifiedAlternateOf alt) {
            Expansion.this.expansion_alternateOf(this.config, (AlternateOf)alt);
        }

        public void doAction(MentionOf men) {
            Expansion.this.expansion_mentionOf(this.config, men);
        }

        public void doAction(SpecializationOf spec) {
            Expansion.this.expansion_specializationOf(this.config, spec);
        }

        public void doAction(QualifiedSpecializationOf spec) {
            Expansion.this.expansion_specializationOf(this.config, (SpecializationOf)spec);
        }

        public void doAction(QualifiedHadMember mem) {
            Expansion.this.expansion_membership(this.config, (HadMember)mem);
        }

        public void doAction(HadMember mem) {
            Expansion.this.expansion_membership(this.config, mem);
        }

        public void doAction(DictionaryMembership s) {
        }

        public void doAction(DerivedByRemovalFrom s) {
        }

        public void doAction(DerivedByInsertionFrom s) {
        }

        public void doAction(Bundle s, ProvUtilities provUtilities) {
        }
    }
}

