/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Hashtable;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Influence;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.TwoKeys;

public class Uniqueness {
    public final Indexer indexer;
    final ProvFactory p;
    final ProvUtilities u;
    public Hashtable<TwoKeys, WasGeneratedBy> wasGeneratedByTable = new Hashtable();
    public Hashtable<TwoKeys, WasInvalidatedBy> wasInvalidatedByTable = new Hashtable();
    public Hashtable<TwoKeys, WasStartedBy> wasStartedByTable = new Hashtable();
    public Hashtable<TwoKeys, WasEndedBy> wasEndedByTable = new Hashtable();

    public Uniqueness(Indexer indexer) {
        this.indexer = indexer;
        this.p = indexer.p;
        this.u = indexer.u;
    }

    public void uniqueAll(Config config) {
        this.uniqueAll_wasStartedBy(config);
        this.uniqueAll_wasEndedBy(config);
        this.uniqueAll_wasGeneratedBy(config);
        this.uniqueAll_wasInvalidatedBy(config);
        this.uniqueAll_activityStartTime(config);
        this.uniqueAll_activityEndTime(config);
    }

    public void uniqueAll_wasStartedBy(Config config) {
        this.uniqueAll_Record(WasStartedBy.class, this.indexer.wasStartedByTable, this.wasStartedByTable, config);
    }

    public void uniqueAll_wasEndedBy(Config config) {
        this.uniqueAll_Record(WasEndedBy.class, this.indexer.wasEndedByTable, this.wasEndedByTable, config);
    }

    public void uniqueAll_wasGeneratedBy(Config config) {
        this.uniqueAll_Record(WasGeneratedBy.class, this.indexer.wasGeneratedByTable, this.wasGeneratedByTable, config);
    }

    public void uniqueAll_wasInvalidatedBy(Config config) {
        this.uniqueAll_Record(WasInvalidatedBy.class, this.indexer.wasInvalidatedByTable, this.wasInvalidatedByTable, config);
    }

    public void uniqueAll_activityStartTime(Config config) {
        for (String activityKey : this.indexer.activityTable.keySet()) {
            Activity activity = this.indexer.activityTable.get(activityKey);
            for (String startKey : this.indexer.wasStartedByTable.keySet()) {
                WasStartedBy start = this.indexer.wasStartedByTable.get(startKey);
                if (!this.indexer.merger.equalQName(start.getActivity(), activity.getId())) continue;
                this.indexer.merger.sameStartTime(activityKey, activity, start);
            }
        }
    }

    public void uniqueAll_activityEndTime(Config config) {
        for (String activityKey : this.indexer.activityTable.keySet()) {
            Activity activity = this.indexer.activityTable.get(activityKey);
            for (String endKey : this.indexer.wasEndedByTable.keySet()) {
                WasEndedBy end = this.indexer.wasEndedByTable.get(endKey);
                if (!this.indexer.merger.equalQName(end.getActivity(), activity.getId())) continue;
                this.indexer.merger.sameEndTime(activityKey, activity, end);
            }
        }
    }

    public <T extends Influence> void uniqueAll_Record(Class<T> cl, Hashtable<String, T> table1, Hashtable<TwoKeys, T> table2, Config config) {
        for (String key : table1.keySet()) {
            Influence tmp = (Influence)table1.get(key);
            TwoKeys tk = TwoKeys.makeTwoKeys(tmp);
            Influence start = (Influence)table2.get(tk);
            if (start == null) {
                table2.put(tk, tmp);
                continue;
            }
            if (start == tmp) {
                return;
            }
            this.indexer.resolveDuplicate(start, tmp);
        }
    }
}

