/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.validation.ActivityEntry;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.EntityEntry;
import org.openprovenance.prov.validation.EventIndexer;
import org.openprovenance.prov.validation.EventMatrix;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.Inference;
import org.openprovenance.prov.validation.Types;
import org.openprovenance.prov.validation.matrix.Pair;

public class Constraints {
    static final Logger logger = LogManager.getLogger(Constraints.class);
    private final Indexer indexer;
    private final EventIndexer evtIndexer;
    private final Inference inference;
    final ProvFactory p;
    final ProvUtilities u;
    final Types typeChecker;
    private EventMatrix matrix;
    final int max;
    public Hashtable<String, Collection<String>> typeOverlapTable = new Hashtable();
    public static final int PRECEDE_STRICT = 1;
    public static final int PRECEDE = 2;

    public EventMatrix getMatrix() {
        return this.matrix;
    }

    public Constraints(Types typeChecker, Indexer indexer, Inference inference, EventIndexer evtIndexer) {
        this.indexer = indexer;
        this.evtIndexer = evtIndexer;
        this.inference = inference;
        this.max = evtIndexer.count;
        this.p = indexer.p;
        this.u = indexer.u;
        this.typeChecker = typeChecker;
    }

    public void constraints(Config config) {
        this.constraints(config, true);
    }

    public void constraints(Config config, boolean closure) {
        logger.debug("initialize matrix with (" + this.evtIndexer.count + ")");
        this.matrix = new EventMatrix(this.evtIndexer.count, this.evtIndexer.eventKinds);
        if (config.isTrue("start_precedes_end")) {
            logger.debug("constraint_start_precedes_end");
            this.constraint_start_precedes_end();
        }
        if (config.isTrue("generation_precedes_invalidation")) {
            logger.debug("constraint_generation_precedes_invalidation");
            this.constraint_generation_precedes_invalidation();
        }
        if (config.isTrue("derivation_generation_generation_ordering")) {
            logger.debug("constraint_derivation_generation_precedes_generation");
            this.constraint_derivation_generation_precedes_generation();
        }
        if (config.isTrue("derivation_usage_generation_ordering")) {
            logger.debug("derivation_usage_generation_ordering");
            this.constraint_derivation_usage_generation_ordering();
        }
        if (config.isTrue("usage_precedes_invalidation")) {
            logger.debug("constraint_usage_precedes_invalidation");
            this.constraint_usage_precedes_invalidation();
        }
        if (config.isTrue("usage_within_activity")) {
            logger.debug("constraint_usage_precedes_end");
            this.constraint_usage_precedes_end();
            logger.debug("constraint_start_precedes_usage");
            this.constraint_start_precedes_usage();
        }
        if (config.isTrue("generation_within_activity")) {
            logger.debug("constraint_generation_precedes_end");
            this.constraint_generation_precedes_end();
            logger.debug("constraint_start_precedes_generation");
            this.constraint_start_precedes_generation();
        }
        if (config.isTrue("wasStartedBy_ordering")) {
            logger.debug("wasStartedBy_ordering");
            this.constraint_wasStartedBy_ordering();
        }
        if (config.isTrue("wasEndedBy_ordering")) {
            logger.debug("wasEndedBy_ordering");
            this.constraint_wasEndedBy_ordering();
        }
        if (config.isTrue("generation_precedes_usage")) {
            logger.debug("generation_precedes_usage");
            this.constraint_generation_precedes_usage();
        }
        if (config.isTrue("wasInformedBy_ordering")) {
            logger.debug("wasInformedBy_ordering");
            this.constraint_wasInformedBy_ordering();
        }
        if (config.isTrue("wasAssociatedWith_ordering")) {
            logger.debug("wasAssociatedWith_ordering");
            this.constraint_wasAssociatedWith_ordering();
        }
        if (config.isTrue("wasAttributedTo_ordering")) {
            logger.debug("wasAttributedTo_ordering");
            this.constraint_wasAttributedTo_ordering();
        }
        if (config.isTrue("actedOnBehalfOf_ordering")) {
            logger.debug("actedOnBehalfOf_ordering");
            this.constraint_actedOnBehalfOf_ordering();
        }
        if (config.isTrue("generation_generation_ordering")) {
            logger.debug("generation_generation_ordering");
            this.constraint_generation_generation_ordering();
        }
        if (config.isTrue("invalidation_invalidation_ordering")) {
            logger.debug("invalidation_invalidation_ordering");
            this.constraint_invalidation_invalidation_ordering();
        }
        if (config.isTrue("start_start_ordering")) {
            logger.debug("start_start_ordering");
            this.constraint_start_start_ordering();
        }
        if (config.isTrue("end_end_ordering")) {
            logger.debug("end_end_ordering");
            this.constraint_end_end_ordering();
        }
        if (config.isTrue("specialization_generation_ordering")) {
            logger.debug("specialization_generation_ordering");
            this.constraint_specialization_generation_ordering();
        }
        if (config.isTrue("specialization_invalidation_ordering")) {
            logger.debug("specialization_invalidation_ordering");
            this.constraint_specialization_invalidation_ordering();
        }
        if (config.isTrue("entity_activity_disjoint")) {
            logger.debug("entity_activity_disjoint");
            this.constraint_entity_activity_disjoint();
        }
        logger.debug("do floydWarshall");
        this.matrix.floydWarshall();
    }

    public void constraint_start_precedes_end() {
        for (String key : this.inference.activityEntries.keySet()) {
            ActivityEntry ae = this.inference.activityEntries.get(key);
            for (String start : ae.getStartKey()) {
                for (String end : ae.getEndKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start), this.evtIndexer.eventIndex.get(end));
                }
            }
        }
    }

    public void constraint_generation_precedes_invalidation() {
        for (String key : this.inference.entityEntries.keySet()) {
            EntityEntry ee = this.inference.entityEntries.get(key);
            for (String generation : ee.getGenerationKey()) {
                for (String invalidation : ee.getInvalidationKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(generation), this.evtIndexer.eventIndex.get(invalidation));
                }
            }
        }
    }

    public void constraint_generation_precedes_usage() {
        for (String key : this.indexer.usedTable.keySet()) {
            EntityEntry ee;
            Used used = this.indexer.usedTable.get(key);
            QualifiedName e = used.getEntity();
            if (e == null || (ee = this.inference.entityEntries.get(e.getUri())) == null) continue;
            for (String generation : ee.getGenerationKey()) {
                this.precede(this.evtIndexer.eventIndex.get(generation), this.evtIndexer.eventIndex.get(key));
            }
        }
    }

    public void constraint_wasStartedBy_ordering() {
        for (String key : this.indexer.wasStartedByTable.keySet()) {
            WasStartedBy wasStartedBy = this.indexer.wasStartedByTable.get(key);
            this.constraint_start_end_ordering(key, wasStartedBy.getTrigger());
        }
    }

    public void constraint_wasEndedBy_ordering() {
        for (String key : this.indexer.wasEndedByTable.keySet()) {
            WasEndedBy wasEndedBy = this.indexer.wasEndedByTable.get(key);
            this.constraint_start_end_ordering(key, wasEndedBy.getTrigger());
        }
    }

    private void constraint_start_end_ordering(String key, QualifiedName trigger) {
        EntityEntry ee;
        if (trigger != null && (ee = this.inference.entityEntries.get(trigger.getUri())) != null) {
            for (String generation : ee.getGenerationKey()) {
                this.precede(this.evtIndexer.eventIndex.get(generation), this.evtIndexer.eventIndex.get(key));
            }
            for (String invalidation : ee.getInvalidationKey()) {
                this.precede(this.evtIndexer.eventIndex.get(key), this.evtIndexer.eventIndex.get(invalidation));
            }
        }
    }

    public void constraint_usage_precedes_invalidation() {
        for (String key : this.indexer.usedTable.keySet()) {
            EntityEntry ee;
            Used used = this.indexer.usedTable.get(key);
            QualifiedName e = used.getEntity();
            if (e == null || (ee = this.inference.entityEntries.get(e.getUri())) == null) continue;
            for (String invalidation : ee.getInvalidationKey()) {
                this.precede(this.evtIndexer.eventIndex.get(key), this.evtIndexer.eventIndex.get(invalidation));
            }
        }
    }

    public void constraint_usage_precedes_end() {
        for (String key : this.indexer.usedTable.keySet()) {
            ActivityEntry ae;
            Used used = this.indexer.usedTable.get(key);
            QualifiedName a = used.getActivity();
            if (a == null || (ae = this.inference.activityEntries.get(a.getUri())) == null) continue;
            for (String end : ae.getEndKey()) {
                this.precede(this.evtIndexer.eventIndex.get(key), this.evtIndexer.eventIndex.get(end));
            }
        }
    }

    public void constraint_generation_precedes_end() {
        for (String key : this.indexer.wasGeneratedByTable.keySet()) {
            ActivityEntry ae;
            WasGeneratedBy wasGeneratedBy = this.indexer.wasGeneratedByTable.get(key);
            QualifiedName a = wasGeneratedBy.getActivity();
            if (a == null || (ae = this.inference.activityEntries.get(a.getUri())) == null) continue;
            for (String end : ae.getEndKey()) {
                this.precede(this.evtIndexer.eventIndex.get(key), this.evtIndexer.eventIndex.get(end));
            }
        }
    }

    public void constraint_start_precedes_usage() {
        for (String usage : this.indexer.usedTable.keySet()) {
            ActivityEntry ae;
            Used used = this.indexer.usedTable.get(usage);
            QualifiedName a = used.getActivity();
            if (a == null || (ae = this.inference.activityEntries.get(a.getUri())) == null) continue;
            for (String start : ae.getStartKey()) {
                this.precede(this.evtIndexer.eventIndex.get(start), this.evtIndexer.eventIndex.get(usage));
            }
        }
    }

    public void constraint_start_precedes_generation() {
        for (String generation : this.indexer.wasGeneratedByTable.keySet()) {
            ActivityEntry ae;
            WasGeneratedBy wasGeneratedBy = this.indexer.wasGeneratedByTable.get(generation);
            QualifiedName a = wasGeneratedBy.getActivity();
            if (a == null || (ae = this.inference.activityEntries.get(a.getUri())) == null) continue;
            for (String start : ae.getStartKey()) {
                this.precede(this.evtIndexer.eventIndex.get(start), this.evtIndexer.eventIndex.get(generation));
            }
        }
    }

    public void constraint_derivation_generation_precedes_generation() {
        for (String key : this.indexer.wasDerivedFromTable.keySet()) {
            WasDerivedFrom wdf = this.indexer.wasDerivedFromTable.get(key);
            QualifiedName e2 = wdf.getGeneratedEntity();
            QualifiedName e1 = wdf.getUsedEntity();
            EntityEntry ee2 = this.inference.entityEntries.get(e2.getUri());
            EntityEntry ee1 = this.inference.entityEntries.get(e1.getUri());
            if (ee2 == null) continue;
            for (String generation2 : ee2.getGenerationKey()) {
                if (ee1 == null) continue;
                for (String generation1 : ee1.getGenerationKey()) {
                    logger.debug("g_g " + generation1 + " " + generation2);
                    this.precedeStrict(this.evtIndexer.eventIndex.get(generation1), this.evtIndexer.eventIndex.get(generation2));
                }
            }
        }
    }

    public void constraint_derivation_usage_generation_ordering() {
        for (String key : this.indexer.wasDerivedFromTable.keySet()) {
            WasDerivedFrom wdf = this.indexer.wasDerivedFromTable.get(key);
            QualifiedName genRef = wdf.getGeneration();
            QualifiedName useRef = wdf.getUsage();
            if (genRef == null || useRef == null) {
                return;
            }
            this.precede(this.evtIndexer.eventIndex.get(useRef.getUri()), this.evtIndexer.eventIndex.get(genRef.getUri()));
        }
    }

    public void constraint_wasInformedBy_ordering() {
        for (String key : this.indexer.wasInformedByTable.keySet()) {
            WasInformedBy wib = this.indexer.wasInformedByTable.get(key);
            QualifiedName informant = wib.getInformant();
            QualifiedName informed = wib.getInformed();
            ActivityEntry ae1 = this.inference.activityEntries.get(informant.getUri());
            ActivityEntry ae2 = this.inference.activityEntries.get(informed.getUri());
            for (String start : ae1.getStartKey()) {
                if (ae2 == null) continue;
                for (String end : ae2.getEndKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start), this.evtIndexer.eventIndex.get(end));
                }
            }
        }
    }

    public void constraint_wasAssociatedWith_ordering() {
        for (String key : this.indexer.wasAssociatedWithTable.keySet()) {
            ActivityEntry agA;
            WasAssociatedWith assoc = this.indexer.wasAssociatedWithTable.get(key);
            QualifiedName a = assoc.getActivity();
            ActivityEntry ae = this.inference.activityEntries.get(a.getUri());
            if (ae == null) continue;
            QualifiedName ag = assoc.getAgent();
            EntityEntry agE = this.inference.entityEntries.get(ag.getUri());
            if (agE != null) {
                for (String start : ae.getStartKey()) {
                    for (String invalidation : agE.getInvalidationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(start), this.evtIndexer.eventIndex.get(invalidation));
                    }
                }
                for (String end : ae.getEndKey()) {
                    for (String generation : agE.getGenerationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(generation), this.evtIndexer.eventIndex.get(end));
                    }
                }
            }
            if ((agA = this.inference.activityEntries.get(ag.getUri())) == null) continue;
            for (String start1 : ae.getStartKey()) {
                for (String end2 : agA.getEndKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start1), this.evtIndexer.eventIndex.get(end2));
                }
            }
            for (String end2 : ae.getEndKey()) {
                for (String start1 : agA.getStartKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start1), this.evtIndexer.eventIndex.get(end2));
                }
            }
        }
    }

    public void constraint_wasAttributedTo_ordering() {
        for (String key : this.indexer.wasAttributedToTable.keySet()) {
            WasAttributedTo wat = this.indexer.wasAttributedToTable.get(key);
            QualifiedName e = wat.getEntity();
            EntityEntry ee = this.inference.entityEntries.get(e.getUri());
            if (ee == null) {
                return;
            }
            for (String generation2 : ee.getGenerationKey()) {
                ActivityEntry agA;
                QualifiedName ag = wat.getAgent();
                EntityEntry agE = this.inference.entityEntries.get(ag.getUri());
                if (agE != null) {
                    for (String generation1 : agE.getGenerationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(generation1), this.evtIndexer.eventIndex.get(generation2));
                    }
                }
                if ((agA = this.inference.activityEntries.get(ag.getUri())) == null) continue;
                for (String start1 : agA.getStartKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start1), this.evtIndexer.eventIndex.get(generation2));
                }
            }
        }
    }

    public void constraint_actedOnBehalfOf_ordering() {
        for (String key : this.indexer.actedOnBehalfOfTable.keySet()) {
            ActedOnBehalfOf aob = this.indexer.actedOnBehalfOfTable.get(key);
            QualifiedName ag1 = aob.getResponsible();
            QualifiedName ag2 = aob.getDelegate();
            EntityEntry ee1 = this.inference.entityEntries.get(ag1.getUri());
            EntityEntry ee2 = this.inference.entityEntries.get(ag2.getUri());
            if (ee1 != null && ee2 != null) {
                for (String invalidation2 : ee2.getInvalidationKey()) {
                    for (String generation1 : ee1.getGenerationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(generation1), this.evtIndexer.eventIndex.get(invalidation2));
                    }
                }
            }
            ActivityEntry ae1 = this.inference.activityEntries.get(ag1.getUri());
            ActivityEntry ae2 = this.inference.activityEntries.get(ag2.getUri());
            if (ae1 == null || ae2 == null) continue;
            for (String end2 : ae2.getEndKey()) {
                for (String start1 : ae1.getStartKey()) {
                    this.precede(this.evtIndexer.eventIndex.get(start1), this.evtIndexer.eventIndex.get(end2));
                }
            }
        }
    }

    public void constraint_generation_generation_ordering() {
        for (String key : this.inference.entityEntries.keySet()) {
            EntityEntry ee = this.inference.entityEntries.get(key);
            for (String generation1 : ee.getGenerationKey()) {
                for (String generation2 : ee.getGenerationKey()) {
                    if (Objects.equals(generation1, generation2)) continue;
                    this.precede(this.evtIndexer.eventIndex.get(generation1), this.evtIndexer.eventIndex.get(generation2));
                }
            }
        }
    }

    public void constraint_invalidation_invalidation_ordering() {
        for (String key : this.inference.entityEntries.keySet()) {
            EntityEntry ee = this.inference.entityEntries.get(key);
            for (String invalidation1 : ee.getInvalidationKey()) {
                for (String invalidation2 : ee.getInvalidationKey()) {
                    if (Objects.equals(invalidation1, invalidation2)) continue;
                    this.precede(this.evtIndexer.eventIndex.get(invalidation1), this.evtIndexer.eventIndex.get(invalidation2));
                }
            }
        }
    }

    public void constraint_start_start_ordering() {
        for (String key : this.inference.activityEntries.keySet()) {
            ActivityEntry ee = this.inference.activityEntries.get(key);
            for (String start1 : ee.getStartKey()) {
                for (String start2 : ee.getStartKey()) {
                    if (Objects.equals(start1, start2)) continue;
                    this.precede(this.evtIndexer.eventIndex.get(start1), this.evtIndexer.eventIndex.get(start2));
                }
            }
        }
    }

    public void constraint_end_end_ordering() {
        for (String key : this.inference.activityEntries.keySet()) {
            ActivityEntry ee = this.inference.activityEntries.get(key);
            for (String end1 : ee.getEndKey()) {
                for (String end2 : ee.getEndKey()) {
                    if (Objects.equals(end1, end2)) continue;
                    this.precede(this.evtIndexer.eventIndex.get(end1), this.evtIndexer.eventIndex.get(end2));
                }
            }
        }
    }

    public void constraint_specialization_generation_ordering() {
        for (String key2 : this.inference.entityEntries.keySet()) {
            EntityEntry ee2 = this.inference.entityEntries.get(key2);
            for (String generation2 : ee2.getGenerationKey()) {
                Set<QualifiedName> set1;
                QualifiedName entity2 = this.indexer.wasGeneratedByTable.get(generation2).getEntity();
                if (this.inference.specializationTable == null || (set1 = this.inference.specializationTable.get(entity2)) == null) continue;
                for (QualifiedName entity1 : set1) {
                    String key1 = entity1.getUri();
                    EntityEntry ee1 = this.inference.entityEntries.get(key1);
                    if (ee1 == null) continue;
                    for (String generation1 : ee1.getGenerationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(generation1), this.evtIndexer.eventIndex.get(generation2));
                    }
                }
            }
        }
    }

    public void constraint_specialization_invalidation_ordering() {
        for (String key2 : this.inference.entityEntries.keySet()) {
            EntityEntry ee2 = this.inference.entityEntries.get(key2);
            for (String invalidation2 : ee2.getInvalidationKey()) {
                Set<QualifiedName> set1;
                QualifiedName entity2 = this.indexer.wasInvalidatedByTable.get(invalidation2).getEntity();
                if (this.inference.specializationTable == null || (set1 = this.inference.specializationTable.get(entity2)) == null) continue;
                for (QualifiedName entity1 : set1) {
                    String key1 = entity1.getUri();
                    EntityEntry ee1 = this.inference.entityEntries.get(key1);
                    if (ee1 == null) continue;
                    for (String invalidation1 : ee1.getInvalidationKey()) {
                        this.precede(this.evtIndexer.eventIndex.get(invalidation2), this.evtIndexer.eventIndex.get(invalidation1));
                    }
                }
            }
        }
    }

    public void constraint_entity_activity_disjoint() {
        for (String key : this.typeChecker.aggregatedTypes.keySet()) {
            Set<String> types = this.typeChecker.aggregatedTypes.get(key);
            if (types == null) {
                throw new UnsupportedOperationException();
            }
            Collection<String> invalid = this.typeChecker.conflictingTypes(types);
            if (invalid == null) continue;
            this.typeOverlapTable.put(key, invalid);
        }
    }

    public void precede(Integer event1, Integer event2) {
        Pair p;
        if (event1 == null || event2 == null) {
            return;
        }
        logger.debug("precede: " + event1 + " " + event2);
        if (event1 < this.max && event2 < this.max && (p = this.matrix.m.g(event1, event2)) == null) {
            this.matrix.m.set(event1, event2, 2);
        }
    }

    public void precedeStrict(Integer event1, Integer event2) {
        if (event1 == null || event2 == null) {
            return;
        }
        logger.debug("precede strict: " + event1 + " " + event2);
        if (event1 < this.max && event2 < this.max) {
            this.matrix.m.set(event1, event2, 1);
        }
    }
}

