/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.Indexer;

public class Types {
    static Logger logger = LogManager.getLogger(Types.class);
    final ProvUtilities u;
    private final Config config;
    private final Indexer indexer;
    public static final String VAL_TYPE_NS = "http://openprovenance.org/validation/type/";
    public static final String VAL_TYPE_IGNORE_NS = "http://openprovenance.org/validation/type/ignore/";
    public final Hashtable<String, Set<String>> illegalOverlaps;
    public static String activityURI = "http://openprovenance.org/validation/type/Activity";
    public static String entityURI = "http://openprovenance.org/validation/type/Entity";
    public static String agentURI = "http://openprovenance.org/validation/type/Agent";
    public static String generationURI = "http://openprovenance.org/validation/type/Generation";
    public static String usageURI = "http://openprovenance.org/validation/type/Usage";
    public static String communicationURI = "http://openprovenance.org/validation/type/Communication";
    public static String startURI = "http://openprovenance.org/validation/type/Start";
    public static String endURI = "http://openprovenance.org/validation/type/End";
    public static String invalidationURI = "http://openprovenance.org/validation/type/Invalidation";
    public static String derivationURI = "http://openprovenance.org/validation/type/Derivation";
    public static String revisionURI = "http://openprovenance.org/validation/type/Revision";
    public static String quotationURI = "http://openprovenance.org/validation/type/Quotation";
    public static String primarySourceURI = "http://openprovenance.org/validation/type/PrimarySource";
    public static String attributionURI = "http://openprovenance.org/validation/type/Attribution";
    public static String associationURI = "http://openprovenance.org/validation/type/Association";
    public static String delegationURI = "http://openprovenance.org/validation/type/Delegation";
    public static String influenceURI = "http://openprovenance.org/validation/type/Influence";
    public static String bundleURI = "http://openprovenance.org/validation/type/Bundle";
    public static String collectionURI = "http://openprovenance.org/validation/type/Collection";
    public static String emptyCollectionURI = "http://openprovenance.org/validation/type/EmptyCollection";
    public static String personURI = "http://openprovenance.org/validation/type/Person";
    public static String organizationURI = "http://openprovenance.org/validation/type/Organization";
    public static String softwareAgentURI = "http://openprovenance.org/validation/type/SoftwareAgent";
    public static String nonEmptyCollectionURI = "http://openprovenance.org/validation/type/NonEmptyCollection";
    public final Hashtable<Integer, String> uriTypeIndex = new Hashtable();
    public final Set<String> theURIs = new HashSet<String>();
    public Hashtable<String, Set<String>> aggregatedTypes = new Hashtable();

    public Types(Indexer indexer, ProvUtilities u, Config config) {
        this.indexer = indexer;
        this.illegalOverlaps = new Hashtable();
        this.config = config;
        this.u = u;
        this.initializeTypes(this.uriTypeIndex);
        this.initializeOverlaps(this.illegalOverlaps);
        this.theURIs.addAll(this.uriTypeIndex.values());
    }

    public void initializeTypes(Hashtable<Integer, String> types) {
        types.put(0, entityURI);
        types.put(1, activityURI);
        types.put(2, agentURI);
        types.put(3, generationURI);
        types.put(4, usageURI);
        types.put(5, communicationURI);
        types.put(6, startURI);
        types.put(7, endURI);
        types.put(8, invalidationURI);
        types.put(9, derivationURI);
        types.put(10, revisionURI);
        types.put(11, quotationURI);
        types.put(12, primarySourceURI);
        types.put(13, attributionURI);
        types.put(14, associationURI);
        types.put(15, delegationURI);
        types.put(16, influenceURI);
        types.put(17, bundleURI);
        types.put(18, collectionURI);
        types.put(19, emptyCollectionURI);
        types.put(20, personURI);
        types.put(21, organizationURI);
        types.put(22, softwareAgentURI);
        types.put(23, nonEmptyCollectionURI);
    }

    public Set<String> getTypes(Integer[] indexes) {
        HashSet<String> set = new HashSet<String>();
        Integer[] integerArray = indexes;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            set.add(this.uriTypeIndex.get(i2));
        }
        return set;
    }

    void initializeOverlaps(Hashtable<String, Set<String>> illegal) {
        illegal.put(entityURI, this.getTypes(new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(activityURI, this.getTypes(new Integer[]{0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19}));
        illegal.put(agentURI, this.getTypes(new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(generationURI, this.getTypes(new Integer[]{0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(usageURI, this.getTypes(new Integer[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(communicationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(startURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(endURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(invalidationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(derivationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(revisionURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(quotationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(primarySourceURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(attributionURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(associationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(delegationURI, this.getTypes(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(influenceURI, this.getTypes(new Integer[]{0, 1, 2, 3, 17, 18, 19, 20, 21, 22, 23}));
        illegal.put(bundleURI, this.getTypes(new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}));
        illegal.put(collectionURI, this.getTypes(new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(emptyCollectionURI, this.getTypes(new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 23}));
        illegal.put(personURI, this.getTypes(new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(organizationURI, this.getTypes(new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(softwareAgentURI, this.getTypes(new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}));
        illegal.put(nonEmptyCollectionURI, this.getTypes(new Integer[]{1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19}));
    }

    public Collection<String> conflictingTypes(Collection<String> types) {
        if (types.isEmpty()) {
            return types;
        }
        HashSet<String> theConflicts = new HashSet<String>();
        for (String s : types) {
            Set<String> illegal = this.illegalOverlaps.get(s);
            if (illegal == null) continue;
            HashSet<String> illegalForS = new HashSet<String>(illegal);
            illegalForS.retainAll(types);
            if (illegalForS.isEmpty()) continue;
            theConflicts.addAll(illegalForS);
            theConflicts.add(s);
        }
        return theConflicts;
    }

    public void addInferredType(QualifiedName ref, String type) {
        String id = ref.getUri();
        this.addInferredType(id, type);
    }

    public void addInferredType(String id, String type) {
        if (this.config.isTrue("typing")) {
            Set objects = this.aggregatedTypes.computeIfAbsent(id, k -> new HashSet());
            objects.add(type);
        }
    }

    public void addDeclaredTypes() {
        logger.debug("updateTypes: ");
        this.addDeclaredTypes(Entity.class, this.indexer.entityTable);
        this.addDeclaredTypes(Activity.class, this.indexer.activityTable);
        this.addDeclaredTypes(Agent.class, this.indexer.agentTable);
        this.addDeclaredTypes(WasStartedBy.class, this.indexer.wasStartedByTable);
        this.addDeclaredTypes(WasEndedBy.class, this.indexer.wasEndedByTable);
        this.addDeclaredTypes(WasGeneratedBy.class, this.indexer.wasGeneratedByTable);
        this.addDeclaredTypes(WasInvalidatedBy.class, this.indexer.wasInvalidatedByTable);
        this.addDeclaredTypes(WasDerivedFrom.class, this.indexer.wasDerivedFromTable);
        this.addDeclaredTypes(WasAttributedTo.class, this.indexer.wasAttributedToTable);
        this.addDeclaredTypes(WasAssociatedWith.class, this.indexer.wasAssociatedWithTable);
        this.addDeclaredTypes(ActedOnBehalfOf.class, this.indexer.actedOnBehalfOfTable);
        this.addDeclaredTypes(Used.class, this.indexer.usedTable);
    }

    public <Entry extends Statement> void addDeclaredTypes(Class<Entry> class1, Hashtable<String, Entry> table1) {
        for (String key : table1.keySet()) {
            Statement entry = (Statement)table1.get(key);
            if (entry != null) {
                logger.debug("updateTypes <T>  to " + key);
                String entryURI = ((Identifiable)entry).getId().getUri();
                HashSet set = new HashSet(this.indexer.getTypeTable(entry).get(entryURI));
                List types = ((HasType)entry).getType();
                for (Type type : types) {
                    set.remove(type);
                }
                types.addAll(set);
                for (Type o : types) {
                    this.addAsValidatorType(entryURI, o);
                }
                continue;
            }
            logger.debug("updateAttributes  coudln't find entry " + key);
            throw new UnsupportedOperationException();
        }
    }

    public void addAsValidatorType(String entryURI, Type t) {
        Object o = t.getValue();
        logger.debug("++++++++++++++++++ addAsValidatorType " + String.valueOf(o));
        if (o instanceof QualifiedName) {
            QualifiedName qn = (QualifiedName)o;
            this.addInferredType(entryURI, this.convertToValidatorURI(qn.getUri()));
        } else if (o instanceof String) {
            this.addInferredType(entryURI, this.convertToValidatorURI(o.toString()));
        } else if (o instanceof URI) {
            this.addInferredType(entryURI, this.convertToValidatorURI(o.toString()));
        } else {
            this.addInferredType(entryURI, "unkwnown:" + String.valueOf(o));
        }
    }

    public String convertToValidatorURI(String uri) {
        if (uri.startsWith("http://www.w3.org/ns/prov#")) {
            return VAL_TYPE_NS + uri.substring("http://www.w3.org/ns/prov#".length());
        }
        if (uri.startsWith(VAL_TYPE_NS)) {
            return VAL_TYPE_IGNORE_NS + uri.substring(VAL_TYPE_NS.length());
        }
        return uri;
    }
}

