/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.ActedOnBehalfOf;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Agent;
import org.openprovenance.prov.model.AlternateOf;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.DerivedByInsertionFrom;
import org.openprovenance.prov.model.DerivedByRemovalFrom;
import org.openprovenance.prov.model.DictionaryMembership;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.HadMember;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.Influence;
import org.openprovenance.prov.model.MentionOf;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementAction;
import org.openprovenance.prov.model.StatementActionValue;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.Used;
import org.openprovenance.prov.model.WasAssociatedWith;
import org.openprovenance.prov.model.WasAttributedTo;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasGeneratedBy;
import org.openprovenance.prov.model.WasInfluencedBy;
import org.openprovenance.prov.model.WasInformedBy;
import org.openprovenance.prov.model.WasInvalidatedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.extension.QualifiedAlternateOf;
import org.openprovenance.prov.model.extension.QualifiedHadMember;
import org.openprovenance.prov.model.extension.QualifiedSpecializationOf;
import org.openprovenance.prov.validation.Gensym;
import org.openprovenance.prov.validation.Merger;
import org.openprovenance.prov.validation.ObjectMaker;
import org.openprovenance.prov.validation.VarQName;

public class Indexer {
    static Logger logger = LogManager.getLogger(Indexer.class);
    final ProvUtilities u = new ProvUtilities();
    public final Gensym g;
    public final Namespace namespace = new Namespace();
    Merger merger;
    final ProvFactory p;
    public Hashtable<String, Entity> entityTable = new Hashtable();
    public Hashtable<String, Activity> activityTable = new Hashtable();
    public Hashtable<String, Agent> agentTable = new Hashtable();
    public Hashtable<String, Used> usedTable = new Hashtable();
    public Hashtable<String, WasGeneratedBy> wasGeneratedByTable = new Hashtable();
    public Hashtable<String, WasInvalidatedBy> wasInvalidatedByTable = new Hashtable();
    public Hashtable<String, WasStartedBy> wasStartedByTable = new Hashtable();
    public Hashtable<String, WasEndedBy> wasEndedByTable = new Hashtable();
    public Hashtable<String, WasDerivedFrom> wasDerivedFromTable = new Hashtable();
    public Hashtable<String, WasInformedBy> wasInformedByTable = new Hashtable();
    public Hashtable<String, WasAssociatedWith> wasAssociatedWithTable = new Hashtable();
    public Hashtable<String, WasAttributedTo> wasAttributedToTable = new Hashtable();
    public Hashtable<String, WasInfluencedBy> wasInfluencedByTable = new Hashtable();
    public Hashtable<String, ActedOnBehalfOf> actedOnBehalfOfTable = new Hashtable();
    public Hashtable<String, MentionOf> mentionOfTable = new Hashtable();
    public List<AlternateOf> alternateOfList = new LinkedList<AlternateOf>();
    public List<SpecializationOf> specializationOfList = new LinkedList<SpecializationOf>();
    public List<HadMember> membershipList = new LinkedList<HadMember>();
    public Hashtable<String, Set<Object>> entityTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> activityTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> agentTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> usedTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasGeneratedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasInvalidatedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasStartedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasEndedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasDerivedFromTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasInformedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasAssociatedWithTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasAttributedToTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> wasInfluencedByTypeTable = new Hashtable();
    public Hashtable<String, Set<Object>> actedOnBehalfOfTypeTable = new Hashtable();
    public final Hashtable<String, List<Statement>> successfulMerge = new Hashtable();
    public final Hashtable<String, List<Statement>> failedMerge = new Hashtable();
    public final Hashtable<String, List<Statement>> qualifiedNameMismatch = new Hashtable();

    public Indexer(ProvFactory p, ObjectMaker om, boolean staticGensym) {
        this.p = p;
        this.g = new Gensym(this.namespace, p, om, staticGensym);
        this.registerNamespaces(this.namespace);
        this.merger = new Merger(p, this.u, this.qualifiedNameMismatch, this);
        this.mentionOfTable = new Hashtable();
    }

    public void registerNamespaces(Namespace namespace) {
        namespace.register("xsd", "http://www.w3.org/2001/XMLSchema#");
        namespace.register("val", this.g.this_VAL_URI);
        namespace.registerDefault(this.g.this_VAL_URI);
        namespace.register("ex", "http://example.org/");
    }

    public void index(Document doc) {
        List recs = this.u.getStatement(doc);
        this.index(recs);
    }

    public void index(Bundle bundle) {
        List recs = this.u.getStatement(bundle);
        this.index(recs);
    }

    public <T extends Statement> void addTypeAttributes(T entry) {
        this.addTypeAttributes(this.getTypeTable(entry), entry);
    }

    public <T extends Statement> Hashtable<String, Set<Type>> getTypeTable(T entry) {
        Object o = this.u.doAction(entry, (StatementActionValue)new TypeTable());
        Hashtable table = (Hashtable)o;
        return table;
    }

    public void index(List<Statement> recs) {
        this.u.forAllStatement(recs, (StatementAction)new IndexAction());
    }

    public <T extends Statement> void addTypeAttributes(Hashtable<String, Set<Type>> typeTable, T e) {
        if (e instanceof Identifiable && e instanceof HasType) {
            HasType o = (HasType)e;
            String id = ((Identifiable)o).getId().getUri();
            Set<Type> entry = typeTable.get(id);
            if (entry == null) {
                entry = new HashSet<Type>();
                typeTable.put(id, entry);
            }
            entry.addAll(o.getType());
        }
    }

    public String summary() {
        LinkedList<String> el = new LinkedList<String>(this.entityTable.keySet());
        Collections.sort(el);
        LinkedList<String> agl = new LinkedList<String>(this.agentTable.keySet());
        Collections.sort(agl);
        LinkedList<String> al = new LinkedList<String>(this.activityTable.keySet());
        Collections.sort(al);
        LinkedList<String> ul = new LinkedList<String>(this.usedTable.keySet());
        Collections.sort(ul);
        LinkedList<String> gl = new LinkedList<String>(this.wasGeneratedByTable.keySet());
        Collections.sort(gl);
        LinkedList<String> il = new LinkedList<String>(this.wasInvalidatedByTable.keySet());
        Collections.sort(il);
        LinkedList<String> sl = new LinkedList<String>(this.wasStartedByTable.keySet());
        Collections.sort(sl);
        LinkedList<String> edl = new LinkedList<String>(this.wasEndedByTable.keySet());
        Collections.sort(edl);
        LinkedList<String> dl = new LinkedList<String>(this.wasDerivedFromTable.keySet());
        Collections.sort(dl);
        LinkedList<String> wibl = new LinkedList<String>(this.wasInformedByTable.keySet());
        Collections.sort(wibl);
        LinkedList<String> assocl = new LinkedList<String>(this.wasAssociatedWithTable.keySet());
        Collections.sort(assocl);
        LinkedList<String> watl = new LinkedList<String>(this.wasAttributedToTable.keySet());
        Collections.sort(watl);
        LinkedList<String> winflbl = new LinkedList<String>(this.wasInfluencedByTable.keySet());
        Collections.sort(watl);
        LinkedList<String> aobl = new LinkedList<String>(this.actedOnBehalfOfTable.keySet());
        Collections.sort(aobl);
        return "index: \n entity: " + String.valueOf(el) + "\n activity: " + String.valueOf(al) + "\n agent: " + String.valueOf(agl) + "\n used: " + String.valueOf(ul) + "\n wasGeneratedBy: " + String.valueOf(gl) + "\n wasInvalidatedBy: " + String.valueOf(il) + "\n wasStartedBy: " + String.valueOf(sl) + "\n wasEndedBy: " + String.valueOf(edl) + "\n wasInformedBy: " + String.valueOf(wibl) + "\n wasAssociatedWith: " + String.valueOf(assocl) + "\n wasAttributedTo: " + String.valueOf(watl) + "\n actedOnBehalfOf: " + String.valueOf(aobl) + "\n wasInfluencedBy: " + String.valueOf(winflbl) + "\n wasDerivedFrom: " + String.valueOf(dl);
    }

    public boolean existentialVariable(String uri) {
        return uri.startsWith(this.g.this_VAL_URI);
    }

    public boolean existentialVariable(QualifiedName name) {
        return name instanceof VarQName;
    }

    public <T> void putInTable(Hashtable<Class, Hashtable<String, T>> t, Class<?> c, Hashtable<String, T> e) {
        t.put(c, e);
    }

    public <T> Hashtable<Class, Hashtable> makeTableIndex() {
        Hashtable<Class, Hashtable> table = new Hashtable<Class, Hashtable>();
        table.put(Entity.class, this.entityTable);
        table.put(Activity.class, this.activityTable);
        return table;
    }

    public Entity resolveDuplicate(Entity e, Entity entry) {
        String uri = e.getId().getUri();
        List l = this.successfulMerge.computeIfAbsent(uri, k -> new LinkedList());
        l.add(e);
        return this.p.addAttributes(e, entry);
    }

    private void showStacktrace() {
        try {
            throw new NullPointerException();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return;
        }
    }

    public Activity resolveDuplicate(Activity a, Activity entry) {
        String uri = a.getId().getUri();
        Activity isMerged = this.merger.merge(a, entry);
        if (isMerged != null) {
            List l = this.successfulMerge.computeIfAbsent(uri, k -> new LinkedList());
            l.add(a);
            return this.p.addAttributes(a, entry);
        }
        this.addToFailedMerge(a, entry, uri);
        return entry;
    }

    public Agent resolveDuplicate(Agent ag, Agent entry) {
        String uri = ag.getId().getUri();
        List l = this.successfulMerge.computeIfAbsent(uri, k -> new LinkedList());
        l.add(ag);
        return this.p.addAttributes(ag, entry);
    }

    public <T extends Influence> T resolveDuplicate(T fluen, T entry) {
        String uri = fluen.getId().getUri();
        T isMerged = this.merger.merge(fluen, entry);
        if (isMerged != null) {
            List<Statement> l = this.successfulMerge.get(uri);
            if (l == null) {
                l = new LinkedList<Statement>();
                l.add((Statement)entry);
                this.successfulMerge.put(uri, l);
            }
            l.add((Statement)fluen);
            return this.addAttributes(fluen, entry);
        }
        this.addToFailedMerge(fluen, entry, uri);
        return entry;
    }

    public <T> T addAttributes(T from, T to) {
        if (from instanceof Used) {
            return (T)this.p.addAttributes((Used)from, (Used)to);
        }
        if (from instanceof WasStartedBy) {
            return (T)this.p.addAttributes((WasStartedBy)from, (WasStartedBy)to);
        }
        if (from instanceof WasEndedBy) {
            return (T)this.p.addAttributes((WasEndedBy)from, (WasEndedBy)to);
        }
        if (from instanceof WasGeneratedBy) {
            return (T)this.p.addAttributes((WasGeneratedBy)from, (WasGeneratedBy)to);
        }
        if (from instanceof WasDerivedFrom) {
            return (T)this.p.addAttributes((WasDerivedFrom)from, (WasDerivedFrom)to);
        }
        if (from instanceof WasAssociatedWith) {
            return (T)this.p.addAttributes((WasAssociatedWith)from, (WasAssociatedWith)to);
        }
        if (from instanceof WasInvalidatedBy) {
            return (T)this.p.addAttributes((WasInvalidatedBy)from, (WasInvalidatedBy)to);
        }
        if (from instanceof WasAttributedTo) {
            return (T)this.p.addAttributes((WasAttributedTo)from, (WasAttributedTo)to);
        }
        if (from instanceof WasInformedBy) {
            return (T)this.p.addAttributes((WasInformedBy)from, (WasInformedBy)to);
        }
        if (from instanceof WasInfluencedBy) {
            return (T)this.p.addAttributes((WasInfluencedBy)from, (WasInfluencedBy)to);
        }
        if (from instanceof ActedOnBehalfOf) {
            return (T)this.p.addAttributes((ActedOnBehalfOf)from, (ActedOnBehalfOf)to);
        }
        System.out.println("addAttributes Unknown relation " + String.valueOf(from));
        throw new UnsupportedOperationException();
    }

    public MentionOf resolveDuplicate(MentionOf men, MentionOf entry) {
        String uri = men.getSpecificEntity().getUri();
        MentionOf isMerged = this.merger.merge(men, entry);
        if (isMerged != null) {
            List<Statement> l = this.successfulMerge.get(uri);
            if (l == null) {
                l = new LinkedList<Statement>();
                l.add((Statement)entry);
                this.successfulMerge.put(uri, l);
            }
            l.add((Statement)men);
            return entry;
        }
        this.addToFailedMerge(men, entry, uri);
        return entry;
    }

    public void addToFailedMerge(Activity a, Activity entry, String uri) {
        List<Statement> l = this.failedMerge.get(uri);
        if (l == null) {
            l = new LinkedList<Statement>();
            l.add((Statement)entry);
            this.failedMerge.put(uri, l);
        }
        l.add((Statement)a);
    }

    public void addToFailedMerge(MentionOf a, MentionOf entry, String uri) {
        List<Statement> l = this.failedMerge.get(uri);
        if (l == null) {
            l = new LinkedList<Statement>();
            l.add((Statement)entry);
            this.failedMerge.put(uri, l);
        }
        l.add((Statement)a);
    }

    public void addToFailedMerge(Activity a, Statement entry, String uri) {
        List<Statement> l = this.failedMerge.get(uri);
        if (l == null) {
            l = new LinkedList<Statement>();
            l.add(entry);
            this.failedMerge.put(uri, l);
        }
        l.add((Statement)a);
    }

    public <T extends Influence> void addToFailedMerge(T fluen, T entry, String uri) {
        List<Statement> l = this.failedMerge.get(uri);
        if (l == null) {
            l = new LinkedList<Statement>();
            l.add((Statement)entry);
            this.failedMerge.put(uri, l);
        }
        l.add((Statement)fluen);
    }

    public class TypeTable
    implements StatementActionValue {
        public Object doAction(Entity e) {
            return Indexer.this.entityTypeTable;
        }

        public Object doAction(Activity a) {
            return Indexer.this.activityTypeTable;
        }

        public Object doAction(Agent ag) {
            return Indexer.this.agentTypeTable;
        }

        public Object doAction(WasGeneratedBy gen) {
            return Indexer.this.wasGeneratedByTypeTable;
        }

        public Object doAction(Used use) {
            return Indexer.this.usedTypeTable;
        }

        public Object doAction(WasInvalidatedBy inv) {
            return Indexer.this.wasInvalidatedByTypeTable;
        }

        public Object doAction(WasStartedBy start) {
            return Indexer.this.wasStartedByTypeTable;
        }

        public Object doAction(WasEndedBy end) {
            return Indexer.this.wasEndedByTypeTable;
        }

        public Object doAction(WasInformedBy inf) {
            return Indexer.this.wasInformedByTypeTable;
        }

        public Object doAction(WasDerivedFrom der) {
            return Indexer.this.wasDerivedFromTypeTable;
        }

        public Object doAction(WasAssociatedWith assoc) {
            return Indexer.this.wasAssociatedWithTypeTable;
        }

        public Object doAction(WasAttributedTo attr) {
            return Indexer.this.wasAttributedToTypeTable;
        }

        public Object doAction(ActedOnBehalfOf del) {
            return Indexer.this.actedOnBehalfOfTypeTable;
        }

        public Object doAction(WasInfluencedBy inf) {
            return Indexer.this.wasInfluencedByTypeTable;
        }

        public Object doAction(AlternateOf alt) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(MentionOf men) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(SpecializationOf spec) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(QualifiedSpecializationOf spec) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(QualifiedHadMember mem) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(QualifiedAlternateOf mem) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(HadMember mem) {
            throw new UnsupportedOperationException();
        }

        public Object doAction(DictionaryMembership s) {
            return null;
        }

        public Object doAction(DerivedByRemovalFrom s) {
            return null;
        }

        public Object doAction(DerivedByInsertionFrom s) {
            return null;
        }

        public Object doAction(Bundle s, ProvUtilities provUtilities) {
            return null;
        }
    }

    class IndexAction
    implements StatementAction {
        IndexAction() {
        }

        public void doAction(Entity e) {
            String uri = e.getId().getUri();
            Entity entry = Indexer.this.entityTable.get(uri);
            if (entry == null) {
                entry = Indexer.this.p.newEntity(e);
                Indexer.this.p.addAttributes(e, entry);
                Indexer.this.entityTable.put(uri, entry);
            } else {
                Indexer.this.entityTable.put(uri, Indexer.this.resolveDuplicate(e, entry));
            }
            Indexer.this.addTypeAttributes(e);
        }

        public void doAction(Activity a) {
            String uri = a.getId().getUri();
            Activity entry = Indexer.this.activityTable.get(uri);
            if (entry == null) {
                Indexer.this.activityTable.put(uri, a);
            } else {
                Indexer.this.activityTable.put(uri, Indexer.this.resolveDuplicate(a, entry));
            }
            Indexer.this.addTypeAttributes(a);
        }

        public void doAction(Agent ag) {
            String uri = ag.getId().getUri();
            Agent entry = Indexer.this.agentTable.get(uri);
            if (entry == null) {
                Indexer.this.agentTable.put(uri, ag);
            } else {
                Indexer.this.agentTable.put(uri, Indexer.this.resolveDuplicate(ag, entry));
            }
            Indexer.this.addTypeAttributes(ag);
        }

        public void doAction(WasGeneratedBy gen) {
            String uri;
            WasGeneratedBy entry;
            if (gen.getId() == null) {
                Indexer.this.g.setId(gen);
            }
            if ((entry = Indexer.this.wasGeneratedByTable.get(uri = gen.getId().getUri())) == null) {
                Indexer.this.wasGeneratedByTable.put(uri, gen);
            } else {
                Indexer.this.wasGeneratedByTable.put(uri, Indexer.this.resolveDuplicate(gen, entry));
            }
            Indexer.this.addTypeAttributes(gen);
        }

        public void doAction(Used use) {
            String uri;
            Used entry;
            if (use.getId() == null) {
                Indexer.this.g.setId(use);
            }
            if ((entry = Indexer.this.usedTable.get(uri = use.getId().getUri())) == null) {
                Indexer.this.usedTable.put(uri, use);
            } else {
                Indexer.this.usedTable.put(uri, Indexer.this.resolveDuplicate(use, entry));
            }
            Indexer.this.addTypeAttributes(use);
        }

        public void doAction(WasInvalidatedBy inv) {
            String uri;
            WasInvalidatedBy entry;
            if (inv.getId() == null) {
                Indexer.this.g.setId(inv);
            }
            if ((entry = Indexer.this.wasInvalidatedByTable.get(uri = inv.getId().getUri())) == null) {
                Indexer.this.wasInvalidatedByTable.put(uri, inv);
            } else {
                Indexer.this.wasInvalidatedByTable.put(uri, Indexer.this.resolveDuplicate(inv, entry));
            }
            Indexer.this.addTypeAttributes(inv);
        }

        public void doAction(WasInformedBy inf) {
            String uri;
            WasInformedBy entry;
            if (inf.getId() == null) {
                Indexer.this.g.setId(inf);
            }
            if ((entry = Indexer.this.wasInformedByTable.get(uri = inf.getId().getUri())) == null) {
                Indexer.this.wasInformedByTable.put(uri, inf);
            } else {
                Indexer.this.wasInformedByTable.put(uri, Indexer.this.resolveDuplicate(inf, entry));
            }
            Indexer.this.addTypeAttributes(inf);
        }

        public void doAction(WasStartedBy start) {
            String uri;
            WasStartedBy entry;
            if (start.getId() == null) {
                Indexer.this.g.setId(start);
            }
            if ((entry = Indexer.this.wasStartedByTable.get(uri = start.getId().getUri())) == null) {
                Indexer.this.wasStartedByTable.put(uri, start);
            } else {
                logger.debug("index(): calling resolveDuplicate  ++++++++ ");
                Indexer.this.wasStartedByTable.put(uri, Indexer.this.resolveDuplicate(start, entry));
            }
            Indexer.this.addTypeAttributes(start);
        }

        public void doAction(WasEndedBy end) {
            String uri;
            WasEndedBy entry;
            if (end.getId() == null) {
                Indexer.this.g.setId(end);
            }
            if ((entry = Indexer.this.wasEndedByTable.get(uri = end.getId().getUri())) == null) {
                Indexer.this.wasEndedByTable.put(uri, end);
            } else {
                Indexer.this.wasEndedByTable.put(uri, Indexer.this.resolveDuplicate(end, entry));
            }
            Indexer.this.addTypeAttributes(end);
        }

        public void doAction(WasDerivedFrom der) {
            String uri;
            WasDerivedFrom entry;
            if (der.getId() == null) {
                Indexer.this.g.setId(der);
            }
            if ((entry = Indexer.this.wasDerivedFromTable.get(uri = der.getId().getUri())) == null) {
                Indexer.this.wasDerivedFromTable.put(uri, der);
            } else {
                Indexer.this.wasDerivedFromTable.put(uri, Indexer.this.resolveDuplicate(der, entry));
            }
            Indexer.this.addTypeAttributes(der);
        }

        public void doAction(WasAssociatedWith assoc) {
            String uri;
            WasAssociatedWith entry;
            if (assoc.getId() == null) {
                Indexer.this.g.setId(assoc);
            }
            if ((entry = Indexer.this.wasAssociatedWithTable.get(uri = assoc.getId().getUri())) == null) {
                Indexer.this.wasAssociatedWithTable.put(uri, assoc);
            } else {
                Indexer.this.wasAssociatedWithTable.put(uri, Indexer.this.resolveDuplicate(assoc, entry));
            }
            Indexer.this.addTypeAttributes(assoc);
        }

        public void doAction(WasAttributedTo attr) {
            String uri;
            WasAttributedTo entry;
            if (attr.getId() == null) {
                Indexer.this.g.setId(attr);
            }
            if ((entry = Indexer.this.wasAttributedToTable.get(uri = attr.getId().getUri())) == null) {
                Indexer.this.wasAttributedToTable.put(uri, attr);
            } else {
                Indexer.this.wasAttributedToTable.put(uri, Indexer.this.resolveDuplicate(attr, entry));
            }
            Indexer.this.addTypeAttributes(attr);
        }

        public void doAction(ActedOnBehalfOf del) {
            String uri;
            ActedOnBehalfOf entry;
            if (del.getId() == null) {
                Indexer.this.g.setId(del);
            }
            if ((entry = Indexer.this.actedOnBehalfOfTable.get(uri = del.getId().getUri())) == null) {
                Indexer.this.actedOnBehalfOfTable.put(uri, del);
            } else {
                Indexer.this.actedOnBehalfOfTable.put(uri, Indexer.this.resolveDuplicate(del, entry));
            }
            Indexer.this.addTypeAttributes(del);
        }

        public void doAction(WasInfluencedBy infl) {
            String uri;
            WasInfluencedBy entry;
            if (infl.getId() == null) {
                Indexer.this.g.setId(infl);
            }
            if ((entry = Indexer.this.wasInfluencedByTable.get(uri = infl.getId().getUri())) == null) {
                Indexer.this.wasInfluencedByTable.put(uri, infl);
            } else {
                Indexer.this.wasInfluencedByTable.put(uri, Indexer.this.resolveDuplicate(infl, entry));
            }
            Indexer.this.addTypeAttributes(infl);
        }

        public void doAction(AlternateOf alt) {
            Indexer.this.alternateOfList.add(alt);
        }

        public void doAction(SpecializationOf spec) {
            Indexer.this.specializationOfList.add(spec);
        }

        public void doAction(QualifiedAlternateOf alt) {
            Indexer.this.alternateOfList.add((AlternateOf)alt);
        }

        public void doAction(QualifiedSpecializationOf spec) {
            Indexer.this.specializationOfList.add((SpecializationOf)spec);
        }

        public void doAction(MentionOf men) {
            String uri = men.getSpecificEntity().getUri();
            MentionOf entry = Indexer.this.mentionOfTable.get(uri);
            if (entry == null) {
                Indexer.this.mentionOfTable.put(uri, men);
            } else {
                Indexer.this.mentionOfTable.put(uri, Indexer.this.resolveDuplicate(men, entry));
            }
        }

        public void doAction(HadMember mem) {
            logger.debug("!!!!!!!!!!!!!!!!!!!!!adding " + String.valueOf(mem));
            Indexer.this.membershipList.add(mem);
        }

        public void doAction(QualifiedHadMember mem) {
            logger.debug("!!!!!!!!!!!!!!!!!!!!!adding " + String.valueOf(mem));
            Indexer.this.membershipList.add((HadMember)mem);
        }

        public void doAction(DictionaryMembership s) {
        }

        public void doAction(DerivedByRemovalFrom s) {
        }

        public void doAction(DerivedByInsertionFrom s) {
        }

        public void doAction(Bundle s, ProvUtilities provUtilities) {
        }
    }
}

