/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.Identifiable;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.model.Type;
import org.openprovenance.prov.model.WasEndedBy;
import org.openprovenance.prov.model.WasStartedBy;
import org.openprovenance.prov.model.exception.InvalidCaseException;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.VarQName;
import org.openprovenance.prov.validation.VarQNameWrapper;
import org.openprovenance.prov.validation.VarTime;

public class Merger {
    static Logger logger = LogManager.getLogger(Merger.class);
    private final ProvUtilities u;
    private final ProvFactory p;
    public final Hashtable<String, List<Statement>> qualifiedNameMismatch;
    private final Indexer indexer;
    Hashtable<VarQNameWrapper, QualifiedName> unificationSubstitution = new Hashtable();
    boolean updated = false;
    Hashtable<VarTime, XMLGregorianCalendar> unificationTimeSubstitution = new Hashtable();

    public Merger(ProvFactory p, ProvUtilities u, Hashtable<String, List<Statement>> qualifiedNameMismatch, Indexer indexer) {
        this.u = u;
        this.p = p;
        this.qualifiedNameMismatch = qualifiedNameMismatch;
        this.indexer = indexer;
    }

    public <T extends Statement> boolean checkSameQualifiedName(QualifiedName fromArgument, QualifiedName toArgument, T from, T to) {
        logger.debug("        checkSameQualifiedName(): QNames are  " + String.valueOf(fromArgument) + " " + String.valueOf(toArgument));
        String uri = toArgument.getUri();
        String uri2 = fromArgument.getUri();
        if (uri.equals(uri2)) {
            if (fromArgument.getLocalPart().equals(toArgument.getLocalPart()) && fromArgument.getNamespaceURI().equals(toArgument.getNamespaceURI()) && fromArgument.getPrefix().equals(toArgument.getPrefix())) {
                return true;
            }
            List<Statement> l = this.qualifiedNameMismatch.get(uri);
            if (l == null) {
                l = new LinkedList<Statement>();
                l.add(to);
                this.qualifiedNameMismatch.put(uri, l);
            }
            l.add(from);
            return false;
        }
        return true;
    }

    QualifiedName getRef(Statement o, int i) {
        return (QualifiedName)this.u.getter(o, i);
    }

    XMLGregorianCalendar getTime(Statement o, int i) {
        return (XMLGregorianCalendar)this.u.getter(o, i);
    }

    public <T extends Statement> T merge(T from, T to) {
        return this.mergeGenericUnwrapped(from, to);
    }

    public static int getFirstTimeIndex(Statement s) {
        StatementOrBundle.Kind kind = s.getKind();
        switch (kind) {
            case PROV_ACTIVITY: {
                return 1;
            }
            case PROV_AGENT: {
                return 1;
            }
            case PROV_ALTERNATE: {
                return 2;
            }
            case PROV_ASSOCIATION: {
                return 4;
            }
            case PROV_ATTRIBUTION: {
                return 3;
            }
            case PROV_BUNDLE: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + String.valueOf(kind));
            }
            case PROV_COMMUNICATION: {
                return 3;
            }
            case PROV_DELEGATION: {
                return 4;
            }
            case PROV_DERIVATION: {
                return 6;
            }
            case PROV_DICTIONARY_INSERTION: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + String.valueOf(kind));
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + String.valueOf(kind));
            }
            case PROV_DICTIONARY_REMOVAL: {
                throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + String.valueOf(kind));
            }
            case PROV_END: {
                return 4;
            }
            case PROV_ENTITY: {
                return 1;
            }
            case PROV_GENERATION: {
                return 3;
            }
            case PROV_INFLUENCE: {
                return 3;
            }
            case PROV_INVALIDATION: {
                return 3;
            }
            case PROV_MEMBERSHIP: {
                return 2;
            }
            case PROV_MENTION: {
                return 3;
            }
            case PROV_SPECIALIZATION: {
                return 2;
            }
            case PROV_START: {
                return 4;
            }
            case PROV_USAGE: {
                return 3;
            }
        }
        throw new InvalidCaseException("ProvUtilities.getFirstTimeIndex() for " + String.valueOf(kind));
    }

    public static int getLastIndex(Statement s) {
        StatementOrBundle.Kind kind = s.getKind();
        switch (kind) {
            case PROV_ACTIVITY: {
                return 3;
            }
            case PROV_AGENT: {
                return 1;
            }
            case PROV_ALTERNATE: {
                return 2;
            }
            case PROV_ASSOCIATION: {
                return 4;
            }
            case PROV_ATTRIBUTION: {
                return 3;
            }
            case PROV_BUNDLE: {
                throw new InvalidCaseException("ProvUtilities.getLastIndex() for " + String.valueOf(kind));
            }
            case PROV_COMMUNICATION: {
                return 3;
            }
            case PROV_DELEGATION: {
                return 4;
            }
            case PROV_DERIVATION: {
                return 6;
            }
            case PROV_DICTIONARY_INSERTION: {
                throw new InvalidCaseException("ProvUtilities.getLastIndex() for " + String.valueOf(kind));
            }
            case PROV_DICTIONARY_MEMBERSHIP: {
                throw new InvalidCaseException("ProvUtilities.getLastIndex() for " + String.valueOf(kind));
            }
            case PROV_DICTIONARY_REMOVAL: {
                throw new InvalidCaseException("ProvUtilities.getLastIndex() for " + String.valueOf(kind));
            }
            case PROV_END: {
                return 5;
            }
            case PROV_ENTITY: {
                return 1;
            }
            case PROV_GENERATION: {
                return 4;
            }
            case PROV_INFLUENCE: {
                return 3;
            }
            case PROV_INVALIDATION: {
                return 4;
            }
            case PROV_MEMBERSHIP: {
                return 2;
            }
            case PROV_MENTION: {
                return 3;
            }
            case PROV_SPECIALIZATION: {
                return 2;
            }
            case PROV_START: {
                return 5;
            }
            case PROV_USAGE: {
                return 4;
            }
        }
        throw new InvalidCaseException("ProvUtilities.getLastIndex() for " + String.valueOf(kind));
    }

    private <T extends Statement> T mergeGenericUnwrapped(T from, T to) {
        int i;
        QualifiedName toId = null;
        QualifiedName fromId = null;
        if (from instanceof Identifiable) {
            toId = (QualifiedName)this.u.getter(to, 0);
            fromId = (QualifiedName)this.u.getter(from, 0);
            logger.debug("     mergeGenericUnwrapped():  " + String.valueOf(fromId) + " " + String.valueOf(toId));
            if (!this.unify(fromId, toId)) {
                logger.debug("$$$$$$$$$$$$$$$$$$$$ mergeGenericUnwrapped failedtoUnify  " + String.valueOf(toId) + " " + String.valueOf(toId));
                return null;
            }
            this.checkSameQualifiedName(fromId, toId, from, to);
        }
        boolean success = true;
        for (i = Merger.getFirstTimeIndex(from); i <= Merger.getLastIndex(from) - 1; ++i) {
            XMLGregorianCalendar fromTime = this.getTime(from, i);
            XMLGregorianCalendar toTime = this.getTime(to, i);
            success = success && this.unify(fromTime, toTime);
        }
        for (i = 1; i < Merger.getFirstTimeIndex(from); ++i) {
            QualifiedName fromArgument = this.getRef(from, i);
            if (fromArgument == null) continue;
            QualifiedName toArgument = this.getRef(to, i);
            if (toArgument == null) {
                throw new NullPointerException("toArgument should never be null");
            }
            if (fromArgument.getUri().equals(toArgument.getUri())) {
                this.checkSameQualifiedName(fromArgument, toArgument, from, to);
                continue;
            }
            if (this.unify(fromArgument, toArgument)) continue;
            logger.debug("$$$$$$$$$$$$$$$$$$$$ mergeGenericUnwrapped failed Unification  ");
            return null;
        }
        if (from instanceof Identifiable) {
            this.mergeTypeAttributes(from, to, toId, fromId);
        }
        if (success) {
            logger.debug("     mergeGenericUnwrapped(): successful merge  " + String.valueOf(this.unificationSubstitution));
            return to;
        }
        return null;
    }

    public boolean unify(XMLGregorianCalendar fromTime, XMLGregorianCalendar toTime) throws NullPointerException {
        boolean success = true;
        if (fromTime == null) {
            throw new NullPointerException("fromArgument should never be null");
        }
        if (toTime == null) {
            throw new NullPointerException("toArgument should never be null");
        }
        if (fromTime instanceof VarTime) {
            VarTime vFromTime = (VarTime)fromTime;
            if (!this.unify(vFromTime, toTime)) {
                logger.debug("$$$$$$$$$$$$$$$$$$$$ mergeGenericUnwrapped failedtoUnify  " + String.valueOf(vFromTime) + " " + String.valueOf(toTime));
                success = false;
            }
        } else if (toTime instanceof VarTime) {
            VarTime vToTime = (VarTime)toTime;
            if (!this.unify(vToTime, fromTime)) {
                logger.debug("$$$$$$$$$$$$$$$$$$$$ mergeGenericUnwrapped failedtoUnify 2 " + String.valueOf(vToTime) + " " + String.valueOf(fromTime));
                success = false;
            }
        } else if (!fromTime.equals(toTime)) {
            logger.debug("$$$$$$$$$$$$$$$$$$$$ mergeGenericUnwrapped incompatible time  ");
            success = false;
        }
        return success;
    }

    private <T extends Statement> void mergeTypeAttributes(T from, T to, QualifiedName toId, QualifiedName fromId) {
        Set<Type> fromTypes;
        logger.debug("        mergeAttributes " + String.valueOf(toId) + " " + String.valueOf(fromId));
        String toUri = toId.getUri();
        String fromUri = fromId.getUri();
        Set<Type> toTypes = this.indexer.getTypeTable(to).get(toUri);
        if (toTypes == null) {
            toTypes = new HashSet<Type>();
            this.indexer.getTypeTable(to).put(toUri, toTypes);
        }
        if ((fromTypes = this.indexer.getTypeTable(from).get(fromUri)) == null) {
            fromTypes = new HashSet<Type>();
            this.indexer.getTypeTable(from).put(fromUri, fromTypes);
        }
        if (!toTypes.equals(fromTypes)) {
            HashSet<Type> toCopy = new HashSet<Type>(toTypes);
            toTypes.addAll(fromTypes);
            fromTypes.addAll(toCopy);
        }
    }

    void unificationSubstitutionPut(VarQName key, QualifiedName val) {
        QualifiedName old = this.unificationSubstitution.put(new VarQNameWrapper(key), val);
        if (old == null || !this.equalQName(old, val)) {
            this.updated = true;
        }
    }

    void unificationSubstitutionPut(VarQNameWrapper key, QualifiedName val) {
        QualifiedName old = this.unificationSubstitution.put(key, val);
        if (old == null || !this.equalQName(old, val)) {
            this.updated = true;
        }
    }

    private void unificationSubstitutionPut(VarTime key, XMLGregorianCalendar val) {
        XMLGregorianCalendar old = this.unificationTimeSubstitution.put(key, val);
        if (old == null || !old.equals(val)) {
            this.updated = true;
        }
    }

    public void updateSubstitutionTable(VarQName id1, QualifiedName id2) {
        for (VarQNameWrapper key : this.unificationSubstitution.keySet()) {
            QualifiedName value = this.unificationSubstitution.get(key);
            if (!this.equalQName(id1, value)) continue;
            this.unificationSubstitutionPut(key, id2);
        }
    }

    private void updateSubstitutionTable(VarTime time1, XMLGregorianCalendar time2) {
        for (VarTime key : this.unificationTimeSubstitution.keySet()) {
            XMLGregorianCalendar value = this.unificationTimeSubstitution.get(key);
            if (!this.equalTime(value, time1)) continue;
            this.unificationSubstitutionPut(key, time2);
        }
    }

    private boolean unify(VarTime time1, XMLGregorianCalendar time2) {
        XMLGregorianCalendar unifiedTime2;
        logger.debug("        unify(): unification for VarTime  " + String.valueOf(time1) + " " + String.valueOf(time2));
        XMLGregorianCalendar entry1 = this.unificationTimeSubstitution.get(time1);
        XMLGregorianCalendar entry2 = time2 instanceof VarTime ? this.unificationTimeSubstitution.get((VarTime)time2) : null;
        XMLGregorianCalendar unifiedTime1 = entry1 == null ? time1 : entry1;
        XMLGregorianCalendar xMLGregorianCalendar = unifiedTime2 = entry2 == null ? time2 : entry2;
        if (this.equalTime(unifiedTime1, unifiedTime2)) {
            logger.debug("        unify()time: SAME " + String.valueOf(unifiedTime1));
            return true;
        }
        if (unifiedTime1 instanceof VarTime) {
            this.unificationSubstitutionPut((VarTime)unifiedTime1, unifiedTime2);
            this.updateSubstitutionTable((VarTime)unifiedTime1, unifiedTime2);
            logger.debug("        unify()time: " + String.valueOf(this.unificationTimeSubstitution));
            return true;
        }
        if (unifiedTime2 instanceof VarTime) {
            this.unificationSubstitutionPut((VarTime)unifiedTime2, unifiedTime1);
            this.updateSubstitutionTable((VarTime)unifiedTime2, unifiedTime1);
            logger.debug("        unify()time: " + String.valueOf(this.unificationTimeSubstitution));
            return true;
        }
        logger.debug("        unify()time: UNIFICATION FAILURE " + String.valueOf(this.unificationTimeSubstitution));
        return false;
    }

    public void sameStartTime(String activityURI, Activity activity, WasStartedBy start) {
        logger.debug("      sameStartTime >>> " + activityURI + " " + String.valueOf(start.getId()));
        boolean flag = this.unify(activity.getStartTime(), start.getTime());
        if (!flag) {
            logger.debug("      failed to unify startTime ");
            this.indexer.addToFailedMerge(activity, (Statement)start, activityURI);
        }
    }

    public void sameEndTime(String activityURI, Activity activity, WasEndedBy end) {
        logger.debug("      sameEndTime >>> " + activityURI + " " + String.valueOf(end.getId()));
        boolean flag = this.unify(activity.getEndTime(), end.getTime());
        if (!flag) {
            logger.debug("      failed to unify endTime ");
            this.indexer.addToFailedMerge(activity, (Statement)end, activityURI);
        }
    }

    boolean equalTime(XMLGregorianCalendar time1, XMLGregorianCalendar time2) {
        if (time1 instanceof VarTime && time2 instanceof VarTime) {
            return time1.equals(time2);
        }
        if (time1 instanceof VarTime || time2 instanceof VarTime) {
            return false;
        }
        return time1.equals(time2);
    }

    boolean equalQName(QualifiedName qn1, QualifiedName qn2) {
        if (qn1 instanceof VarQName && qn2 instanceof VarQName) {
            return ((VarQName)qn1).getUri().equals(((VarQName)qn2).getUri());
        }
        if (qn1 instanceof VarQName || qn2 instanceof VarQName) {
            return false;
        }
        if (qn1.equals((Object)qn2)) {
            return true;
        }
        return qn1.getUri().equals(qn2.getUri());
    }

    private boolean unify(QualifiedName id1, QualifiedName id2) {
        QualifiedName unified_uri2;
        logger.debug("        unify(): unification for QNames  " + String.valueOf(id1) + " " + String.valueOf(id2));
        QualifiedName entry1 = id1 instanceof VarQName ? this.unificationSubstitution.get((VarQName)id1) : null;
        QualifiedName entry2 = id2 instanceof VarQName ? this.unificationSubstitution.get((VarQName)id2) : null;
        QualifiedName unified_uri1 = entry1 == null ? id1 : entry1;
        QualifiedName qualifiedName = unified_uri2 = entry2 == null ? id2 : entry2;
        if (this.indexer.existentialVariable(unified_uri1)) {
            VarQName vqn1 = (VarQName)unified_uri1;
            this.unificationSubstitutionPut(vqn1, unified_uri2);
            this.updateSubstitutionTable(vqn1, unified_uri2);
            logger.debug("        unify(): " + String.valueOf(this.unificationSubstitution));
            return true;
        }
        if (this.indexer.existentialVariable(unified_uri2)) {
            VarQName vqn2 = (VarQName)unified_uri2;
            this.unificationSubstitutionPut(vqn2, unified_uri1);
            this.updateSubstitutionTable(vqn2, unified_uri1);
            logger.debug("        unify(): " + String.valueOf(this.unificationSubstitution));
            return true;
        }
        if (this.equalQName(unified_uri1, unified_uri2)) {
            logger.debug("        unify(): SAME " + String.valueOf(unified_uri1));
            return true;
        }
        logger.debug("        unify(): UNIFICATION FAILURE " + String.valueOf(this.unificationSubstitution));
        return false;
    }

    public QualifiedName substitute(QualifiedName id, Hashtable<VarQNameWrapper, QualifiedName> subst) {
        if (id instanceof VarQName) {
            QualifiedName res = subst.get(new VarQNameWrapper((VarQName)id));
            return res;
        }
        return null;
    }

    public XMLGregorianCalendar substitute(XMLGregorianCalendar id, Hashtable<VarTime, XMLGregorianCalendar> subst) {
        XMLGregorianCalendar res = subst.get(id);
        if (res != null) {
            logger.debug("SUBSTITUTE got " + String.valueOf(res) + ") for " + String.valueOf(id));
            return res;
        }
        return null;
    }

    public <T extends Statement> T applySubstitution(T from, Hashtable<VarQNameWrapper, QualifiedName> table, Hashtable<VarTime, XMLGregorianCalendar> timeTable) {
        try {
            return this.applySubstitutionUnwrapped(from, table, timeTable);
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        logger.debug("!!! applySubstitution PROBLEM:  " + String.valueOf(from));
        throw new UnsupportedOperationException();
    }

    public <T extends Statement> T applySubstitutionUnwrapped(T anEntry, Hashtable<VarQNameWrapper, QualifiedName> table, Hashtable<VarTime, XMLGregorianCalendar> timeTable) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IllegalArgumentException {
        int i;
        QualifiedName anEntryId = (QualifiedName)this.u.getter(anEntry, 0);
        logger.debug("     applySubstitutionUnwrapped():  to " + String.valueOf(anEntryId));
        QualifiedName isNew = this.substitute(anEntryId, table);
        if (isNew != null) {
            this.u.setter(anEntry, 0, (Object)isNew);
        }
        for (i = Merger.getFirstTimeIndex(anEntry); i <= Merger.getLastIndex(anEntry) - 1; ++i) {
            logger.debug("%%%%%% " + String.valueOf(anEntry.getClass()) + " " + i + " " + (Merger.getLastIndex(anEntry) - 1));
            XMLGregorianCalendar anEntryTime = this.getTime(anEntry, i);
            XMLGregorianCalendar isNewTime = this.substitute(anEntryTime, timeTable);
            if (isNewTime != null) {
                this.u.setter(anEntry, i, (Object)isNewTime);
                continue;
            }
            if (anEntryTime != null && !(anEntryTime instanceof VarTime)) continue;
        }
        for (i = 1; i < Merger.getFirstTimeIndex(anEntry); ++i) {
            QualifiedName anEntryId2;
            QualifiedName isNew2;
            QualifiedName anEntryArgument = this.getRef(anEntry, i);
            if (anEntryArgument == null || (isNew2 = this.substitute(anEntryId2 = anEntryArgument, table)) == null) continue;
            this.u.setter(anEntry, i, (Object)isNew2);
        }
        return anEntry;
    }
}

