/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.Entity;
import org.openprovenance.prov.model.Name;
import org.openprovenance.prov.model.Namespace;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvUtilities;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.SpecializationOf;
import org.openprovenance.prov.model.Statement;
import org.openprovenance.prov.validation.Cleanup;
import org.openprovenance.prov.validation.Config;
import org.openprovenance.prov.validation.Constraints;
import org.openprovenance.prov.validation.EventIndexer;
import org.openprovenance.prov.validation.Expansion;
import org.openprovenance.prov.validation.Gensym;
import org.openprovenance.prov.validation.Indexer;
import org.openprovenance.prov.validation.Inference;
import org.openprovenance.prov.validation.Pair;
import org.openprovenance.prov.validation.Types;
import org.openprovenance.prov.validation.Unification;
import org.openprovenance.prov.validation.Uniqueness;
import org.openprovenance.prov.validation.matrix.SparseMatrix;
import org.openprovenance.prov.validation.report.Dependencies;
import org.openprovenance.prov.validation.report.MalformedStatements;
import org.openprovenance.prov.validation.report.MergeReport;
import org.openprovenance.prov.validation.report.SpecializationReport;
import org.openprovenance.prov.validation.report.TypeOverlap;
import org.openprovenance.prov.validation.report.ValidationReport;

public class Validate {
    static Logger logger = LogManager.getLogger(Validate.class);
    private static String fileName = "config.properties";
    public static final String validatorVersion = Validate.getPropertiesFromClasspath(fileName).getProperty("validator.version");
    public static final String longValidatorVersion = validatorVersion + " (" + Validate.getPropertiesFromClasspath(fileName).getProperty("timestamp") + ")";
    public static final String longVersion = "Validator " + longValidatorVersion + ", ProvToolbox " + Configuration.longToolboxVersion;
    ProvUtilities u = new ProvUtilities();
    final Config config;
    public final Indexer ind;
    final Expansion expa;
    public final Uniqueness uniq;
    final Unification unif;
    final Inference inf;
    public final EventIndexer evtIdx;
    public final Types typeChecker;
    public Constraints constraints;
    final ProvFactory p;
    final Name name;
    final Gensym g;

    private static Properties getPropertiesFromClasspath(String propFileName) {
        return Configuration.getPropertiesFromClasspath(Validate.class, (String)propFileName);
    }

    public Validate(Config config) {
        this(config, false);
    }

    public Validate(Config config, boolean staticGensym) {
        this.config = config;
        this.ind = new Indexer(config.p, config.om, staticGensym);
        this.p = this.ind.p;
        this.name = this.p.getName();
        this.g = this.ind.g;
        this.typeChecker = new Types(this.ind, this.u, config);
        this.expa = new Expansion(this.ind, config, this.typeChecker);
        this.uniq = new Uniqueness(this.ind);
        this.unif = new Unification(this.ind, this.uniq);
        this.inf = new Inference(this.ind, this.typeChecker);
        this.evtIdx = new EventIndexer(this.ind);
    }

    public Indexer getIndexer() {
        return this.ind;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public EventIndexer getEventIndexer() {
        return this.evtIdx;
    }

    public Inference getInference() {
        return this.inf;
    }

    public ValidationReport validate(Document inDocument) throws IOException {
        Pair<ValidationReport, Document> result = this.validate(this.u.getStatement(inDocument), true, inDocument.getNamespace());
        ValidationReport report = (ValidationReport)result.car;
        Document outDocument = (Document)result.cdr;
        for (Bundle bu : this.u.getNamedBundle(inDocument)) {
            List statments = bu.getStatement();
            Validate validator = new Validate(this.config);
            Pair<ValidationReport, Document> buRes = validator.validate(statments, false, bu.getNamespace());
            ValidationReport buRep = (ValidationReport)buRes.car;
            QualifiedName id = bu.getId();
            org.openprovenance.prov.vanilla.QualifiedName qnId = new org.openprovenance.prov.vanilla.QualifiedName(id.getNamespaceURI(), id.getLocalPart(), id.getPrefix());
            buRep.setId(qnId);
            report.getValidationReport().add(buRep);
            Bundle bundle = (Bundle)this.u.getNamedBundle((Document)buRes.cdr).get(0);
            List ll = outDocument.getStatementOrBundle();
            ll.add(bundle);
            Entity e = this.p.newEntity(bundle.getId());
            e.getType().add(this.p.newType((Object)this.name.PROV_BUNDLE, this.name.PROV_QUALIFIED_NAME));
            ll.add(e);
            ll.add(this.p.newWasDerivedFrom((QualifiedName)null, bundle.getId(), bu.getId()));
            bundle.getNamespace().setParent(outDocument.getNamespace());
        }
        Namespace.withThreadNamespace((Namespace)outDocument.getNamespace());
        new Cleanup(this.u).cleanup(this.config, this.u.getStatement(outDocument), this.u.getNamedBundle(outDocument));
        return report;
    }

    public Pair<ValidationReport, Document> validate(List<Statement> statements, boolean isDocument, Namespace namespace) throws IOException {
        logger.debug("Expanding terms");
        this.expa.expansion(this.config, statements);
        logger.debug("Indexing bundle");
        this.ind.index(statements);
        logger.debug("... Indexing complete");
        logger.debug("Applying uniqueness constraints");
        this.ind.merger.updated = true;
        int iteration = 0;
        while (this.ind.merger.updated) {
            logger.debug("Applying uniqueness constraints: iteration " + iteration++);
            this.ind.merger.updated = false;
            this.unif.applyUnification();
            this.uniq.uniqueAll(this.config);
        }
        logger.debug("Substitution is " + String.valueOf(this.ind.merger.unificationSubstitution));
        logger.debug("Unique startTable is " + String.valueOf(this.uniq.wasStartedByTable));
        this.unif.removeUnifiedEntries();
        this.unif.applyUnification();
        this.typeChecker.addDeclaredTypes();
        this.inf.inferIntervalBeginningAndEnds(this.config);
        this.inf.computeSpecializationClosure(this.config);
        this.inf.computeAlternateClosure(this.config);
        this.inf.specializationAttributesInference(this.config);
        logger.debug("spec table " + String.valueOf(this.inf.specializationTable));
        this.inf.specializationIsNotReflexive(this.config);
        logger.debug("Save normal form");
        Document doc = this.completeDocument();
        logger.debug("Event index");
        this.evtIdx.createEventIndex();
        logger.debug("... event index complete");
        logger.debug("Constraints");
        logger.debug("constraint checking");
        this.constraints = new Constraints(this.typeChecker, this.ind, this.inf, this.evtIdx);
        this.constraints.constraints(this.config);
        logger.debug("... constraint checking complete");
        logger.debug("maximum is        " + this.constraints.getMatrix().getMaximum());
        List<Object> diagonal = this.constraints.getMatrix().diagonal();
        logger.debug("matrix diagonal is:");
        int i = 0;
        for (Object d : diagonal) {
            if (d != null) {
                logger.debug("m(" + i + "," + i + ")=" + String.valueOf(d));
            }
            ++i;
        }
        ValidationReport report = this.getReport();
        report.setNamespace(namespace);
        return new Pair<ValidationReport, Document>(report, doc);
    }

    public ValidationReport getReport() {
        MergeReport mr;
        List<Object> diagonal = this.constraints.getMatrix().diagonal();
        ValidationReport report = new ValidationReport();
        int i = 0;
        for (Object object : diagonal) {
            Integer d;
            if (object != null && (d = (Integer)object) > 0) {
                List<Integer> path = this.constraints.getMatrix().getPath(i, i);
                logger.debug(" path: " + String.valueOf(path) + " with " + d);
                if (SparseMatrix.isNonStrictOrdering(d)) {
                    report.getNonStrictCycle().add(this.getCyclicEvents(path));
                } else {
                    report.getCycle().add(this.getCyclicEvents(path));
                }
            }
            ++i;
        }
        for (String string : this.ind.successfulMerge.keySet()) {
            mr = new MergeReport();
            mr.setKey(string);
            mr.getStatement().addAll((Collection<Statement>)this.ind.successfulMerge.get(string));
            report.getSuccessfulMerge().add(mr);
        }
        for (String string : this.ind.failedMerge.keySet()) {
            mr = new MergeReport();
            mr.setKey(string);
            mr.getStatement().addAll((Collection<Statement>)this.ind.failedMerge.get(string));
            report.getFailedMerge().add(mr);
        }
        for (String string : this.ind.qualifiedNameMismatch.keySet()) {
            mr = new MergeReport();
            mr.setKey(string);
            mr.getStatement().addAll((Collection<Statement>)this.ind.qualifiedNameMismatch.get(string));
            report.getQualifiedNameMismatch().add(mr);
        }
        if (this.inf.failedSpecialization != null && !this.inf.failedSpecialization.isEmpty()) {
            SpecializationReport sr = new SpecializationReport();
            report.setSpecializationReport(sr);
            for (SpecializationOf fs : this.inf.failedSpecialization) {
                sr.getSpecializationOf().add(this.p.newSpecializationOf(fs));
            }
        }
        for (String string : this.constraints.typeOverlapTable.keySet()) {
            Collection<String> conflicts;
            Collection<String> inferredTypes = this.constraints.typeOverlapTable.get(string);
            if (inferredTypes == null || inferredTypes.isEmpty() || (conflicts = this.typeChecker.conflictingTypes(inferredTypes)) == null || conflicts.isEmpty()) continue;
            TypeOverlap to = new TypeOverlap();
            report.getTypeOverlap().add(to);
            to.getType().addAll(conflicts);
            to.setKey(string);
        }
        List<Statement> malformed = this.expa.getMalformed().getStatement();
        if (!malformed.isEmpty()) {
            MalformedStatements malformedStatements = new MalformedStatements();
            report.setMalformedStatements(malformedStatements);
            malformedStatements.getStatement().addAll(malformed);
        }
        return report;
    }

    public Dependencies getCyclicEvents(List<Integer> l) {
        Dependencies dep = new Dependencies();
        for (int i : l) {
            Statement mutableStatement = this.evtIdx.eventTable.get(this.evtIdx.events.get(i));
            dep.getStatement().add(mutableStatement);
        }
        return dep;
    }

    public Document completeDocument() {
        Set<QualifiedName> set;
        Bundle nbundle = this.p.newNamedBundle((QualifiedName)null, this.ind.activityTable.values(), this.ind.entityTable.values(), this.ind.agentTable.values(), new LinkedList());
        nbundle.setId((QualifiedName)this.g.newId(nbundle));
        List dependencies = nbundle.getStatement();
        dependencies.addAll(this.ind.usedTable.values());
        dependencies.addAll(this.ind.wasGeneratedByTable.values());
        dependencies.addAll(this.ind.wasInvalidatedByTable.values());
        dependencies.addAll(this.ind.wasStartedByTable.values());
        dependencies.addAll(this.ind.wasEndedByTable.values());
        dependencies.addAll(this.ind.wasDerivedFromTable.values());
        dependencies.addAll(this.ind.wasInformedByTable.values());
        dependencies.addAll(this.ind.wasAssociatedWithTable.values());
        dependencies.addAll(this.ind.wasAttributedToTable.values());
        dependencies.addAll(this.ind.actedOnBehalfOfTable.values());
        dependencies.addAll(this.ind.wasInfluencedByTable.values());
        for (QualifiedName e1 : this.inf.specializationTable.keySet()) {
            set = this.inf.specializationTable.get(e1);
            for (QualifiedName e2 : set) {
                dependencies.add(this.p.newSpecializationOf(e1, e2));
            }
        }
        for (QualifiedName e1 : this.inf.alternateTable.keySet()) {
            set = this.inf.alternateTable.get(e1);
            for (QualifiedName e2 : set) {
                dependencies.add(this.p.newAlternateOf(e1, e2));
            }
        }
        dependencies.addAll(this.ind.membershipList);
        dependencies.addAll(this.ind.mentionOfTable.values());
        Document doc = this.p.newDocument();
        doc.getStatementOrBundle().add(nbundle);
        Namespace ns = Namespace.gatherNamespaces((Bundle)nbundle);
        nbundle.setNamespace(ns);
        doc.setNamespace(ns);
        return doc;
    }
}

