/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.core.roundtrip;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openprovenance.prov.core.RoundTripFromJavaJSONLD11Test;
import org.openprovenance.prov.core.jsonld11.serialization.ProvSerialiser;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.HasType;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.RoundTripFromJavaTest;
import org.openprovenance.prov.rdf.Ontology;
import org.openprovenance.prov.rdf.Utility;
import org.openrdf.rio.RDFFormat;

public class RoundTripFromJavaJSONLD11LegacyTest
extends RoundTripFromJavaJSONLD11Test {
    String theExtension = "_b.jsonld11";

    public RoundTripFromJavaJSONLD11LegacyTest(String testName) {
        super(testName);
    }

    public Document readDocumentFromFile(String file) throws IOException {
        String ttl = this.turtleFile(file);
        System.out.println("reading from " + ttl);
        Ontology onto = new Ontology(RoundTripFromJavaTest.pFactory);
        Utility rdfU = new Utility(RoundTripFromJavaTest.pFactory, onto);
        Document doc = rdfU.parseRDF((InputStream)new FileInputStream(ttl), RDFFormat.NTRIPLES, "file://" + file);
        BeanTraversal bc = new BeanTraversal((ModelConstructor)RoundTripFromJavaTest.pFactory, RoundTripFromJavaTest.pFactory);
        Document doc2 = bc.doAction(doc);
        return doc2;
    }

    public String turtleFile(String file) {
        return file.replace(".jsonld11", ".ttl");
    }

    public void writeDocumentToFile(Document doc, String file) throws IOException {
        System.out.println("writing to " + file);
        ProvSerialiser serial = new ProvSerialiser();
        serial.serialiseDocument((OutputStream)new FileOutputStream(file), doc, true);
        String command = "jsonld --format=ntriples -o " + this.turtleFile(file) + " " + file;
        this.executeAndWait(command);
    }

    public String extension() {
        return this.theExtension;
    }

    public void addTypes(HasType ht) {
        ht.getType().add(RoundTripFromJavaTest.pFactory.newType((Object)RoundTripFromJavaTest.pFactory.newQualifiedName("http://example.org/", "abc", "ex"), RoundTripFromJavaTest.name.PROV_QUALIFIED_NAME));
    }

    public void testDerivation11() {
    }

    public void testDerivation12() {
    }

    public void testDerivation13() {
    }

    public void testMembership1() {
    }

    public void testMembership2() {
    }

    public void testMembership3() {
    }

    public void testSpecialization1() {
    }

    public void testAlternate1() {
    }

    public void testEntity3() {
    }

    public void testBundle1() {
        System.out.println(" ========== TEST missing testBundle1 ()");
    }

    public void testBundle2() {
        System.out.println(" ========== TEST missing testBundle1 ()");
    }

    public void testBundle3() {
        System.out.println(" ========== TEST missing testBundle1 ()");
    }

    public void testBundle4() {
        System.out.println(" ========== TEST missing testBundle1 ()");
    }

    public void testQualifiedSpecializationOf1() {
    }

    public void testQualifiedSpecializationOf2() {
    }

    public void testQualifiedHadMember1() {
    }

    public void testQualifiedHadMember2() {
    }

    public void testQualifiedAlternateOf1() {
    }

    public void testQualifiedAlternateOf2() {
    }
}

