/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.vanilla.Document;
import org.openprovenance.prov.vanilla.ProvFactory;

@Provider
public class DocumentMessageBodyReader
implements MessageBodyReader<Document> {
    final org.openprovenance.prov.model.ProvFactory pf = ProvFactory.getFactory();

    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        InteropFramework intF = new InteropFramework(this.pf);
        Formats.ProvFormat format = (Formats.ProvFormat)intF.mimeTypeRevMap.get(this.trimCharSet(mediaType));
        return format != null;
    }

    public Document readFrom(Class<Document> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream is) throws IOException, WebApplicationException {
        InteropFramework intF = new InteropFramework(this.pf);
        Formats.ProvFormat format = (Formats.ProvFormat)intF.mimeTypeRevMap.get(this.trimCharSet(mediaType));
        InteropFramework interop = new InteropFramework((org.openprovenance.prov.model.ProvFactory)ProvFactory.getFactory());
        Document doc = (Document)interop.deserialiseDocument(is, format);
        return doc;
    }
}

