/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import io.swagger.v3.jaxrs2.integration.resources.AcceptHeaderOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.plugins.interceptors.CorsFilter;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.ProvSerialiser;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.summary.Level0MessageBodyWriter;
import org.openprovenance.prov.service.summary.ScalaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.summary.StorageConfiguration;
import org.openprovenance.prov.service.summary.SummaryService;
import org.openprovenance.prov.service.translation.TranslationService;

@ApplicationPath(value="/provapi")
public class SummariseApplication
extends Application {
    private final Set<Object> singletons = new HashSet();
    StorageConfiguration sc = new StorageConfiguration();

    public SummariseApplication() {
        ProvFactory factory = InteropFramework.getDefaultFactory();
        ServiceUtilsConfig config = this.sc.makeConfig(factory);
        PostService ps = new PostService(config);
        this.singletons.add(ps);
        this.singletons.add(new TranslationService(ps));
        this.singletons.add(new SummaryService(ps));
        this.singletons.add(new VanillaDocumentMessageBodyWriter((ProvSerialiser)new InteropFramework(factory)));
        this.singletons.add(new ScalaDocumentMessageBodyWriter());
        this.singletons.add(new Level0MessageBodyWriter());
        this.singletons.add(new OpenApiResource());
        this.singletons.add(new AcceptHeaderOpenApiResource());
        this.singletons.add(new JacksonJsonProvider());
        CorsFilter corsFilter = new CorsFilter();
        corsFilter.getAllowedOrigins().add("*");
        corsFilter.setAllowedMethods("OPTIONS, GET, POST, DELETE, PUT, PATCH");
        this.singletons.add(corsFilter);
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

