/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary.summary;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.openprovenance.prov.interop.Formats;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.core.DocumentMessageBodyReader;
import org.openprovenance.prov.service.core.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.summary.MapMessageBodyReader;
import org.openprovenance.prov.vanilla.ProvFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class SummarizeIT
extends TestCase {
    static Logger logger = LogManager.getLogger(SummarizeIT.class);
    static final ClientConfig config = new ClientConfig(SummarizeIT.class);
    private final VanillaDocumentMessageBodyWriter bodyWriter = new VanillaDocumentMessageBodyWriter((ProvDocumentWriter)new InteropFramework((org.openprovenance.prov.model.ProvFactory)new ProvFactory()));
    public static HashMap<String, String> table = new HashMap();

    public Client getClient() {
        Client client = ClientBuilder.newBuilder().build();
        client.register((Object)this.bodyWriter);
        client.register(DocumentMessageBodyReader.class);
        client.register(MapMessageBodyReader.class);
        return client;
    }

    public void testTemplateAction1() throws IOException {
        this.testAction("src/test/resources/test-explain/128350251.provn", "src/test/resources/test-summary/empty.json");
    }

    public void testAction(String file, String summaryConfigFile) throws IOException {
        logger.debug("/////////////////////////////////// testAction");
        logger.debug("*** action 1");
        String location = this.doPostStatements_upload(SummarizeIT.config.formURL, file);
        SummarizeIT.assertNotNull((String)"location", (Object)location);
        table.put("location", location);
        logger.info("*** location = " + location);
        Document response = this.readDocument(location + ".jsonld");
        SummarizeIT.assertNotNull((String)"response", (Object)response);
        String location2 = this.doPostStatements_summary(location + "/summary", summaryConfigFile);
        SummarizeIT.assertNotNull((String)"location2", (Object)location2);
        table.put("location2", location2);
        logger.info("*** location2 = " + location2);
        Document summary = this.readDocument(location2 + ".provn");
        SummarizeIT.assertNotNull((Object)summary);
        Map config = this.readAsJson(location2 + "/config", "application/json");
        SummarizeIT.assertNotNull((Object)config);
        logger.info((Object)config);
    }

    public String readAsString(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        String o = (String)response2.readEntity(String.class);
        client.close();
        return o;
    }

    public Map readAsJson(String location, String media) {
        Client client = this.getClient();
        WebTarget target = client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        Map o = (Map)response2.readEntity(Map.class);
        client.close();
        return o;
    }

    public String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public String doPostStatements_upload(String url, String file) {
        InteropFramework intF = new InteropFramework();
        Document doc = intF.readDocumentFromFile(file);
        SummarizeIT.assertNotNull((String)(" document (" + file + ") is not null"), (Object)doc);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        intF.writeDocument((OutputStream)baos, doc, Formats.ProvFormat.PROVN);
        String s = baos.toString();
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(url);
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        output.addFormData("statements", (Object)s, MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("type", (Object)"provn", MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("upload", (Object)"upload", MediaType.TEXT_PLAIN_TYPE);
        logger.debug("Form is " + output);
        Response response = target.request().post(Entity.entity((Object)output, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        String location = response.getHeaderString("Location");
        client.close();
        return location;
    }

    public String doPostStatements_summary(String url, String file) {
        String str;
        try {
            str = this.readFile(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            str = null;
        }
        Client client = this.getClient();
        WebTarget target = client.target(url);
        String summaryConfig = "{\"level\": \"2\", \"level0\": " + str + "}";
        System.out.println(summaryConfig);
        Response response = target.request().post(Entity.entity((Object)summaryConfig, (String)"application/json"));
        String location = response.getHeaderString("Location");
        client.close();
        return location;
    }

    public String doPostStatements_upload(String url, String template, String file) {
        String str;
        InteropFramework intF = new InteropFramework();
        try {
            str = this.readFile(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            str = null;
        }
        SummarizeIT.assertNotNull((String)(" string (" + file + ") is not null"), (Object)str);
        Client client = this.getClient();
        WebTarget target = client.target(url);
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        output.addFormData("url", (Object)template, MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("statements", (Object)str, MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("type", (Object)"provn", MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("expand", (Object)"provn", MediaType.TEXT_PLAIN_TYPE);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)output, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        String location = response.getHeaderString("Location");
        System.out.println("*** write " + location);
        client.close();
        return location;
    }

    public Document readDocument(String location) {
        Client client = this.getClient();
        WebTarget target = client.target(location);
        Response response2 = target.request().get();
        Document doc = (Document)response2.readEntity(org.openprovenance.prov.vanilla.Document.class);
        return doc;
    }

    public Response getResource(String location, String media) {
        Client client = this.getClient();
        WebTarget target = client.target(location);
        Response response2 = media == null ? target.request().get() : target.request(new String[]{media}).get();
        client.close();
        return response2;
    }
}

