/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.summary;

import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import io.swagger.v3.jaxrs2.integration.resources.AcceptHeaderOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.plugins.interceptors.CorsFilter;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.config.StorageConfiguration;
import org.openprovenance.prov.service.core.writers.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.summary.SummaryService;
import org.openprovenance.prov.service.summary.writers.Level0MessageBodyWriter;
import org.openprovenance.prov.service.summary.writers.ScalaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.translation.TranslationService;
import org.openprovenance.prov.service.translation.storage.StorageSetup;

@ApplicationPath(value="/provapi")
public class SummariseApplication
extends Application {
    private final Set<Object> singletons = new HashSet();

    public SummariseApplication() {
        InteropFramework intF = new InteropFramework();
        ProvFactory factory = InteropFramework.getDefaultFactory();
        StorageSetup storageSetup = new StorageSetup();
        StorageConfiguration sc = StorageConfiguration.loadConfiguration();
        ServiceUtilsConfig config = storageSetup.makeConfig(factory, sc);
        System.out.println("Configuration --- " + String.valueOf(sc));
        PostService ps = new PostService(config);
        ps.addToConfiguration("storage.config", (Object)config.configuration);
        ps.addToConfiguration("cli.config", (Object)intF.getConfig());
        ps.addToConfiguration("version", (Object)Configuration.toolboxVersion);
        ps.addToConfiguration("long.version", (Object)Configuration.longToolboxVersion);
        this.singletons.add(ps);
        this.singletons.add(new TranslationService(ps));
        this.singletons.add(new SummaryService(ps));
        this.singletons.add(new VanillaDocumentMessageBodyWriter((ProvDocumentWriter)new InteropFramework(factory)));
        this.singletons.add(new ScalaDocumentMessageBodyWriter());
        this.singletons.add(new Level0MessageBodyWriter());
        this.singletons.add(new OpenApiResource());
        this.singletons.add(new AcceptHeaderOpenApiResource());
        this.singletons.add(new JacksonJsonProvider());
        CorsFilter corsFilter = new CorsFilter();
        corsFilter.getAllowedOrigins().add("*");
        corsFilter.setAllowedMethods("OPTIONS, GET, POST, DELETE, PUT, PATCH");
        this.singletons.add(corsFilter);
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

