/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.IndexedDocument;
import org.openprovenance.prov.service.Querier;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.TemplateService;
import org.openprovenance.prov.service.TemplatesToDot;
import org.openprovenance.prov.service.readers.SearchConfig;
import org.openprovenance.prov.service.readers.TableKey;
import org.openprovenance.prov.service.readers.TableKeyList;
import org.openprovenance.prov.template.compiler.CompilerSQL;
import org.openprovenance.prov.template.compiler.sql.QueryBuilder;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.vanilla.ProvFactory;

public class TemplateQuery {
    private static final Logger logger = LogManager.getLogger(TemplateQuery.class);
    public static final String PARAM_ID = "__param_id";
    public static final String PARAM_PROPERTY = "__param_property";
    public static final String PARAM_TEMPLATE = "__param_template";
    public static final String IN_TEMPLATE = "in_template";
    public static final String IN_PROPERTY = "in_property";
    public static final String IN_ID = "in_id";
    public static final String OUT_ID = "out_id";
    public static final String OUT_TEMPLATE = "out_template";
    public static final String OUT_PROPERTY = "out_property";
    public static final String[] COMPOSITE_LINKER_COLUMNS = new String[]{"composite", "simple"};
    private final Querier querier;
    private final ProvFactory pf = new ProvFactory();
    private final TemplateDispatcher templateDispatcher;
    private final Map<String, TemplateService.Linker> compositeLinker;
    private final ObjectMapper om;
    private final Map<String, Map<String, Map<String, String>>> ioMap;
    private final Map<String, FileBuilder> documentBuilderDispatcher;
    static TypeReference<Map<String, Map<String, Map<String, String>>>> typeRef = new /* Unavailable Anonymous Inner Class!! */;
    String recursiveQuery = "CREATE OR REPLACE FUNCTION backwardtraversal_star(\n    __param_id integer, \n    __param_template text, \n    __param_property text\n) RETURNS TABLE(\n    in_id integer, \n    in_template text, \n    in_property text, \n    out_id integer, \n    out_template text, \n    out_property text\n)\nAS $$\nWITH RECURSIVE recurse_traverse AS (\n    -- Initial query from backwardTraversal function with an additional column for recursion depth\n    SELECT in_id, in_template, in_property, out_id, out_template, out_property, 1 AS depth\n    FROM backwardTraversal(__param_id, __param_template, __param_property)\n\n    UNION \n\n\t-- Recursive step using the output of backwardTraversal called on new parameters obtained from predecessor_table\n    SELECT bt.in_id, bt.in_template, bt.in_property, bt.out_id, bt.out_template, bt.out_property, rt.depth + 1 AS depth\n    FROM recurse_traverse rt\n    JOIN predecessor_table pt ON rt.out_template = pt.template AND rt.out_property = pt.output\n    CROSS JOIN LATERAL backwardTraversal(rt.out_id, rt.out_template, pt.input) AS bt\n    WHERE pt.input IS NOT NULL AND rt.depth < 100 -- Ensuring pt.input is not null and limiting recursion depth\n\n)\nSELECT in_id, in_template, in_property, out_id, out_template, out_property\nFROM recurse_traverse\n$$ LANGUAGE SQL;";
    String recursiveQuery2 = "CREATE OR REPLACE FUNCTION backwardtraversal_star(\n    __param_id integer, \n    __param_template text, \n    __param_property text\n) RETURNS TABLE(\n    in_id integer, \n    in_template text, \n    in_property text, \n    out_id integer, \n    out_template text, \n    out_property text\n)\nAS $$\nWITH RECURSIVE recurse_traverse AS (\n    -- Initial query from backwardTraversal function with an additional column for recursion depth\n\t\n    SELECT \n        bt.in_id, \n        bt.in_template, \n        bt.in_property, \n        bt.out_id, \n        bt.out_template, \n        bt.out_property, \n        1 AS depth\n    FROM \n        predecessor_table as pt \n        CROSS JOIN LATERAL backwardTraversal(__param_id, __param_template, pt.input) AS bt\n    WHERE \n        pt.template = __param_template \n        AND pt.output = __param_property\n\t\n    UNION \n\n\t-- Recursive step using the output of backwardTraversal called on new parameters obtained from predecessor_table\n    SELECT bt.in_id, bt.in_template, bt.in_property, bt.out_id, bt.out_template, bt.out_property, rt.depth + 1 AS depth\n    FROM recurse_traverse rt\n    JOIN predecessor_table pt ON rt.out_template = pt.template AND rt.out_property = pt.output\n    CROSS JOIN LATERAL backwardTraversal(rt.out_id, rt.out_template, pt.input) AS bt\n    WHERE pt.input IS NOT NULL AND rt.depth < 100 -- Ensuring pt.input is not null and limiting recursion depth\n\n)\nSELECT in_id, in_template, in_property, out_id, out_template, out_property\nFROM recurse_traverse\n$$ LANGUAGE SQL;";

    public TemplateQuery(Querier querier, TemplateDispatcher templateDispatcher, Map<String, TemplateService.Linker> compositeLinker, ObjectMapper om, Map<String, FileBuilder> documentBuilderDispatcher, String ioMapString) {
        this.querier = querier;
        this.templateDispatcher = templateDispatcher;
        this.compositeLinker = compositeLinker;
        this.om = om;
        this.documentBuilderDispatcher = documentBuilderDispatcher;
        this.ioMap = this.getIoMap(ioMapString);
        logger.info("ioMap = " + String.valueOf(this.ioMap));
        this.generateTraversalMethods(querier, this.ioMap);
    }

    private void generateTraversalMethods(Querier querier, Map<String, Map<String, Map<String, String>>> ioMap) {
        querier.do_statements(null, null, (sb, data) -> {
            sb.append(this.generateBackwardTemplateTraversal(ioMap));
            sb.append(this.recursiveQuery2);
        });
    }

    public void generateViz(Integer id, String template, String property, Map<String, Map<String, String>> baseTypes, OutputStream out) {
        logger.info("generateViz " + id + " " + template + " " + property);
        List templateConnections = this.recursiveTraversal(id, template, property);
        Collections.reverse(templateConnections);
        new TemplatesToDot(templateConnections, baseTypes, this.ioMap, this.templateDispatcher, (org.openprovenance.prov.model.ProvFactory)this.pf).convert(null, out, "template_connections");
    }

    public List<TemplateConnection> recursiveTraversal(Integer id, String template, String property) {
        LinkedList<TemplateConnection> the_records = new LinkedList<TemplateConnection>();
        this.querier.do_query(the_records, null, (sb, data) -> {
            sb.append("SELECT * FROM ");
            sb.append("backwardtraversal_star(");
            sb.append(id);
            sb.append(",'");
            sb.append(template);
            sb.append("','");
            sb.append(property);
            sb.append("')");
        }, (rs, data) -> {
            while (rs.next()) {
                TemplateConnection record = new TemplateConnection();
                record.in_id = rs.getObject(IN_ID, Integer.class);
                record.in_template = rs.getObject(IN_TEMPLATE, String.class);
                record.in_property = rs.getObject(IN_PROPERTY, String.class);
                record.out_id = rs.getObject(OUT_ID, Integer.class);
                record.out_template = rs.getObject(OUT_TEMPLATE, String.class);
                record.out_property = rs.getObject(OUT_PROPERTY, String.class);
                data.add(record);
            }
        });
        return the_records;
    }

    public Document constructDocument(Map<String, FileBuilder> documentBuilderDispatcher, List<Object[]> the_records) {
        IndexedDocument iDoc = new IndexedDocument((org.openprovenance.prov.model.ProvFactory)this.pf, this.pf.newDocument());
        for (Object[] record : the_records) {
            FileBuilder builder = documentBuilderDispatcher.get((String)record[0]);
            if (builder != null) {
                Document doc = builder.make(record);
                iDoc.merge(doc);
                continue;
            }
            throw new UnsupportedOperationException("unknown record " + String.valueOf(record[0]) + " " + String.valueOf(Arrays.asList(record)));
        }
        return iDoc.toDocument();
    }

    public List<Object[]> query(String template, Integer id, boolean withTitles) {
        if (this.isComposite(template)) {
            return this.queryComposite(template, id, withTitles);
        }
        return this.querySimple(template, id, withTitles);
    }

    private boolean isComposite(String template) {
        return this.compositeLinker.containsKey(template);
    }

    public List<Object[]> querySimple(String template, Integer id, boolean withTitles) {
        LinkedList<Object[]> the_records = new LinkedList<Object[]>();
        String[] propertyOrder = (String[])this.templateDispatcher.getPropertyOrder().get(template);
        this.querier.do_query(the_records, null, (sb, data) -> {
            sb.append("SELECT * FROM ");
            sb.append(template);
            sb.append(" WHERE id=");
            sb.append(id);
        }, (rs, data) -> {
            while (rs.next()) {
                Object[] record = new Object[propertyOrder.length];
                record[0] = template;
                for (int i = 1; i < record.length; ++i) {
                    String columnLabel = CompilerSQL.sqlify((String)propertyOrder[i]);
                    Object o = rs.getObject(columnLabel);
                    if (o instanceof Timestamp) {
                        o = ((Timestamp)o).toInstant().toString();
                    }
                    record[i] = o;
                }
                data.add(record);
            }
        });
        return the_records;
    }

    public List<RecordEntry2> queryTemplatesRecords(SearchConfig config) {
        String base_relation = config.base_relation;
        Object from_date = config.from_date;
        Object to_date = config.to_date;
        Integer limit = config.limit;
        if (from_date != null) {
            from_date = "'" + (String)from_date + "'";
        }
        if (to_date != null) {
            to_date = "'" + (String)to_date + "'";
        }
        return this.queryTemplatesRecords(base_relation, (String)from_date, (String)to_date, limit);
    }

    private List<RecordEntry2> queryTemplatesRecords(String base_relation, String from_date, String to_date, Integer limit) {
        LinkedList<RecordEntry2> linked_records = new LinkedList<RecordEntry2>();
        this.querier.do_query(linked_records, null, (sb, data) -> {
            sb.append("SELECT * FROM ");
            sb.append("search_records_for_" + base_relation + "(").append(from_date).append(",").append(to_date).append(") ");
            sb.append("limit ").append(limit);
            System.out.println("sb = " + sb.toString());
        }, (rs, data) -> {
            while (rs.next()) {
                RecordEntry2 record = new RecordEntry2();
                record.key = rs.getObject("key", Integer.class);
                record.created_at = rs.getObject("created_at", Timestamp.class).toInstant().toString();
                record.base_relation = base_relation;
                record.table_name = rs.getObject("table_name", String.class);
                record.id = rs.getObject("ID", Integer.class);
                data.add(record);
            }
        });
        return linked_records;
    }

    public List<RecordEntry2> queryTemplatesRecordsById(String base_relation, Integer id, Integer limit) {
        LinkedList<RecordEntry2> linked_records = new LinkedList<RecordEntry2>();
        this.querier.do_query(linked_records, null, (sb, data) -> {
            sb.append("SELECT * FROM ");
            sb.append("search_records_by_id_for_" + base_relation + "(" + id + ") ");
            sb.append("limit ").append(limit);
            System.out.println("sb = " + sb.toString());
        }, (rs, data) -> {
            while (rs.next()) {
                RecordEntry2 record = new RecordEntry2();
                record.key = rs.getObject("key", Integer.class);
                record.created_at = rs.getObject("created_at", Timestamp.class).toInstant().toString();
                record.base_relation = base_relation;
                record.table_name = rs.getObject("table_name", String.class);
                record.property = rs.getObject("property", String.class);
                record.id = rs.getObject("ID", Integer.class);
                data.add(record);
            }
        });
        return linked_records;
    }

    public List<Object[]> queryComposite(String template, Integer id, boolean withTitles) {
        LinkedList linked_records = new LinkedList();
        TemplateService.Linker linker = (TemplateService.Linker)this.compositeLinker.get(template);
        this.querier.do_query(linked_records, null, (sb, data) -> {
            sb.append("SELECT * FROM ");
            sb.append(linker.table);
            sb.append(" WHERE composite=");
            sb.append(id);
        }, (rs, data) -> {
            while (rs.next()) {
                RecordEntry record = new RecordEntry();
                record.table = linker.linked;
                int i = 1;
                for (String colum : COMPOSITE_LINKER_COLUMNS) {
                    Integer o;
                    record.key = o = rs.getObject(colum, Integer.class);
                    ++i;
                }
                data.add(record);
            }
        });
        System.out.println("linked_records = " + String.valueOf(linked_records));
        LinkedList<Object[]> the_records = new LinkedList<Object[]>();
        for (RecordEntry linked_record : linked_records) {
            Integer simple = linked_record.key;
            List simple_records = this.querySimple(linked_record.table, simple, withTitles);
            the_records.addAll(simple_records);
        }
        return the_records;
    }

    public List<Object[]> queryTemplates(TableKeyList tableKeyList, boolean withTitles) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        for (TableKey tableKey : tableKeyList.key) {
            logger.info("tableKey = " + String.valueOf(tableKey));
            List tmp = this.query(tableKey.isA, tableKey.ID, withTitles);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<String, Map<String, Map<String, String>>> getIoMap(String ioMapString) {
        List<String> toExclude = List.of("plead_transforming_composite");
        try {
            Map ioMap = (Map)this.om.readValue(ioMapString, typeRef);
            ((Map)ioMap.get("input")).entrySet().removeIf(entry -> toExclude.contains(entry.getKey()) || entry.getValue() == null || ((Map)entry.getValue()).isEmpty());
            ((Map)ioMap.get("output")).entrySet().removeIf(entry -> toExclude.contains(entry.getKey()) || entry.getValue() == null || ((Map)entry.getValue()).isEmpty());
            return ioMap;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String generateBackwardTemplateTraversal(Map<String, Map<String, Map<String, String>>> ioMap) {
        String backwardTraversalFunctionName = "backwardTraversal";
        2 funParams = new /* Unavailable Anonymous Inner Class!! */;
        3 functionReturns = new /* Unavailable Anonymous Inner Class!! */;
        QueryBuilder fun = ((QueryBuilder.FunctionQueryBuilder)new QueryBuilder().comment("Generated by method " + this.getClass().getName() + ".generateSQLSearchRecordFunction").next(QueryBuilder.createFunction((String)backwardTraversalFunctionName))).params((Map)funParams).returns("table", (Map)functionReturns).bodyStart("");
        Set allTables = ioMap.get("output").values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toSet());
        allTables.addAll(ioMap.get("input").values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toSet()));
        Map<String, Map<String, String>> input = ioMap.get("input");
        Map<String, Map<String, String>> output = ioMap.get("output");
        boolean before = false;
        for (String table : allTables) {
            Map input_table = this.filterMapAccordingToTable(table, input);
            Map output_table = this.filterMapAccordingToTable(table, output);
            for (String in_template : input_table.keySet()) {
                if (((Map)input_table.get(in_template)).keySet().isEmpty()) continue;
                fun.comment(" + in_template = " + in_template);
                for (String in_property : ((Map)input_table.get(in_template)).keySet()) {
                    for (String out_template : output_table.keySet()) {
                        if (((Map)output_table.get(out_template)).keySet().isEmpty()) continue;
                        for (String out_property : ((Map)output_table.get(out_template)).keySet()) {
                            Object in_templatex = in_template;
                            Object out_templatex = out_template;
                            if (in_template.equals(out_template)) {
                                in_templatex = "_" + in_template + "_in";
                                out_templatex = "_" + out_template + "_out";
                            }
                            String[] args = new String[]{String.format("%s as %s", PARAM_ID, IN_ID), String.format("'%s' as %s", in_template, IN_TEMPLATE), String.format("'%s' as %s", in_property, IN_PROPERTY), String.format("%s.id as %s", out_templatex, OUT_ID), String.format("'%s' as %s", out_template, OUT_TEMPLATE), String.format("'%s' as %s", out_property, OUT_PROPERTY)};
                            if (before) {
                                fun.newline().union(pp -> (QueryBuilder)QueryBuilder.select((Object[])args).apply(pp));
                            } else {
                                fun.selectExp(args);
                                before = true;
                            }
                            fun.from(new String[]{in_template});
                            if (!in_template.equals(in_templatex)) {
                                fun.alias((String)in_templatex);
                            }
                            fun.join(out_template);
                            if (!out_template.equals(out_templatex)) {
                                fun.alias((String)out_templatex);
                            }
                            fun.on(new String[]{(String)out_templatex + "." + out_property + " = " + (String)in_templatex + "." + in_property}).and(new String[]{String.valueOf(QueryBuilder.unquote((String)PARAM_PROPERTY)) + " = '" + in_property + "'"}).and(new String[]{(String)in_templatex + ".id=__param_id"});
                        }
                    }
                }
            }
        }
        return fun.bodyEnd("").getSQL();
    }

    private Map<String, Map<String, String>> filterMapAccordingToTable(String table, Map<String, Map<String, String>> input) {
        return input.keySet().stream().collect(Collectors.toMap(k -> k, k -> ((Map)input.get(k)).keySet().stream().filter(k2 -> ((String)((Map)input.get(k)).get(k2)).equals(table)).collect(Collectors.toMap(k2 -> k2, k2 -> (String)((Map)input.get(k)).get(k2)))));
    }
}

