/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.template;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.template.WebTemplateInvoker;
import org.openprovenance.prov.template.library.plead.client.integrator.InputOutputProcessor;
import org.openprovenance.prov.templates.library.LocalEnactor;
import org.openprovenance.prov.templates.library.PleadWorkflow;

public class PleadWorkflowIT
extends TestCase {
    private final InputOutputProcessor templateInvoker;
    private final ObjectMapper om = new ObjectMapper();
    static final ClientConfig config = new ClientConfig(PleadWorkflowIT.class);

    public PleadWorkflowIT(InputOutputProcessor templateInvoker) {
        this.templateInvoker = templateInvoker;
    }

    public PleadWorkflowIT() {
        final HashMap<String, AtomicInteger> map = new HashMap<String, AtomicInteger>(){
            {
                this.put("activity", new AtomicInteger(1000));
                this.put("file", new AtomicInteger(1000));
                this.put("score", new AtomicInteger(10000));
                this.put("approval", new AtomicInteger(100000));
            }
        };
        this.templateInvoker = new LocalEnactor(){

            public Integer incrementCounter(String counter) {
                return ((AtomicInteger)map.get(counter)).getAndIncrement();
            }
        };
    }

    public void testPleadLocal() {
        LinkedList inputs = new LinkedList();
        LinkedList outputs = new LinkedList();
        new PleadWorkflow(this.templateInvoker, null, null).workflow("doc123", Integer.valueOf(1), Integer.valueOf(220), Integer.valueOf(222), Integer.valueOf(1), Integer.valueOf(50), "path", null, null);
        new PleadWorkflow(this.templateInvoker, inputs, outputs).workflow("doc123", Integer.valueOf(1), Integer.valueOf(220), Integer.valueOf(222), Integer.valueOf(1), Integer.valueOf(50), "path", null, null);
        try {
            System.out.println(this.om.writeValueAsString(outputs));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void testPleadRemote() {
        LinkedList inputs = new LinkedList();
        LinkedList outputs = new LinkedList();
        String statementsURL = PleadWorkflowIT.config.hostURLprefixContext + "/provapi/statements";
        new PleadWorkflow((InputOutputProcessor)new WebTemplateInvoker(statementsURL), inputs, outputs).workflow("doc123", Integer.valueOf(1), Integer.valueOf(220), Integer.valueOf(222), Integer.valueOf(1), Integer.valueOf(50), "path", null, null);
        try {
            System.out.println(this.om.writeValueAsString(outputs));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

