/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.translator;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.interop.ApiUriFragments;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.service.ValidationReportMessageBodyReader;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.core.readers.VanillaDocumentMessageBodyReader;
import org.openprovenance.prov.validation.report.ValidationReport;
import org.openprovenance.prov.vanilla.ProvFactory;

public abstract class ProvenanceIT
extends TestCase
implements ApiUriFragments {
    static Logger logger = LogManager.getLogger(ProvenanceIT.class);
    static final ClientConfig config = new ClientConfig(ProvenanceIT.class);
    final org.openprovenance.prov.model.ProvFactory pf = new ProvFactory();
    final InteropFramework intF = new InteropFramework(this.pf);
    public static HashMap<String, String> table = new HashMap();
    List<String> urls = List.of("http://localhost:7072/ptl/webjars/prov-template-library/2.0.6-SNAPSHOT/templates/org/openprovenance/prov/templates/plead/plead-validating.provn", "http://localhost:7072/ptl/webjars/prov-template-library/2.0.6-SNAPSHOT/templates/org/openprovenance/prov/templates/plead/plead-validating.png", "http://localhost:7072/ptl/webjars/prov-template-library/2.0.6-SNAPSHOT/templates/org/openprovenance/prov/templates/plead/prov-plead-validating.prov-csv");

    public void testProvenanceOfTemplate() {
        this.testProvenanceOfTemplate(this.urls.get(0));
    }

    public void testProvenanceOfTemplate(String url) {
        Response response = this.getResource(url, "text/provenance-notation");
        System.out.println(response.getHeaders());
        Set links = response.getLinks();
        ProvenanceIT.assertEquals((int)1, (int)links.size());
        Link link = (Link)links.iterator().next();
        System.out.println(ProvenanceIT.escapeGreen(link.getParams().toString()));
        List rels = link.getRels();
        ProvenanceIT.assertEquals((int)1, (int)rels.size());
        ProvenanceIT.assertEquals((String)"http://www.w3.org/ns/prov#has_provenance", (String)((String)rels.get(0)));
        URI uri1 = link.getUri();
        String provUri = ProvenanceIT.config.hostURLprefix + uri1.getPath();
        Response response2 = this.getResource(provUri, "text/provenance-notation");
        Set links2 = response2.getLinks();
        String o = (String)response2.readEntity(String.class);
        ProvenanceIT.assertEquals((int)1, (int)links2.size());
        Link link2 = (Link)links2.iterator().next();
        System.out.println(ProvenanceIT.escapeGreen(link2.getParams().toString()));
        List rels2 = link2.getRels();
        ProvenanceIT.assertEquals((String)"http://www.w3.org/ns/prov#has_provenance", (String)((String)rels2.get(0)));
        URI uri2 = link2.getUri();
        ProvenanceIT.assertEquals((Object)uri1, (Object)uri2);
        System.out.println(response2.getHeaders());
        System.out.println(ProvenanceIT.escapeGreen(o));
    }

    public Object readObject(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        client.register(VanillaDocumentMessageBodyReader.class);
        WebTarget target = client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        Object o = response2.readEntity(InputStream.class);
        client.close();
        return o;
    }

    public ValidationReport readValidationReport(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            client.register(ValidationReportMessageBodyReader.class);
            WebTarget target = client.target(location);
            Response response2 = target.request(new String[]{media}).get();
            ValidationReport validationReport = (ValidationReport)response2.readEntity(ValidationReport.class);
            return validationReport;
        }
    }

    public String readAsString(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            client.register(ValidationReportMessageBodyReader.class);
            WebTarget target = client.target(location);
            Response response2 = target.request(new String[]{media}).get();
            String string = (String)response2.readEntity(String.class);
            return string;
        }
    }

    public Response getResource(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            WebTarget target = client.target(location);
            Response response2 = media == null ? target.request().get() : target.request(new String[]{media}).get();
            Response response = response2;
            return response;
        }
    }

    public Response getResource2(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(location);
        Response response2 = media == null ? target.request().get() : target.request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).get();
        String o = (String)response2.readEntity(String.class);
        client.close();
        return response2;
    }

    static String escapeRed(String str) {
        return "\u001b[31m" + str + "\u001b[0m";
    }

    static String escapeGreen(String str) {
        return "\u001b[32m" + str + "\u001b[0m";
    }
}

