/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.openprovenance.prov.client.ProcessorArgsInterface;
import org.openprovenance.prov.client.RecordsProcessorInterface;
import org.openprovenance.prov.service.Storage;
import org.openprovenance.prov.service.SuccessorConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.CompositeTableConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.ConverterConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.CsvConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.InputsConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.OutputsConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.PropertyOrderConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.SqlConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.SqlInsertConfigurator;
import org.openprovenance.prov.template.library.plead.client.configurator.TableConfigurator;
import org.openprovenance.prov.template.library.plead.client.logger.Logger;
import org.openprovenance.prov.template.library.plead.client.logger.TemplateBuilders;
import org.openprovenance.prov.template.library.plead.sql.integration.SqlCompositeEnactorConfigurator3;
import org.openprovenance.prov.template.library.plead.sql.integration.SqlEnactorConfigurator3;

public class TemplateDispatcher {
    static org.apache.logging.log4j.Logger logger = LogManager.getLogger(TemplateDispatcher.class);
    final TemplateBuilders allBuilders = new TemplateBuilders();
    private final Map<String, String[]> propertyOrder = Logger.initializeBeanTable((TableConfigurator)new PropertyOrderConfigurator());
    private final Map<String, ProcessorArgsInterface<String>> sqlConverter;
    private final Map<String, String> sqlInsert;
    private final Map<String, ProcessorArgsInterface<String>> csvConverter;
    private final Map<String, ProcessorArgsInterface<?>> beanConverter;
    private final Map<String, ProcessorArgsInterface<?>> enactorConverter;
    private final Map<String, RecordsProcessorInterface<?>> compositeEnactorConverter;
    private final Map<String, Map<String, List<String>>> successors;
    private final Map<String, Map<String, List<String>>> predecessors;
    private final Map<String, String[]> inputs = Logger.initializeBeanTable((TableConfigurator)new InputsConfigurator());
    private final Map<String, String[]> outputs = Logger.initializeBeanTable((TableConfigurator)new OutputsConfigurator());

    public TemplateDispatcher(Storage storage, Connection conn) {
        this.sqlConverter = Logger.initializeBeanTable((TableConfigurator)new SqlConfigurator());
        this.csvConverter = Logger.initializeBeanTable((TableConfigurator)new CsvConfigurator());
        this.sqlInsert = Logger.initializeBeanTable((TableConfigurator)new SqlInsertConfigurator());
        this.beanConverter = Logger.initializeBeanTable((TableConfigurator)new ConverterConfigurator());
        this.enactorConverter = Logger.initializeBeanTable((TableConfigurator)new SqlEnactorConfigurator3(storage.getQuerier(conn)));
        this.compositeEnactorConverter = Logger.initializeCompositeBeanTable((CompositeTableConfigurator)new SqlCompositeEnactorConfigurator3(storage.getQuerier(conn)));
        this.successors = Logger.initializeBeanTable((TableConfigurator)new SuccessorConfigurator());
        this.predecessors = this.successors.keySet().stream().collect(Collectors.toMap(k -> k, k -> this.getNonNullStringListMap(k).entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> Map.entry((String)entry.getKey(), v))).collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())))));
    }

    private Map<String, List<String>> getNonNullStringListMap(String k) {
        Map stringListMap = (Map)this.successors.get(k);
        return stringListMap == null ? Map.of() : stringListMap;
    }

    public Map<String, String[]> getPropertyOrder() {
        return this.propertyOrder;
    }

    public Map<String, ProcessorArgsInterface<String>> getSqlConverter() {
        return this.sqlConverter;
    }

    public Map<String, ProcessorArgsInterface<String>> getCsvConverter() {
        return this.csvConverter;
    }

    public Map<String, ProcessorArgsInterface<?>> getBeanConverter() {
        return this.beanConverter;
    }

    public Map<String, String> getSqlInsert() {
        return this.sqlInsert;
    }

    public Map<String, ProcessorArgsInterface<?>> getEnactorConverter() {
        return this.enactorConverter;
    }

    public Map<String, RecordsProcessorInterface<?>> getCompositeEnactorConverter() {
        return this.compositeEnactorConverter;
    }

    public Map<String, Map<String, List<String>>> getSuccessors() {
        return this.successors;
    }

    public Map<String, Map<String, List<String>>> getPredecessors() {
        return this.predecessors;
    }

    public Map<String, String[]> getInputs() {
        return this.inputs;
    }

    public Map<String, String[]> getOutputs() {
        return this.outputs;
    }
}

