/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.logging.log4j.LogManager;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.service.Querier;
import org.openprovenance.prov.service.Storage;
import org.openprovenance.prov.service.TableConfiguratorForObjectRecordMaker;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateLogic;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.TemplateService;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.readers.JsonOrCsv;
import org.openprovenance.prov.service.readers.SearchConfig;
import org.openprovenance.prov.service.readers.TableKeyList;
import org.openprovenance.prov.service.readers.TemplatesVizConfig;
import org.openprovenance.prov.service.security.pac.SecurityConfiguration;
import org.openprovenance.prov.service.security.pac.Utils;
import org.openprovenance.prov.template.library.plead.client.configurator.TableConfigurator;
import org.openprovenance.prov.template.library.plead.client.logger.Logger;
import org.openprovenance.prov.template.library.plead.configurator.TableConfiguratorForTypesWithMap;
import org.openprovenance.prov.template.library.plead.configurator.TableConfiguratorWithMap;
import org.openprovenance.prov.template.library.plead.sql.integration.SqlCompositeBeanEnactor3;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.vanilla.ProvFactory;
import org.openprovenance.prov.vanilla.ProvUtilities;

@Path(value="")
public class TemplateService {
    static org.apache.logging.log4j.Logger logger = LogManager.getLogger(TemplateService.class);
    public static final String APPLICATION_VND_KCL_PROV_TEMPLATE_JSON = "application/vnd.kcl.prov-template+json";
    private final PostService ps;
    private final ServiceUtils utils;
    private final TemplateDispatcher templateDispatcher;
    private final ObjectMapper om;
    private final Storage storage;
    final ProvFactory pf = new ProvFactory();
    private final Map<String, FileBuilder> documentBuilderDispatcher;
    public static final String TPL_HOST = "TPL_HOST";
    public static final String provHost = ServiceUtils.getSystemOrEnvironmentVariableOrDefault((String)"TPL_HOST", (String)"http://localhost:8080/ems");
    public static final String TPL_API = "TPL_API";
    public static final String provAPI = ServiceUtils.getSystemOrEnvironmentVariableOrDefault((String)"TPL_API", (String)"http://localhost:8080/ems/provapi");
    public static final String POSTGRES_HOST = "POSTGRES_HOST";
    public static final String postgresHost = System.getProperty("POSTGRES_HOST", "localhost");
    public static final String DB_USER = "TPL_DB_USER";
    public static final String postgresUsername = ServiceUtils.getSystemOrEnvironmentVariableOrDefault((String)"TPL_DB_USER", (String)"user");
    public static final String DB_PASS = "TPL_DB_PASS";
    public static final String postgresPassword = ServiceUtils.getSystemOrEnvironmentVariableOrDefault((String)"TPL_DB_PASS", (String)"password");
    public static final String TPL_SECURITY_CONFIG = "TPL_SECURITY_CONFIG";
    public static final String NO_SECURITY_CONFIG = "no-security-config";
    public static final String tplSecurityConfig = ServiceUtils.getSystemOrEnvironmentVariableOrDefault((String)"TPL_SECURITY_CONFIG", (String)"no-security-config");
    public static final Utils secUtils = new Utils();
    public static final SecurityConfiguration securityConfiguration = "no-security-config".equals(tplSecurityConfig) ? null : secUtils.readSecurityConfiguration(tplSecurityConfig);
    private final TemplateLogic templateLogic;
    private final SqlCompositeBeanEnactor3 sqlCompositeBeanEnactor3;
    private final Querier querier;
    private final TemplateQuery queryTemplate;
    private final Map<String, Linker> compositeLinker;
    private final Map<String, Map<String, Set<String>>> typeAssignment;
    private final Map<String, Function<Object[], Object[]>> recordMaker;
    static final List<String> sqlFilesToExecute = List.of("/utils.sql");

    public TemplateService(PostService ps) {
        this.ps = ps;
        this.utils = ps.getServiceUtils();
        this.storage = new Storage();
        ps.addToConfiguration("security.config", (Object)securityConfiguration);
        Connection conn = this.storage.setup(postgresHost, postgresUsername, postgresPassword);
        this.templateDispatcher = new TemplateDispatcher(this.storage, conn);
        this.querier = new Querier(this.storage, conn);
        this.om = new ObjectMapper();
        this.om.enable(SerializationFeature.INDENT_OUTPUT);
        this.om.registerModule((Module)new JavaTimeModule());
        this.sqlCompositeBeanEnactor3 = new SqlCompositeBeanEnactor3(this.storage.getQuerier(conn));
        this.compositeLinker = new /* Unavailable Anonymous Inner Class!! */;
        if (conn != null) {
            try {
                boolean anyResult = this.storage.initializeDB(conn);
                logger.info("DB initialized. Any results? " + anyResult);
                sqlFilesToExecute.forEach(file -> this.executeStatementsFromFile(conn, file));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        2 map = new /* Unavailable Anonymous Inner Class!! */;
        this.documentBuilderDispatcher = Logger.initializeBeanTable((TableConfigurator)new TableConfiguratorWithMap((Map)map, (org.openprovenance.prov.model.ProvFactory)this.pf));
        this.queryTemplate = new TemplateQuery(this.querier, this.templateDispatcher, this.compositeLinker, this.om, this.documentBuilderDispatcher, "{\"output\":{\"plead_validating\":{\"score\":\"score\",\"validating\":\"activity\"},\"plead_approving\":{\"approval_record\":\"approval_record\",\"approving\":\"activity\",\"approved_pipeline\":\"file\"},\"plead_filtering\":{\"filtered_file\":\"file\",\"filtering\":\"activity\"},\"plead_splitting\":{\"splitting\":\"activity\",\"split_file2\":\"file\",\"split_file1\":\"file\"},\"plead_training\":{\"pipeline\":\"file\",\"training\":\"activity\"},\"plead_transforming\":{\"transformed_file\":\"file\",\"transforming\":\"activity\"}},\"input\":{\"plead_validating\":{\"organization\":\"agent\",\"testing_dataset\":\"file\",\"engineer\":\"agent\"},\"plead_approving\":{\"pipeline\":\"file\",\"score\":\"score\",\"manager\":\"agent\",\"organization\":\"agent\"},\"plead_filtering\":{\"file\":\"file\",\"method\":\"method\",\"organization\":\"agent\",\"engineer\":\"agent\"},\"plead_splitting\":{\"file\":\"file\",\"organization\":\"agent\",\"engineer\":\"agent\"},\"plead_training\":{\"training_dataset\":\"file\",\"organization\":\"agent\",\"engineer\":\"agent\"},\"plead_transforming\":{\"file\":\"file\",\"method\":\"method\",\"organization\":\"agent\",\"engineer\":\"agent\"}}}");
        this.typeAssignment = Logger.initializeBeanTable((TableConfigurator)new TableConfiguratorForTypesWithMap(new HashMap(), this.templateDispatcher.getPropertyOrder(), this.documentBuilderDispatcher, null));
        this.recordMaker = Logger.initializeBeanTable((TableConfigurator)new TableConfiguratorForObjectRecordMaker(this.documentBuilderDispatcher));
        this.templateLogic = new TemplateLogic(this.pf, this.queryTemplate, this.templateDispatcher, null, this.documentBuilderDispatcher, this.utils, this.om, this.sqlCompositeBeanEnactor3, this.typeAssignment);
    }

    private void executeStatementsFromFile(Connection conn, String filename) {
        boolean anyResult;
        String statements = Storage.getStringFromClasspath(this.getClass(), (String)filename);
        try {
            anyResult = this.storage.executeStatements(conn, statements);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        logger.info("DB processing file " + filename + ". Any results? " + anyResult);
    }

    @POST
    @Path(value="/statements")
    @Tag(name="template")
    @Consumes(value={"text/csv", "application/vnd.kcl.prov-template+json"})
    @Produces(value={"text/csv", "application/vnd.kcl.prov-template+json"})
    public Response submitStatements(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, JsonOrCsv documentOrCsv) {
        List result;
        Principal principal = request.getUserPrincipal();
        logger.info("post statements id: principal " + String.valueOf(principal));
        if (documentOrCsv == null) {
            return this.utils.composeResponseInternalServerError("null document", (Throwable)new NullPointerException());
        }
        if (documentOrCsv.csv != null) {
            result = this.templateLogic.processIncomingCsv(documentOrCsv.csv);
        } else if (documentOrCsv.json != null) {
            result = this.templateLogic.processIncomingJson(documentOrCsv.json);
        } else {
            return this.utils.composeResponseInternalServerError("unknown input document", (Throwable)new UnsupportedOperationException());
        }
        switch (request.getHeader("Accept").toLowerCase()) {
            case "text/csv": {
                return ServiceUtils.composeResponseOK((Object)this.templateLogic.streamOutRecordsToCSV(result)).type("text/csv").build();
            }
            case "application/vnd.kcl.prov-template+json": {
                StreamingOutput promise = out -> this.om.writeValue(out, (Object)result);
                return ServiceUtils.composeResponseOK((Object)promise).type(APPLICATION_VND_KCL_PROV_TEMPLATE_JSON).build();
            }
        }
        return this.utils.composeResponseBadRequest("unknown accept header " + request.getHeader("Accept"), (Throwable)new UnsupportedOperationException(request.getHeader("Accept")));
    }

    @GET
    @Path(value="/template/{template}/{id}.{extension}")
    @Tag(name="template")
    @Produces(value={"application/ld+json", "text/provenance-notation", "image/svg+xml"})
    public Response getTemplateInstanceWithId(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Parameter(name="template", description="template name", required=true) @PathParam(value="template") String template, @Parameter(name="id", description="record id", required=true) @PathParam(value="id") Integer id, @Parameter(name="extension", description="extension", required=true) @PathParam(value="extension") String extension) {
        logger.info("getTemplateInstanceWithId " + template + " " + id + " " + extension);
        List records = this.queryTemplate.query(template, id, false);
        this.debugDisplay("records.size ", (Object)records.size());
        Document result = this.queryTemplate.constructDocument(this.documentBuilderDispatcher, records);
        switch (extension) {
            case "jsonld": {
                return ServiceUtils.composeResponseOK((Object)result).type("application/ld+json").build();
            }
            case "provn": {
                return ServiceUtils.composeResponseOK((Object)result).type("text/provenance-notation").build();
            }
            case "svg": {
                return ServiceUtils.composeResponseOK((Object)result).type("image/svg+xml").build();
            }
        }
        return this.utils.composeResponseBadRequest("unknown extension " + extension, (Throwable)new UnsupportedOperationException(extension));
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/template/{template}/{id}/{variable:\\w+}{extension:(\\.\\w+)?}")
    @Tag(name="template")
    @Produces(value={"application/ld+json", "text/provenance-notation", "image/svg+xml"})
    public Response getTemplatePropertyInstanceWithId(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Parameter(name="template", description="template name", required=true) @PathParam(value="template") String template, @Parameter(name="id", description="record id", required=true) @PathParam(value="id") Integer id, @Parameter(name="variable", description="variable", required=true) @PathParam(value="variable") String variable, @Parameter(name="extension", description="extension", required=true) @PathParam(value="extension") String extension) {
        void var14_20;
        logger.info("getTemplatePropertyInstanceWithId " + template + " " + id + " " + variable);
        List records = this.queryTemplate.query(template, id, false);
        Document result = this.queryTemplate.constructDocument(this.documentBuilderDispatcher, records);
        LinkedList<Object> selections = new LinkedList<Object>();
        for (Object[] record : records) {
            int n = Arrays.asList((String[])this.templateDispatcher.getPropertyOrder().get(template)).indexOf(variable);
            Object[] objectRecord = (Object[])((Function)this.recordMaker.get(template)).apply(record);
            selections.add(objectRecord[n]);
        }
        Document newDoc = this.pf.newDocument();
        newDoc.setNamespace(result.getNamespace());
        for (Object e2 : selections) {
            QualifiedName qn = (QualifiedName)e2;
            new ProvUtilities().getEntity(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
            new ProvUtilities().getAgent(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
            new ProvUtilities().getActivity(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
        }
        System.out.println("selections " + String.valueOf(selections));
        extension = this.determineOptionalExtension(headers, extension);
        String string = extension;
        int n = -1;
        switch (string.hashCode()) {
            case -1150656416: {
                if (!string.equals("jsonld")) break;
                boolean bl = false;
                break;
            }
            case 106940965: {
                if (!string.equals("provn")) break;
                boolean bl = true;
                break;
            }
            case 114276: {
                if (!string.equals("svg")) break;
                int n2 = 2;
            }
        }
        switch (var14_20) {
            case 0: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("application/ld+json").build();
            }
            case 1: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("text/provenance-notation").build();
            }
            case 2: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("image/svg+xml").build();
            }
        }
        return this.utils.composeResponseBadRequest("unknown extension " + extension, (Throwable)new UnsupportedOperationException(extension));
    }

    private void debugDisplay(String msg, Object object) {
        try {
            System.out.println(msg + this.om.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @POST
    @Path(value="/templates.{extension}")
    @Tag(name="template")
    @Produces(value={"application/ld+json", "text/provenance-notation", "image/svg+xml"})
    @Consumes(value={"application/json"})
    public Response getTemplates(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Parameter(name="extension", description="extension", required=true) @PathParam(value="extension") String extension, TableKeyList tableKey) {
        List records = this.queryTemplate.queryTemplates(tableKey, false);
        Document result = this.queryTemplate.constructDocument(this.documentBuilderDispatcher, records);
        switch (extension) {
            case "jsonld": {
                return ServiceUtils.composeResponseOK((Object)result).type("application/ld+json").build();
            }
            case "provn": {
                return ServiceUtils.composeResponseOK((Object)result).type("text/provenance-notation").build();
            }
            case "svg": {
                return ServiceUtils.composeResponseOK((Object)result).type("image/svg+xml").build();
            }
        }
        return this.utils.composeResponseBadRequest("unknown extension " + extension, (Throwable)new UnsupportedOperationException(extension));
    }

    @POST
    @Path(value="/templates/records")
    @Tag(name="template")
    @Consumes(value={"application/json"})
    @Produces(value={"text/csv"})
    public Response getTemplatesRecords(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, SearchConfig searchConfig) {
        logger.info("getTemplatesRecords " + String.valueOf(searchConfig));
        List records = this.queryTemplate.queryTemplatesRecords(searchConfig);
        CSVFormat csvFileFormat = CSVFormat.DEFAULT.withHeader(new String[0]);
        StreamingOutput promise = out -> {
            OutputStreamWriter out2 = new OutputStreamWriter(out);
            try {
                CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)out2, csvFileFormat);
                csvFilePrinter.printComment("Generated by TemplateService");
                csvFilePrinter.printRecord(new Object[]{"id", "created_at", "base_relation", "table_name", "key"});
                for (TemplateQuery.RecordEntry2 record : records) {
                    csvFilePrinter.printRecord(new Object[]{record.id, record.created_at, record.base_relation, record.table_name, record.key});
                }
                csvFilePrinter.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return ServiceUtils.composeResponseOK((Object)promise).type("text/csv").build();
    }

    @POST
    @Path(value="/templates/viz")
    @Tag(name="template")
    @Consumes(value={"application/json"})
    @Produces(value={"image/svg+xml"})
    public Response getTemplatesViz(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, TemplatesVizConfig config) {
        StreamingOutput promise = out -> this.templateLogic.generateViz(config, out);
        return ServiceUtils.composeResponseOK((Object)promise).type("image/svg+xml").build();
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/live/{relation}/{id:\\d+}{extension:(\\.\\w+)?}")
    @Tag(name="template")
    @Produces(value={"application/ld+json", "text/provenance-notation", "image/svg+xml"})
    @Consumes(value={"application/json"})
    public Response getLiveNode(@Context HttpServletResponse response, @Context HttpServletRequest request, @Context HttpHeaders headers, @Context UriInfo uriInfo, @Parameter(name="relation", description="relation", required=true) @PathParam(value="relation") String relation, @Parameter(name="id", description="id", required=true) @PathParam(value="id") Integer id, @Parameter(name="extension", description="extension", required=false) @PathParam(value="extension") String extension) {
        void var15_23;
        logger.info("getLiveNode " + relation + " " + id);
        logger.info("accept header " + String.valueOf(headers.getAcceptableMediaTypes()));
        List ll = this.templateLogic.generateLiveNode(relation, id);
        TableKeyList tableKeyList = new TableKeyList();
        ll.forEach(e -> tableKeyList.key.add(new /* Unavailable Anonymous Inner Class!! */));
        logger.info("getLiveNode " + String.valueOf(tableKeyList));
        List records = this.queryTemplate.queryTemplates(tableKeyList, false);
        Document result = this.queryTemplate.constructDocument(this.documentBuilderDispatcher, records);
        HashSet<Object> selections = new HashSet<Object>();
        for (int i = 0; i < records.size(); ++i) {
            Object[] record = (Object[])records.get(i);
            String string = ((TemplateQuery.RecordEntry2)ll.get((int)i)).property;
            String template = (String)record[0];
            logger.info("template " + template);
            logger.info("property " + string);
            logger.info("record " + String.valueOf(Arrays.asList(record)));
            int index = Arrays.asList((String[])this.templateDispatcher.getPropertyOrder().get(template)).indexOf(string);
            Object[] objectRecord = (Object[])((Function)this.recordMaker.get(template)).apply(record);
            selections.add(objectRecord[index]);
        }
        logger.info("selections " + String.valueOf(selections));
        Document newDoc = this.pf.newDocument();
        newDoc.setNamespace(result.getNamespace());
        for (Object e2 : selections) {
            QualifiedName qn = (QualifiedName)e2;
            new ProvUtilities().getEntity(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
            new ProvUtilities().getAgent(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
            new ProvUtilities().getActivity(result).stream().filter(e -> qn.getUri().equals(e.getId().getUri())).forEach(e -> newDoc.getStatementOrBundle().add(e));
        }
        extension = this.determineOptionalExtension(headers, extension);
        String string = extension;
        int n = -1;
        switch (string.hashCode()) {
            case -1150656416: {
                if (!string.equals("jsonld")) break;
                boolean bl = false;
                break;
            }
            case 106940965: {
                if (!string.equals("provn")) break;
                boolean bl = true;
                break;
            }
            case 114276: {
                if (!string.equals("svg")) break;
                int n2 = 2;
            }
        }
        switch (var15_23) {
            case 0: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("application/ld+json").build();
            }
            case 1: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("text/provenance-notation").build();
            }
            case 2: {
                return ServiceUtils.composeResponseOK((Object)newDoc).type("image/svg+xml").build();
            }
        }
        return this.utils.composeResponseBadRequest("unknown extension " + extension, (Throwable)new UnsupportedOperationException(extension));
    }

    private String determineOptionalExtension(HttpHeaders headers, String extension) {
        extension = extension == null || extension.isEmpty() ? (headers.getAcceptableMediaTypes().contains(MediaType.valueOf((String)"text/provenance-notation")) ? "provn" : (headers.getAcceptableMediaTypes().contains(MediaType.valueOf((String)"application/ld+json")) ? "jsonld" : (headers.getAcceptableMediaTypes().contains(MediaType.valueOf((String)"image/svg+xml")) ? "svg" : (headers.getAcceptableMediaTypes().contains(MediaType.valueOf((String)"text/html")) ? "svg" : "jsonld")))) : extension.substring(1);
        return extension;
    }
}

