/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.service.core.Constants;

public class HasProvenanceHeaderFilter
implements Filter,
Constants {
    static Logger logger = LogManager.getLogger(HasProvenanceHeaderFilter.class);

    public HasProvenanceHeaderFilter() {
        logger.info("########### HasProvenanceHeaderFilter constructor ###########");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.contains("webjars/prov-template-library/") && requestURI.contains("templates/org/openprovenance/prov/templates/") && (requestURI.endsWith(".provn") || requestURI.endsWith(".png") || requestURI.endsWith(".prov-csv"))) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String templateName = requestURI.substring(requestURI.lastIndexOf("/") + 1);
            if (templateName.startsWith("prov-")) {
                templateName = templateName.substring(5);
            }
            String prefix = requestURI.substring(0, requestURI.lastIndexOf("/"));
            templateName = templateName.substring(0, templateName.lastIndexOf("."));
            String theProvenance = prefix + "/prov-" + templateName + ".prov-csv";
            httpServletResponse.setHeader("Link", "<" + theProvenance + ">; rel=\"http://www.w3.org/ns/prov#has_provenance\"");
            logger.info("filter: " + requestURI);
            logger.info("filter:   " + theProvenance);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

