/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.service.Storage;
import org.openprovenance.prov.service.inface.BiConsumerWithException;

public class Querier {
    private static final Logger logger = LogManager.getLogger(Querier.class);
    private final Storage storage;
    private final Connection conn;

    public Querier(Storage storage, Connection conn) {
        this.storage = storage;
        this.conn = conn;
    }

    public <T> T do_query(T data, Consumer<T> check, BiConsumer<StringBuilder, T> composeQuery, BiConsumerWithException<ResultSet, T> completeData) {
        if (check != null) {
            check.accept(data);
        }
        StringBuilder sb = new StringBuilder();
        composeQuery.accept(sb, (StringBuilder)data);
        String statement = sb.toString();
        logger.info("Executing statement: " + statement);
        try {
            ResultSet rs = this.storage.executeQuery(this.conn, statement);
            completeData.accept((Object)rs, data);
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new UncheckedException("Issue in enactment " + statement, (Exception)e);
        }
        return data;
    }

    public <T> boolean do_statements(T data, Consumer<T> check, BiConsumer<StringBuilder, T> composeQuery) {
        boolean rs;
        if (check != null) {
            check.accept(data);
        }
        StringBuilder sb = new StringBuilder();
        composeQuery.accept(sb, (StringBuilder)data);
        String statement = sb.toString();
        try {
            rs = this.storage.executeStatements(this.conn, statement);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new UncheckedException("Issue in enactment " + statement, (Exception)e);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long storeBlobs(InputStream descriptorStream, InputStream binaryStream, String mediaType, String name, String insertStatement) throws SQLException, IOException {
        try (InputStream inputStream = descriptorStream;){
            long l;
            block24: {
                InputStream inputStream2 = binaryStream;
                try {
                    long id;
                    block23: {
                        PreparedStatement statement = this.conn.prepareStatement(insertStatement, 1);
                        statement.setBinaryStream(1, descriptorStream);
                        statement.setBinaryStream(2, binaryStream);
                        statement.setString(3, mediaType);
                        statement.setString(4, name);
                        int affectedRows = statement.executeUpdate();
                        if (affectedRows == 0) {
                            throw new SQLException("Creating resource_data, no rows affected.");
                        }
                        try (ResultSet generatedKeys = statement.getGeneratedKeys();){
                            if (generatedKeys.next()) {
                                id = generatedKeys.getLong(1);
                                break block23;
                            }
                            throw new SQLException("Creating user failed, no ID obtained.");
                        }
                        finally {
                            statement.close();
                        }
                    }
                    l = id;
                    if (inputStream2 == null) break block24;
                }
                catch (Throwable throwable) {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream2.close();
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Triple<InputStream, String, String> getBlobs3(long id, String query) {
        try (PreparedStatement statement = this.conn.prepareStatement(query);){
            statement.setLong(1, id);
            ResultSet rs = statement.executeQuery();
            if (rs == null) return null;
            if (rs.next()) {
                InputStream binaryStream = rs.getBinaryStream(1);
                String mediaType = rs.getString(2);
                String name = rs.getString(3);
                Triple triple = Triple.of((Object)binaryStream, (Object)mediaType, (Object)name);
                return triple;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getBlobs(long id, String query) {
        try (PreparedStatement statement = this.conn.prepareStatement(query);){
            statement.setLong(1, id);
            ResultSet rs = statement.executeQuery();
            if (rs == null) return null;
            if (rs.next()) {
                InputStream binaryStream;
                InputStream inputStream = binaryStream = rs.getBinaryStream(1);
                return inputStream;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

