/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.client.ProcessorArgsInterface;
import org.openprovenance.prov.client.RecordsProcessorInterface;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.service.EnactCsvRecords;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.readers.TemplatesVizConfig;
import org.openprovenance.prov.template.library.plead.Plead_trainingBuilder;
import org.openprovenance.prov.template.library.plead.Plead_trainingBuilderInterface;
import org.openprovenance.prov.template.library.plead.sql.access_control.BeanEnactor4;
import org.openprovenance.prov.template.library.plead.sql.access_control.SqlCompositeBeanEnactor4;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import org.openprovenance.prov.vanilla.ProvFactory;

public class TemplateLogic {
    static Logger logger = LogManager.getLogger(TemplateLogic.class);
    private final ProvFactory pf;
    private final TemplateDispatcher templateDispatcher;
    private final Map<String, FileBuilder> documentBuilderDispatcher;
    private final ServiceUtils utils;
    private final ObjectMapper om;
    private final SqlCompositeBeanEnactor4 sqlCompositeBeanEnactor;
    private final EnactCsvRecords<Object> enactCsvRecords = new EnactCsvRecords();
    private final TemplateQuery templateQuery;
    private final Map<String, Map<String, Set<String>>> typeAssignment;

    public TemplateLogic(ProvFactory pf, TemplateQuery templateQuery, TemplateDispatcher templateDispatcher, Object o1, Map<String, FileBuilder> documentBuilderDispatcher, ServiceUtils utils, ObjectMapper om, SqlCompositeBeanEnactor4 sqlCompositeBeanEnactor, Map<String, Map<String, Set<String>>> typeAssignment) {
        this.pf = pf;
        this.templateDispatcher = templateDispatcher;
        this.documentBuilderDispatcher = documentBuilderDispatcher;
        this.utils = utils;
        this.om = om;
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.sqlCompositeBeanEnactor = sqlCompositeBeanEnactor;
        this.templateQuery = templateQuery;
        this.typeAssignment = typeAssignment;
    }

    public List<Object> processIncomingJson(List<Map<String, Object>> entries) {
        String isA = (String)entries.get(0).get("isA");
        LinkedList<Object> recordsResult = new LinkedList<Object>();
        Map properties = this.templateDispatcher.getPropertyOrder();
        Map enactorConverters = this.templateDispatcher.getEnactorConverter();
        Map compositeEnactorConverters = this.templateDispatcher.getCompositeEnactorConverter();
        String[] props = (String[])properties.get(isA);
        ProcessorArgsInterface enactor = (ProcessorArgsInterface)enactorConverters.get(isA);
        if (enactor != null) {
            for (Map<String, Object> entry : entries) {
                Object[] array = this.convertToArray(entry, props);
                recordsResult.add(enactor.process(array));
            }
        } else {
            for (Map<String, Object> composite : entries) {
                LinkedList<Object[]> objects = new LinkedList<Object[]>();
                Object[] array = this.convertToArray(composite, props);
                objects.add(array);
                for (Map composee : (List)composite.get("__elements")) {
                    String is2A = (String)composee.get("isA");
                    String[] props2 = (String[])properties.get(is2A);
                    Object[] array2 = this.convertToArray(composee, props2);
                    objects.add(array2);
                }
                System.out.println("need composite converter for " + isA);
                System.out.println("need composite converter for " + String.valueOf(compositeEnactorConverters));
                RecordsProcessorInterface compositeEnactor = (RecordsProcessorInterface)compositeEnactorConverters.get(isA);
                System.out.println("found composite converter for " + String.valueOf(compositeEnactor));
                Object res = compositeEnactor.process(objects);
                this.debugDisplay("found result ", res);
                recordsResult.add(res);
            }
        }
        return recordsResult;
    }

    public Object[] convertToArray(Map<String, Object> entry, String[] props) {
        Object[] array = new Object[props.length];
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i];
            array[i] = entry.getOrDefault(prop, null);
        }
        return array;
    }

    private void debugDisplay(String msg, Object object) {
        try {
            System.out.println(msg + this.om.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Object> processIncomingCsv(CSVParser csv) {
        List collection = csv.getRecords();
        Map enactors = this.templateDispatcher.getEnactorConverter();
        Map<String, ProcessorArgsInterface> enactors2 = enactors.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> (ProcessorArgsInterface)e.getValue()));
        Map compositeEnactors = this.templateDispatcher.getCompositeEnactorConverter();
        Map<String, RecordsProcessorInterface> compositeEnactors2 = compositeEnactors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (RecordsProcessorInterface)e.getValue()));
        List newRecords = this.enactCsvRecords.process((Collection)collection, enactors2, compositeEnactors2);
        return newRecords;
    }

    @NotNull
    public StreamingOutput streamOutRecordsToCSV(List<Object> newRecords) {
        return out -> newRecords.forEach(record -> {
            try {
                out.write(((String)record).getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void generateViz(TemplatesVizConfig config, String principal, OutputStream out) {
        this.typeAssignment.entrySet().removeIf(entry -> entry.getValue() == null || ((Map)entry.getValue()).isEmpty());
        Map<String, Map> baseTypes = this.typeAssignment.keySet().stream().collect(Collectors.toMap(tpl -> tpl, tpl -> ((Map)this.typeAssignment.get(tpl)).keySet().stream().collect(Collectors.toMap(var -> var, var -> this.preferredType((Set)((Map)this.typeAssignment.get(tpl)).get(var))))));
        logger.info("baseTypes " + String.valueOf(baseTypes));
        this.templateQuery.generateViz(config.id, config.template, config.property, baseTypes, principal, out);
    }

    private int colorValue(String s) {
        if (s == null) {
            return 0;
        }
        switch (s) {
            case "http://www.w3.org/ns/prov#Entity": {
                return 1;
            }
            case "http://www.w3.org/ns/prov#Activity": {
                return 2;
            }
            case "http://www.w3.org/ns/prov#Agent": {
                return 3;
            }
        }
        return 0;
    }

    private String preferredType(Set<String> value) {
        return value.stream().max(Comparator.comparingInt(arg_0 -> this.colorValue(arg_0))).orElse("none");
    }

    private Map<String, Set<String>> plead_trainingLevel0() {
        String[] propertyOrder = (String[])this.templateDispatcher.getPropertyOrder().get("plead_training");
        Plead_trainingBuilder plead_trainingBuilder = (Plead_trainingBuilder)this.documentBuilderDispatcher.get("plead_training");
        Object[] record2 = (Object[])plead_trainingBuilder.make((Plead_trainingBuilderInterface)plead_trainingBuilder.getTypedRecord());
        HashMap knownTypeMap = new HashMap();
        plead_trainingBuilder.make((Plead_trainingBuilderInterface)plead_trainingBuilder.getTypeManager(knownTypeMap, new HashMap(), new HashMap(), new HashMap(), new HashMap()));
        HashMap<String, Set<String>> propertyMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < record2.length; ++i) {
            String property = propertyOrder[i];
            Object value = record2[i];
            if (!(value instanceof QualifiedName)) continue;
            propertyMap.put(property, (Set)knownTypeMap.get((QualifiedName)value));
        }
        Map propertyMap2 = (Map)this.typeAssignment.get("plead_training");
        System.out.println("propertyMap " + String.valueOf(propertyMap));
        System.out.println("propertyMap2 " + String.valueOf(propertyMap2));
        return propertyMap;
    }

    public List<TemplateQuery.RecordEntry2> generateLiveNode(String relation, Integer id, String principal) {
        List records = this.templateQuery.queryTemplatesRecordsById(relation, id, Integer.valueOf(30), principal);
        return records;
    }

    public Object postProcessing(int id, String template) {
        logger.info("postProcessing " + id + " " + template);
        String principal = BeanEnactor4.getPrincipal();
        List records = this.templateQuery.query(template, Integer.valueOf(id), false, principal);
        logger.info("records " + records.size() + " " + records.stream().map(Arrays::toString).collect(Collectors.joining(",")));
        if (!records.isEmpty()) {
            if (records.size() > 1) {
                Map hash = this.templateQuery.computeHash(template, id, records);
                this.templateQuery.updateHash(template, id, hash, principal);
                logger.info("update hash for " + id + " " + template + ": " + String.valueOf(hash));
            } else {
                Object[] record = (Object[])records.get(0);
                Map hash = this.templateQuery.computeHash(template, id, record);
                this.templateQuery.updateHash(template, id, hash, principal);
                logger.info("update hash for " + id + " " + template + ": " + String.valueOf(hash));
            }
        }
        return null;
    }
}

