/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.dot.ProvToDot;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.TemplatesToDot;

/*
 * Exception performing whole class analysis ignored.
 */
public class TemplatesToDot
extends ProvToDot {
    private static final Logger logger = LogManager.getLogger(TemplatesToDot.class);
    private final List<TemplateQuery.TemplateConnection> templateConnections;
    private final TemplateDispatcher templateDispatcher;
    private final Map<String, Map<String, Map<String, String>>> ioMap;
    private final Map<String, Map<String, String>> baseTypes;
    final Map<String, String> provcolors = new /* Unavailable Anonymous Inner Class!! */;
    String headstyle = "invempty";
    String tailstyle = "empty";

    public TemplatesToDot(List<TemplateQuery.TemplateConnection> templateConnections, Map<String, Map<String, String>> baseTypes, Map<String, Map<String, Map<String, String>>> ioMap, TemplateDispatcher templateDispatcher, ProvFactory pf) {
        super(pf);
        this.templateConnections = templateConnections;
        this.templateDispatcher = templateDispatcher;
        this.ioMap = ioMap;
        this.baseTypes = baseTypes;
    }

    public static String createHtmlTable(TemplateInfo templateInfo, List<String> inputsNames, List<String> inputsPorts, List<String> inputsColors, List<String> outputsNames, List<String> outputsPorts, List<String> outputColors) {
        int i;
        StringBuilder html = new StringBuilder();
        html.append("<TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"4\">\n");
        html.append("  <TR>\n");
        html.append(String.format("    <TD ROWSPAN=\"3\" HREF=\"%s\"  TARGET=\"_blank\">%s </TD>\n", templateInfo.url, templateInfo.templateId));
        for (i = 0; i < inputsNames.size(); ++i) {
            html.append(String.format("    <TD PORT=\"%s\" BGCOLOR=\"%s\" HREF=\"%s\" TARGET=\"_blank\">%s</TD>\n", inputsPorts.get(i), inputsColors.get(i), templateInfo.url.replace(".svg", "/" + inputsNames.get(i)), inputsNames.get(i)));
        }
        html.append("  </TR>\n");
        html.append("  <TR>\n");
        for (i = 0; i < outputsNames.size(); ++i) {
            html.append(String.format("    <TD PORT=\"%s\" BGCOLOR=\"%s\"  HREF=\"%s\"  TARGET=\"_blank\">%s</TD>\n", outputsPorts.get(i), outputColors.get(i), templateInfo.url.replace(".svg", "/" + outputsNames.get(i)), outputsNames.get(i)));
        }
        html.append("  </TR>\n");
        html.append("</TABLE>");
        return html.toString();
    }

    public void convert(Document graph, OutputStream os, String title) {
        try {
            File dotFile = File.createTempFile("temp", ".dot");
            logger.info("dotFile: " + String.valueOf(dotFile));
            this.convert(graph, new PrintStream(new FileOutputStream(dotFile)), title);
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("dot  -Tsvg " + String.valueOf(dotFile));
            InputStream is = proc.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            logger.info("finished conversion to svg");
            boolean bl = dotFile.delete();
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
            throw new UncheckedException((Exception)e);
        }
    }

    public void convert(Document doc, PrintStream out, String title) {
        if (title != null) {
            this.name = title;
        }
        this.prelude(doc, out);
        HashSet<TemplateInfo> allTemplates = new HashSet<TemplateInfo>();
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            allTemplates.add(TemplateInfo.of((String)templateConnection.in_template, (String)this.templateName(templateConnection.in_template, templateConnection.in_id), (String)this.url(templateConnection.in_template, templateConnection.in_id)));
            allTemplates.add(TemplateInfo.of((String)templateConnection.out_template, (String)this.templateName(templateConnection.out_template, templateConnection.out_id), (String)this.url(templateConnection.out_template, templateConnection.out_id)));
        }
        Map inputs = (Map)this.ioMap.get("input");
        Map outputs = (Map)this.ioMap.get("output");
        for (TemplateInfo templateInfo : allTemplates) {
            String template = templateInfo.template;
            String templateId = templateInfo.templateId;
            Map templateBaseTypes = (Map)this.baseTypes.get(template);
            ArrayList inputsNames = new ArrayList(((Map)inputs.get(template)).keySet());
            List inputPorts = inputsNames.stream().map(s -> this.portName(template, templateId, s)).collect(Collectors.toList());
            List inputsColors = inputsNames.stream().map(s -> (String)this.provcolors.get(templateBaseTypes.get(s))).collect(Collectors.toList());
            ArrayList outputsNames = new ArrayList(((Map)outputs.get(template)).keySet());
            List outputsPorts = outputsNames.stream().map(s -> this.portName(template, templateId, s)).collect(Collectors.toList());
            List outputsColors = outputsNames.stream().map(s -> (String)this.provcolors.get(templateBaseTypes.get(s))).collect(Collectors.toList());
            String html = TemplatesToDot.createHtmlTable((TemplateInfo)templateInfo, inputsNames, inputPorts, inputsColors, outputsNames, outputsPorts, outputsColors);
            this.emitTemplate(template, templateId, html, out);
        }
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            this.emitEdge(this.qualifiedPortName(templateConnection.in_template, this.templateName(templateConnection.in_template, templateConnection.in_id), templateConnection.in_property), this.qualifiedPortName(templateConnection.out_template, this.templateName(templateConnection.out_template, templateConnection.out_id), templateConnection.out_property), out);
        }
        this.postlude(doc, out);
        out.close();
    }

    private void emitEdge(String source, String destination, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(source).append(":n");
        sb.append(" -> ");
        sb.append(destination).append(":s");
        sb.append("[dir=\"both\", arrowhead=\"").append(this.headstyle).append("\", arrowtail=\"").append(this.tailstyle).append("\"]");
        sb.append(";\n");
        out.println(sb.toString());
    }

    private String portName(String template, String templateId, String property) {
        return template + "_" + templateId + "_" + property;
    }

    private String qualifiedPortName(String template, String templateId, String property) {
        return templateId + ":" + this.portName(template, templateId, property);
    }

    public void emitTemplate(String template, String templateId, String htmlTable, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("node [shape=plaintext]\n");
        sb.append(templateId);
        sb.append(" [label=<");
        sb.append(htmlTable);
        sb.append(">];\n");
        out.println(sb.toString());
    }

    private String templateName(String template, Integer id) {
        return template + "_" + id;
    }

    private String url(String template, Integer id) {
        return "/ptl/provapi/template/" + template + "/" + id + ".svg";
    }
}

