/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.core.jsonld11.serialization.ProvDeserialiser;
import org.openprovenance.prov.service.IsDocumentWithFieldsToIgnore;
import org.openprovenance.prov.validation.report.ValidationReport;

@Provider
public class ValidationReportMessageBodyReader
implements MessageBodyReader<ValidationReport> {
    static Logger logger = LogManager.getLogger(ValidationReportMessageBodyReader.class);

    public String trimCharSet(MediaType mediaType) {
        String med = mediaType.toString();
        int ind = med.indexOf(";");
        if (ind > 0) {
            med = med.substring(0, ind);
        }
        return med;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.trimCharSet(mediaType).equals(MediaType.APPLICATION_JSON_TYPE.toString());
    }

    public ValidationReport readFrom(Class<ValidationReport> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream is) throws IOException, WebApplicationException {
        ValidationReport report = null;
        logger.info("readFrom() returning ValidationReport");
        ObjectMapper mapper = new ProvDeserialiser().getMapper();
        mapper.addMixIn(ValidationReport.class, IsDocumentWithFieldsToIgnore.class);
        logger.info("readFrom() mixin set");
        report = (ValidationReport)mapper.readValue(is, ValidationReport.class);
        logger.info("readFrom() done");
        return report;
    }
}

