/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.template;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.service.template.ServiceInvoker;
import org.openprovenance.prov.template.library.plead.client.integrator.TemplateInvoker;
import org.springframework.core.ParameterizedTypeReference;

public class WebTemplateInvoker
extends TemplateInvoker {
    static Logger logger = LogManager.getLogger(WebTemplateInvoker.class);
    final ServiceInvoker si = new ServiceInvoker();
    static final ParameterizedTypeReference<List<Map<String, Object>>> listType = new ParameterizedTypeReference<List<Map<String, Object>>>(){};
    private final String url;
    private String username;
    private String password;
    private String authoriser;
    private String accessToken;
    private String clientid;
    static final Map<String, String> environment = System.getenv();

    public WebTemplateInvoker(String url, boolean authorizer) {
        this.url = url;
        if (authorizer) {
            this.setAuthoriser();
        }
    }

    public void setAuthoriser(String authoriser, String username, String password, String clientid) {
        this.authoriser = authoriser;
        this.username = username;
        this.password = password;
        this.clientid = clientid;
        if (authoriser != null && username != null && password != null && clientid != null) {
            System.out.println("*** Setting authoriser, username and password " + authoriser);
            this.accessToken = this.si.getAccessTokenValue(authoriser, username, password, clientid);
        } else {
            System.out.println("*** No authoriser, username or password " + authoriser + " " + username + " " + password);
            this.accessToken = null;
        }
    }

    private String getEnvironmentVariable(Map<String, String> environment, String key) {
        String value = environment.get(key);
        return value;
    }

    public void setAuthoriser() {
        this.setAuthoriser(this.getEnvironmentVariable(environment, "TPL_KEYCLOAK"), this.getEnvironmentVariable(environment, "TPL_KEYCLOAK_USERNAME"), this.getEnvironmentVariable(environment, "TPL_KEYCLOAK_PASSWORD"), this.getEnvironmentVariable(environment, "TPL_KEYCLOAK_CLIENTID_DIRECT"));
    }

    public <IN, OUT> OUT generic_post_and_return(Class<OUT> clazz, IN inputs0, BiFunction<Map<String, Object>, OUT, OUT> completer) {
        List<IN> inputs = Collections.singletonList(inputs0);
        Optional<List<Map<String, Object>>> out1 = this.si.postInstructionsInOut(this.url, inputs, listType, this.accessToken);
        if (!out1.isPresent()) {
            logger.warn("out1 is empty for " + String.valueOf(inputs.getClass()));
            System.out.println("out1 is empty for " + String.valueOf(inputs.getClass()));
            throw new IllegalStateException("out1 is empty for " + String.valueOf(inputs.getClass()));
        }
        List<Map<String, Object>> result0 = out1.get();
        Map<String, Object> result1 = result0.get(0);
        try {
            return completer.apply(result1, clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

