/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.dot.ProvToDot;
import org.openprovenance.prov.model.Attribute;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.model.WasDerivedFrom;
import org.openprovenance.prov.model.exception.UncheckedException;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.TemplatesToDot;

/*
 * Exception performing whole class analysis ignored.
 */
public class TemplatesToDot
extends ProvToDot {
    private static final Logger logger = LogManager.getLogger(TemplatesToDot.class);
    private final List<TemplateQuery.TemplateConnection> templateConnections;
    private final TemplateDispatcher templateDispatcher;
    private final Map<String, Map<String, Map<String, String>>> ioMap;
    private final Map<String, Map<String, String>> baseTypes;
    private final ProvFactory pf;
    private final Map<String, Map<String, List<String>>> successors;
    private final String style;
    private final TemplateQuery templateQuery;
    private final String principal;
    final Map<String, String> provcolors = new /* Unavailable Anonymous Inner Class!! */;
    String headstyle = "invempty";
    String tailstyle = "empty";

    public TemplatesToDot(List<TemplateQuery.TemplateConnection> templateConnections, String style, Map<String, Map<String, String>> baseTypes, Map<String, Map<String, Map<String, String>>> ioMap, TemplateDispatcher templateDispatcher, Map<String, Map<String, List<String>>> successors, ProvFactory pf, TemplateQuery templateQuery, String principal) {
        super(pf);
        this.pf = pf;
        this.templateConnections = templateConnections;
        this.templateDispatcher = templateDispatcher;
        this.ioMap = ioMap;
        this.baseTypes = baseTypes;
        this.successors = successors;
        this.style = style;
        this.templateQuery = templateQuery;
        this.principal = principal;
    }

    public static String createHtmlTable(TemplateInfo templateInfo, List<String> inputsNames, List<String> inputsPorts, List<String> inputsColors, List<String> outputsNames, List<String> outputsPorts, List<String> outputColors) {
        int i;
        StringBuilder html = new StringBuilder();
        html.append("<TABLE BORDER=\"0\" CELLBORDER=\"1\" CELLSPACING=\"0\" CELLPADDING=\"4\">\n");
        html.append("  <TR>\n");
        html.append(String.format("    <TD ROWSPAN=\"3\" HREF=\"%s\"  TARGET=\"_blank\">%s </TD>\n", templateInfo.url, templateInfo.templateId));
        for (i = 0; i < inputsNames.size(); ++i) {
            html.append(String.format("    <TD PORT=\"%s\" BGCOLOR=\"%s\" HREF=\"%s\" TARGET=\"_blank\">%s</TD>\n", inputsPorts.get(i), inputsColors.get(i), templateInfo.url.replace(".svg", "/" + inputsNames.get(i)), inputsNames.get(i)));
        }
        html.append("  </TR>\n");
        html.append("  <TR>\n");
        for (i = 0; i < outputsNames.size(); ++i) {
            html.append(String.format("    <TD PORT=\"%s\" BGCOLOR=\"%s\"  HREF=\"%s\"  TARGET=\"_blank\">%s</TD>\n", outputsPorts.get(i), outputColors.get(i), templateInfo.url.replace(".svg", "/" + outputsNames.get(i)), outputsNames.get(i)));
        }
        html.append("  </TR>\n");
        html.append("</TABLE>");
        return html.toString();
    }

    public void convert(Document graph, OutputStream os, String title) {
        try {
            File dotFile = File.createTempFile("temp", ".dot");
            logger.info("dotFile: " + String.valueOf(dotFile));
            this.convert(graph, new PrintStream(new FileOutputStream(dotFile)), title);
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("dot  -Tsvg " + String.valueOf(dotFile));
            InputStream is = proc.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            logger.info("finished conversion to svg");
            boolean bl = dotFile.delete();
        }
        catch (IOException e) {
            logger.throwing((Throwable)e);
            throw new UncheckedException((Exception)e);
        }
    }

    public void convert(Document ignore, PrintStream out, String title) {
        switch (this.style) {
            case "template": {
                this.convert_template(ignore, out, title);
                break;
            }
            case "prov": {
                this.convert_prov(ignore, out, title);
                break;
            }
            case "entities": {
                this.convert_entities(ignore, out, title);
                break;
            }
            default: {
                throw new UnsupportedOperationException("style not supported: " + this.style);
            }
        }
    }

    public void convert_prov(Document ignore, PrintStream out, String title) {
        HashSet<TemplateQuery.RecordEntry> the_templates = new HashSet<TemplateQuery.RecordEntry>();
        for (Object templateConnection : this.templateConnections) {
            TemplateQuery.RecordEntry entry_in = new TemplateQuery.RecordEntry();
            entry_in.table = ((TemplateQuery.TemplateConnection)templateConnection).in_template;
            entry_in.key = ((TemplateQuery.TemplateConnection)templateConnection).in_id;
            the_templates.add(entry_in);
            TemplateQuery.RecordEntry entry_out = new TemplateQuery.RecordEntry();
            entry_out.table = ((TemplateQuery.TemplateConnection)templateConnection).out_template;
            entry_out.key = ((TemplateQuery.TemplateConnection)templateConnection).out_id;
            the_templates.add(entry_out);
        }
        LinkedList the_records = new LinkedList();
        for (TemplateQuery.RecordEntry linked_record : the_templates) {
            Integer simple = linked_record.key;
            List simple_records = this.templateQuery.querySimple(linked_record.table, simple, false, this.principal);
            the_records.addAll(simple_records);
        }
        Document result = this.templateQuery.constructDocument(the_records);
        super.convert(result, out, title);
    }

    public void convert_entities(Document ignore, PrintStream out, String title) {
        HashMap<QualifiedName, QualifiedName> map = new HashMap<QualifiedName, QualifiedName>();
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            QualifiedName outQn = this.qualifiedPortNameAsQn(templateConnection.out_template, String.valueOf(templateConnection.out_id), templateConnection.out_property);
            QualifiedName inQn = this.qualifiedPortNameAsQn(templateConnection.in_template, String.valueOf(templateConnection.in_id), templateConnection.in_property);
            map.put(inQn, outQn);
        }
        Document doc = this.pf.newDocument();
        HashSet<QualifiedName> seen = new HashSet<QualifiedName>();
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            String template = templateConnection.in_template;
            String templateId = String.valueOf(templateConnection.in_id);
            String property = templateConnection.in_property;
            List next = (List)((Map)this.successors.get(template)).get(property);
            if (next == null) continue;
            for (String n : next) {
                QualifiedName older = (QualifiedName)map.get(this.qualifiedPortNameAsQn(template, templateId, property));
                QualifiedName newer = this.qualifiedPortNameAsQn(template, templateId, n);
                if (!seen.contains(older)) {
                    seen.add(older);
                    doc.getStatementOrBundle().add(this.pf.newEntity(older));
                }
                if (!seen.contains(newer)) {
                    seen.add(newer);
                    doc.getStatementOrBundle().add(this.pf.newEntity(newer));
                }
                LinkedList<Attribute> attrs = new LinkedList<Attribute>();
                attrs.add(this.pf.newAttribute(this.pf.newQualifiedName("http://openprovenance.org/provtoolbox/dot/ns#", "style", "dot"), (Object)"dashed", this.pf.getName().XSD_STRING));
                WasDerivedFrom edge = this.pf.newWasDerivedFrom(null, newer, older, null, null, null, attrs);
                doc.getStatementOrBundle().add(edge);
            }
        }
        super.convert(doc, out, title);
    }

    public void convert_template(Document doc, PrintStream out, String title) {
        if (title != null) {
            this.name = title;
        }
        this.prelude(doc, out);
        HashSet<TemplateInfo> allTemplates = new HashSet<TemplateInfo>();
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            allTemplates.add(TemplateInfo.of((String)templateConnection.in_template, (String)this.templateName(templateConnection.in_template, templateConnection.in_id), (String)this.url(templateConnection.in_template, templateConnection.in_id)));
            allTemplates.add(TemplateInfo.of((String)templateConnection.out_template, (String)this.templateName(templateConnection.out_template, templateConnection.out_id), (String)this.url(templateConnection.out_template, templateConnection.out_id)));
        }
        Map inputs = (Map)this.ioMap.get("input");
        Map outputs = (Map)this.ioMap.get("output");
        for (TemplateInfo templateInfo : allTemplates) {
            String template = templateInfo.template;
            String templateId = templateInfo.templateId;
            Map templateBaseTypes = (Map)this.baseTypes.get(template);
            ArrayList inputsNames = new ArrayList(((Map)inputs.get(template)).keySet());
            List inputPorts = inputsNames.stream().map(s -> this.portName(template, templateId, s)).collect(Collectors.toList());
            List inputsColors = inputsNames.stream().map(s -> (String)this.provcolors.get(templateBaseTypes.get(s))).collect(Collectors.toList());
            ArrayList outputsNames = new ArrayList(((Map)outputs.get(template)).keySet());
            List outputsPorts = outputsNames.stream().map(s -> this.portName(template, templateId, s)).collect(Collectors.toList());
            List outputsColors = outputsNames.stream().map(s -> (String)this.provcolors.get(templateBaseTypes.get(s))).collect(Collectors.toList());
            String html = TemplatesToDot.createHtmlTable((TemplateInfo)templateInfo, inputsNames, inputPorts, inputsColors, outputsNames, outputsPorts, outputsColors);
            this.emitTemplate(template, templateId, html, out);
        }
        for (TemplateQuery.TemplateConnection templateConnection : this.templateConnections) {
            this.emitEdge(this.qualifiedPortName(templateConnection.in_template, this.templateName(templateConnection.in_template, templateConnection.in_id), templateConnection.in_property), this.qualifiedPortName(templateConnection.out_template, this.templateName(templateConnection.out_template, templateConnection.out_id), templateConnection.out_property), out);
        }
        this.postlude(doc, out);
        out.close();
    }

    private void emitEdge(String source, String destination, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(source).append(":n");
        sb.append(" -> ");
        sb.append(destination).append(":s");
        sb.append("[dir=\"both\", arrowhead=\"").append(this.headstyle).append("\", arrowtail=\"").append(this.tailstyle).append("\"]");
        sb.append(";\n");
        out.println(sb.toString());
    }

    private String portName(String template, String templateId, String property) {
        return template + "_" + templateId + "_" + property;
    }

    private String qualifiedPortName(String template, String templateId, String property) {
        return templateId + ":" + this.portName(template, templateId, property);
    }

    private QualifiedName qualifiedPortNameAsQn(String template, String templateId, String property) {
        return this.pf.newQualifiedName("/ptl/provapi/template/", template + "/" + templateId + "/" + property, "ex");
    }

    public void emitTemplate(String template, String templateId, String htmlTable, PrintStream out) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("node [shape=plaintext]\n");
        sb.append(templateId);
        sb.append(" [label=<");
        sb.append(htmlTable);
        sb.append(">];\n");
        out.println(sb.toString());
    }

    private String templateName(String template, Integer id) {
        return template + "_" + id;
    }

    private String livePrefix(String relation) {
        return "/ptl/provapi/live/" + relation + "/";
    }

    private String urlPrefix(String template) {
        return "/ptl/provapi/template/" + template + "/";
    }

    private String url(String template, Integer id) {
        return "/ptl/provapi/template/" + template + "/" + id + ".svg";
    }
}

