/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.model.StatementOrBundle;
import org.openprovenance.prov.service.Querier;
import org.openprovenance.prov.service.RelationMapping;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;

public class RelationMapping {
    private static final Logger logger = LogManager.getLogger(RelationMapping.class);
    private final Querier querier;
    ExecutorService executor = Executors.newFixedThreadPool(3);
    private final TemplateQuery templateQuery;
    private final TemplateDispatcher templateDispatcher;

    public RelationMapping(TemplateQuery templateQuery, TemplateDispatcher templateDispatcher, Querier querier) {
        this.templateQuery = templateQuery;
        this.templateDispatcher = templateDispatcher;
        this.querier = querier;
    }

    public void mapGraphToRelations(String template, int id, Object[] record) {
        this.executor.execute(() -> {
            logger.debug("Template: " + template + " " + id);
            Map templateRelations = (Map)this.templateDispatcher.getRelations0().get(template);
            String[] foreignTables = (String[])this.templateDispatcher.getForeignTables().get(template);
            LinkedList<BiConsumer> queries = new LinkedList<BiConsumer>();
            if (templateRelations != null) {
                for (String property : templateRelations.keySet()) {
                    Map propertyRelations;
                    BiConsumer insertForRelations = this.createInsertForRelations(template, id, record, property, propertyRelations = (Map)templateRelations.get(property), foreignTables);
                    if (insertForRelations == null) continue;
                    queries.add(insertForRelations);
                }
            }
            queries.forEach(q -> this.executor.execute(() -> this.querier.do_statements(null, null, q)));
            logger.debug("COMPLETED for " + template + " " + id);
        });
    }

    BiConsumer<StringBuilder, Object> createInsertForRelations(String template, int id, Object[] record, String relation, Map<String, int[]> propertyRelations, String[] foreignTables) {
        Map<String, List> rels = propertyRelations.keySet().stream().collect(Collectors.toMap(k -> k, k -> Arrays.stream((int[])propertyRelations.get(k)).boxed().collect(Collectors.toList())));
        switch (1.$SwitchMap$org$openprovenance$prov$model$StatementOrBundle$Kind[StatementOrBundle.Kind.valueOf((String)relation).ordinal()]) {
            case 1: {
                return this.composeQueryDerivation(template, id, record, relation, foreignTables, rels);
            }
            case 2: {
                return this.composeQueryGeneration(template, id, record, relation, foreignTables, rels);
            }
            case 3: {
                return this.composeQueryUsage(template, id, record, relation, foreignTables, rels);
            }
            case 4: {
                return this.composeQueryAssociation(template, id, record, relation, foreignTables, rels);
            }
            case 5: {
                return this.composeQueryDelegation(template, id, record, relation, foreignTables, rels);
            }
            case 6: {
                return this.composeQuerySpecialization(template, id, record, relation, foreignTables, rels);
            }
            case 7: {
                return this.composeQueryMembership(template, id, record, relation, foreignTables, rels);
            }
        }
        return null;
    }

    private BiConsumer<StringBuilder, Object> composeQueryMembership(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_mem = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (collection, collection_rel, entity, entity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_mem;
    }

    private BiConsumer<StringBuilder, Object> composeQuerySpecialization(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_spe = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (specificEntity, specificEntity_rel, generalEntity, generalEntity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_spe;
    }

    private BiConsumer<StringBuilder, Object> composeQueryDelegation(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_aobo = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (delegate, delegate_rel, responsible, responsible_rel, activity, activity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(2)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(2)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_aobo;
    }

    private BiConsumer<StringBuilder, Object> composeQueryAssociation(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_waw = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (activity, activity_rel, agent, agent_rel, plan, plan_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(2)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(2)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_waw;
    }

    private BiConsumer<StringBuilder, Object> composeQueryUsage(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_use = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (activity, activity_rel, entity, entity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_use;
    }

    private BiConsumer<StringBuilder, Object> composeQueryGeneration(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_gen = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (entity, entity_rel, activity, activity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_gen;
    }

    private BiConsumer<StringBuilder, Object> composeQueryDerivation(String template, int id, Object[] record, String relation, String[] foreignTables, Map<String, List<Integer>> rels) {
        BiConsumer<StringBuilder, Object> composeQuery_wdf = (sb, data) -> {
            sb.append("\nINSERT INTO\n  __");
            sb.append(relation);
            sb.append(" (generatedEntity, generatedEntity_rel, usedEntity, usedEntity_rel, activity, activity_rel, template, template_id, rel) VALUES\n");
            boolean first = true;
            for (String relId : rels.keySet()) {
                List rels1 = (List)rels.get(relId);
                if (first) {
                    first = false;
                } else {
                    sb.append(",\n");
                }
                sb.append("  (");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(0)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(1)));
                sb.append(",");
                sb.append(this.getEntryIfNotMinus1(record, (Integer)rels1.get(2)));
                sb.append(",");
                sb.append(this.getTableIfNotMinus1((Object[])foreignTables, (Integer)rels1.get(2)));
                sb.append(",'").append(template).append("',").append(id);
                sb.append(",'");
                sb.append(relId);
                sb.append("')");
            }
            sb.append(";\n");
        };
        return composeQuery_wdf;
    }

    private String getEntryIfNotMinus1(Object[] record, Integer in) {
        if (in == null || in == -1) {
            return "null";
        }
        Object o = record[in];
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    private String getTableIfNotMinus1(Object[] record, Integer in) {
        if (in == null || in == -1) {
            return "";
        }
        Object o = record[in];
        if (o == null) {
            return "''";
        }
        return "'" + o.toString() + "'";
    }
}

