/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.configuration.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
public class Storage {
    public static final String SQL_FILE_NAME;
    static Logger logger;
    static final String version;
    public static final String PROV_SUSTAINABILITY_WEBAPP_CONFIG_PROPERTIES = "/properties/prov-template-library.webapp.config.properties";

    public Connection setup(String host, String username, String password) {
        String url = "jdbc:postgresql://" + host + ":5432/templates?sslmode=disable";
        Properties props = new Properties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        props.setProperty("ssl", "false");
        System.out.println("DB url: " + url);
        System.out.println("DB props: " + String.valueOf(props));
        try {
            Class.forName("org.postgresql.Driver");
            Connection conn = DriverManager.getConnection(url, props);
            return conn;
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getStringFromClasspath(Class<?> clazz, String propFileName) {
        try {
            return IOUtils.resourceToString((String)propFileName, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean initializeDB(Connection conn) throws SQLException {
        String statements = Storage.getStringFromClasspath(this.getClass(), (String)SQL_FILE_NAME);
        return this.executeStatements(conn, statements);
    }

    public boolean executeStatements(Connection conn, String statements) throws SQLException {
        try (Statement st = conn.createStatement();){
            boolean bl = st.execute(statements);
            return bl;
        }
    }

    public void executeQuery(Connection conn) throws SQLException {
        String statements = Storage.getStringFromClasspath(this.getClass(), (String)SQL_FILE_NAME);
        this.executeQuery(conn, statements);
    }

    public ResultSet executeQuery(Connection conn, String statements) throws SQLException {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery(statements);
        return rs;
    }

    public Function<String, ResultSet> getQuerier(Connection conn) {
        return statement -> {
            try {
                return this.executeQuery(conn, statement);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    public static void displayResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        StringBuilder sb = new StringBuilder();
        while (resultSet.next()) {
            for (int i = 1; i <= columnsNumber; ++i) {
                if (i > 1) {
                    sb.append(",  ");
                }
                String columnValue = resultSet.getString(i);
                sb.append(columnValue).append(" ").append(rsmd.getColumnName(i));
            }
            sb.append("\n");
        }
        logger.info(sb.toString());
        System.out.println(sb.toString());
    }

    public void isSingleRow(ResultSet rs) throws SQLException {
        int rowcount = 0;
        if (rs.last()) {
            rowcount = rs.getRow();
            rs.beforeFirst();
        }
        if (rowcount != 1) {
            throw new SQLException("Single row result was expected for query ");
        }
    }

    static {
        logger = LogManager.getLogger(Storage.class);
        Properties properties = Configuration.getPropertiesFromClasspath(Storage.class, (String)"/properties/prov-template-library.webapp.config.properties");
        version = properties.getProperty("project.version");
        SQL_FILE_NAME = "/META-INF/resources/webjars/prov-template-library/" + version + "/sql/prov-template-library-plead.sql";
        logger.info("SQL file: " + SQL_FILE_NAME);
    }
}

