/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.client.ProcessorArgsInterface;
import org.openprovenance.prov.client.RecordsProcessorInterface;
import org.openprovenance.prov.model.BeanTraversal;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ModelConstructor;
import org.openprovenance.prov.model.QualifiedName;
import org.openprovenance.prov.scala.iface.Explainer;
import org.openprovenance.prov.scala.iface.Narrator;
import org.openprovenance.prov.scala.iface.XFactory;
import org.openprovenance.prov.scala.immutable.ProvFactory;
import org.openprovenance.prov.scala.narrator.XConfig;
import org.openprovenance.prov.service.TemplateDispatcher;
import org.openprovenance.prov.service.TemplateQuery;
import org.openprovenance.prov.service.TemplateService;
import org.openprovenance.prov.service.XplainerConfig;
import org.openprovenance.prov.service.core.ServiceUtils;
import org.openprovenance.prov.service.dispatch.EnactCsvRecords;
import org.openprovenance.prov.service.readers.TemplatesVizConfig;
import org.openprovenance.prov.template.library.plead.Plead_trainingBuilder;
import org.openprovenance.prov.template.library.plead.Plead_trainingBuilderInterface;
import org.openprovenance.prov.template.library.plead.sql.access_control.BeanEnactor4;
import org.openprovenance.prov.template.library.plead.sql.access_control.SqlCompositeBeanEnactor4;
import org.openprovenance.prov.template.log2prov.FileBuilder;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters;

public class TemplateLogic {
    public static final String HTTP_HEADER_CONTENT_PROV_HASH = "PROV-Hash";
    public static final String HTTP_HEADER_LOCATION = "Location";
    public static final String HTTP_HEADER_ACCEPT_PROV_HASH = "Accept-PROV-hash";
    public static final String HTTP_HEADER_ACCEPT_PROV_EXPLANATION = "Accept-PROV-explanation";
    static Logger logger = LogManager.getLogger(TemplateLogic.class);
    private final org.openprovenance.prov.vanilla.ProvFactory pf;
    private final TemplateDispatcher templateDispatcher;
    private final java.util.Map<String, FileBuilder> documentBuilderDispatcher;
    private final ServiceUtils utils;
    private final ObjectMapper om;
    private final SqlCompositeBeanEnactor4 sqlCompositeBeanEnactor;
    private final EnactCsvRecords<Object> enactCsvRecords = new EnactCsvRecords();
    private final TemplateQuery templateQuery;
    private final java.util.Map<String, java.util.Map<String, Set<String>>> typeAssignment;
    private final java.util.Map<String, java.util.Map<String, java.util.List<String>>> successors;
    Base64.Encoder encoder = Base64.getEncoder();
    final org.openprovenance.prov.vanilla.ProvFactory pFactoryS = ProvFactory.pf();
    final XFactory factory = new XFactory();
    final Explainer explainer = this.factory.makeExplainer();
    final Narrator narrator = this.factory.makeNarrator();

    public TemplateLogic(org.openprovenance.prov.vanilla.ProvFactory pf, TemplateQuery templateQuery, TemplateDispatcher templateDispatcher, Object o1, java.util.Map<String, FileBuilder> documentBuilderDispatcher, ServiceUtils utils, ObjectMapper om, SqlCompositeBeanEnactor4 sqlCompositeBeanEnactor, java.util.Map<String, java.util.Map<String, Set<String>>> typeAssignment, java.util.Map<String, java.util.Map<String, java.util.List<String>>> successors) {
        this.pf = pf;
        this.templateDispatcher = templateDispatcher;
        this.documentBuilderDispatcher = documentBuilderDispatcher;
        this.utils = utils;
        this.om = om;
        om.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.sqlCompositeBeanEnactor = sqlCompositeBeanEnactor;
        this.templateQuery = templateQuery;
        this.typeAssignment = typeAssignment;
        this.successors = successors;
    }

    public java.util.List<Object> processIncomingJson(java.util.List<java.util.Map<String, Object>> entries) {
        String isA = (String)entries.get(0).get("isA");
        LinkedList<Object> recordsResult = new LinkedList<Object>();
        java.util.Map properties = this.templateDispatcher.getPropertyOrder();
        java.util.Map enactorConverters = this.templateDispatcher.getEnactorConverter();
        java.util.Map compositeEnactorConverters = this.templateDispatcher.getCompositeEnactorConverter();
        String[] props = (String[])properties.get(isA);
        ProcessorArgsInterface enactor = (ProcessorArgsInterface)enactorConverters.get(isA);
        if (enactor != null) {
            for (java.util.Map<String, Object> entry : entries) {
                Object[] array = this.convertToArray(entry, props);
                recordsResult.add(enactor.process(array));
            }
        } else {
            for (java.util.Map<String, Object> composite : entries) {
                LinkedList<Object[]> objects = new LinkedList<Object[]>();
                Object[] array = this.convertToArray(composite, props);
                objects.add(array);
                for (java.util.Map composee : (java.util.List)composite.get("__elements")) {
                    String is2A = (String)composee.get("isA");
                    String[] props2 = (String[])properties.get(is2A);
                    Object[] array2 = this.convertToArray(composee, props2);
                    objects.add(array2);
                }
                System.out.println("need composite converter for " + isA);
                System.out.println("need composite converter for " + String.valueOf(compositeEnactorConverters));
                RecordsProcessorInterface compositeEnactor = (RecordsProcessorInterface)compositeEnactorConverters.get(isA);
                System.out.println("found composite converter for " + String.valueOf(compositeEnactor));
                Object res = compositeEnactor.process(objects);
                this.debugDisplay("found result ", res);
                recordsResult.add(res);
            }
        }
        return recordsResult;
    }

    public Object[] convertToArray(java.util.Map<String, Object> entry, String[] props) {
        Object[] array = new Object[props.length];
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i];
            array[i] = entry.getOrDefault(prop, null);
        }
        return array;
    }

    private void debugDisplay(String msg, Object object) {
        try {
            System.out.println(msg + this.om.writeValueAsString(object));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public java.util.List<Object> processIncomingCsv(CSVParser csv) {
        java.util.List collection = csv.getRecords();
        java.util.Map enactors = this.templateDispatcher.getEnactorConverter();
        java.util.Map<String, ProcessorArgsInterface> enactors2 = enactors.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, e -> (ProcessorArgsInterface)e.getValue()));
        java.util.Map compositeEnactors = this.templateDispatcher.getCompositeEnactorConverter();
        java.util.Map<String, RecordsProcessorInterface> compositeEnactors2 = compositeEnactors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (RecordsProcessorInterface)e.getValue()));
        java.util.List newRecords = this.enactCsvRecords.process((Collection)collection, enactors2, compositeEnactors2);
        return newRecords;
    }

    @NotNull
    public StreamingOutput streamOutRecordsToCSV(java.util.List<Object> newRecords) {
        return out -> newRecords.forEach(record -> {
            try {
                out.write(((String)record).getBytes(StandardCharsets.UTF_8));
                out.write(10);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void generateViz(TemplatesVizConfig config, String principal, OutputStream out) {
        this.typeAssignment.entrySet().removeIf(entry -> entry.getValue() == null || ((java.util.Map)entry.getValue()).isEmpty());
        java.util.Map<String, java.util.Map> baseTypes = this.typeAssignment.keySet().stream().collect(Collectors.toMap(tpl -> tpl, tpl -> ((java.util.Map)this.typeAssignment.get(tpl)).keySet().stream().collect(Collectors.toMap(var -> var, var -> this.preferredType((Set)((java.util.Map)this.typeAssignment.get(tpl)).get(var))))));
        logger.info("baseTypes " + String.valueOf(baseTypes));
        this.templateQuery.generateViz(config.id, config.template, config.property, config.style, baseTypes, principal, out);
    }

    private int colorValue(String s) {
        if (s == null) {
            return 0;
        }
        switch (s) {
            case "http://www.w3.org/ns/prov#Entity": {
                return 1;
            }
            case "http://www.w3.org/ns/prov#Activity": {
                return 2;
            }
            case "http://www.w3.org/ns/prov#Agent": {
                return 3;
            }
        }
        return 0;
    }

    private String preferredType(Set<String> value) {
        return value.stream().max(Comparator.comparingInt(arg_0 -> this.colorValue(arg_0))).orElse("none");
    }

    private java.util.Map<String, Set<String>> plead_trainingLevel0() {
        String[] propertyOrder = (String[])this.templateDispatcher.getPropertyOrder().get("plead_training");
        Plead_trainingBuilder plead_trainingBuilder = (Plead_trainingBuilder)this.documentBuilderDispatcher.get("plead_training");
        Object[] record2 = (Object[])plead_trainingBuilder.make((Plead_trainingBuilderInterface)plead_trainingBuilder.getTypedRecord());
        HashMap knownTypeMap = new HashMap();
        plead_trainingBuilder.make((Plead_trainingBuilderInterface)plead_trainingBuilder.getTypeManager(knownTypeMap, new HashMap(), new HashMap(), new HashMap(), new HashMap()));
        HashMap<String, Set<String>> propertyMap = new HashMap<String, Set<String>>();
        for (int i = 0; i < record2.length; ++i) {
            String property = propertyOrder[i];
            Object value = record2[i];
            if (!(value instanceof QualifiedName)) continue;
            propertyMap.put(property, (Set)knownTypeMap.get((QualifiedName)value));
        }
        java.util.Map propertyMap2 = (java.util.Map)this.typeAssignment.get("plead_training");
        System.out.println("propertyMap " + String.valueOf(propertyMap));
        System.out.println("propertyMap2 " + String.valueOf(propertyMap2));
        return propertyMap;
    }

    public java.util.List<TemplateQuery.RecordEntry2> generateLiveNode(String relation, Integer id, String principal) {
        java.util.List records = this.templateQuery.queryTemplatesRecordsById(relation, id, Integer.valueOf(30), principal);
        return records;
    }

    public Object submitPostProcessing(int id, String template) {
        logger.info("postProcessing " + id + " " + template);
        String principal = BeanEnactor4.getPrincipal();
        java.util.List records = this.templateQuery.query(template, Integer.valueOf(id), false, principal);
        logger.debug("PROV_API " + TemplateService.provAPI);
        logger.info("records " + records.size() + " " + records.stream().map(Arrays::toString).collect(Collectors.joining(",")));
        if (!records.isEmpty()) {
            if (records.size() > 1) {
                java.util.Map hash = this.templateQuery.computeHash(template, id, records);
                this.templateQuery.updateHash(template, id, hash, principal);
                logger.info("update hash for " + id + " " + template + ": " + String.valueOf(hash));
                ((java.util.Map)TemplateService.headerInfo.get()).put(HTTP_HEADER_CONTENT_PROV_HASH, this.getContentProvHash(hash));
            } else {
                Object[] record = (Object[])records.get(0);
                java.util.Map hash = this.templateQuery.computeHash(template, id, record);
                this.templateQuery.getRelationMapping().mapGraphToRelations(template, id, record);
                this.templateQuery.updateHash(template, id, hash, principal);
                logger.info("update hash for " + id + " " + template + ": " + String.valueOf(hash));
                ((java.util.Map)TemplateService.headerInfo.get()).put(HTTP_HEADER_CONTENT_PROV_HASH, this.getContentProvHash(hash));
            }
            ((java.util.Map)TemplateService.headerInfo.get()).put(HTTP_HEADER_LOCATION, TemplateService.provAPI + "/template/" + template + "/" + id);
        }
        return null;
    }

    private String getContentProvHash(java.util.Map<String, String> hash) {
        return this.encoder.encodeToString(this.templateQuery.makeHashRecord(hash).getBytes());
    }

    public java.util.Map<String, String> generateExplanation(String template, Integer id, String headerAcceptExplanation, Document doc) {
        org.openprovenance.prov.scala.immutable.Document sdoc = (org.openprovenance.prov.scala.immutable.Document)new BeanTraversal((ModelConstructor)this.pFactoryS, (org.openprovenance.prov.model.ProvFactory)this.pFactoryS).doAction(doc);
        XplainerConfig config = new XplainerConfig();
        scala.collection.immutable.Map result = this.narrator.getTextOnly(this.explainer.explain(sdoc, (XConfig)config));
        HashMap<String, String> javaResult = new HashMap<String, String>();
        for (Map.Entry entry : CollectionConverters.MapHasAsJava((Map)result).asJava().entrySet()) {
            javaResult.put((String)entry.getKey(), ((List)entry.getValue()).mkString("\n"));
        }
        return javaResult;
    }
}

