/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import io.swagger.v3.jaxrs2.integration.resources.AcceptHeaderOpenApiResource;
import io.swagger.v3.jaxrs2.integration.resources.OpenApiResource;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.interceptors.CorsFilter;
import org.openprovenance.prov.configuration.Configuration;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.ProvFactory;
import org.openprovenance.prov.model.interop.ApiUriFragments;
import org.openprovenance.prov.service.core.PostService;
import org.openprovenance.prov.service.core.ResourcesService;
import org.openprovenance.prov.service.core.ServiceUtilsConfig;
import org.openprovenance.prov.service.core.config.StorageConfiguration;
import org.openprovenance.prov.service.core.writers.NodeMessageBodyWriter;
import org.openprovenance.prov.service.core.writers.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.readers.JsonOrCsvMessageBodyReader;
import org.openprovenance.prov.service.readers.SearchConfigMessageBodyReader;
import org.openprovenance.prov.service.readers.TableKeyListMessageBodyReader;
import org.openprovenance.prov.service.readers.TemplatesVizConfigMessageBodyReader;
import org.openprovenance.prov.service.translation.TemplateService;
import org.openprovenance.prov.service.translation.TranslationService;
import org.openprovenance.prov.service.translation.storage.StorageSetup;

@OpenAPIDefinition(info=@Info(title="Provenance API", version="0.0", description="An API to process provenance", license=@License(name="MIT License for ProvToolbox", url="https://github.com/lucmoreau/ProvToolbox/blob/master/license.txt"), contact=@Contact(url="https://openprovenance.org/", name="Luc Moreau", email="provenance@kcl.ac.uk")), tags={@Tag(name="documents", description="provenance documents", externalDocs=@ExternalDocumentation(description="docs desc")), @Tag(name="template", description="provenance templates", externalDocs=@ExternalDocumentation(description="docs desc")), @Tag(name="validation", description="provenance validation", externalDocs=@ExternalDocumentation(description="docs desc")), @Tag(name="resources", description="static resources", externalDocs=@ExternalDocumentation(description="docs desc")), @Tag(name="random", description="provenance random generation", externalDocs=@ExternalDocumentation(description="docs desc")), @Tag(name="view", description="browsing interface", externalDocs=@ExternalDocumentation(description="docs desc"))}, externalDocs=@ExternalDocumentation(description="definition docs desc"), security={@SecurityRequirement(name="req 1", scopes={"a", "b"}), @SecurityRequirement(name="req 2", scopes={"b", "c"})}, servers={@Server(description="production", url="https://openprovenance.org/services/"), @Server(description="dev", url="http://localhost:{port}/{context}/", variables={@ServerVariable(name="port", description="service port", defaultValue="7071", allowableValues={"7070", "7071", "8080"}), @ServerVariable(name="context", description="service context", defaultValue="service", allowableValues={"service", "context"})})})
@ApplicationPath(value="/provapi")
public class ProvapiApplication
extends Application
implements ApiUriFragments {
    static Logger logger = LogManager.getLogger(ProvapiApplication.class);
    private final Set<Object> singletons = new HashSet();
    public final StorageSetup storageSetup = new StorageSetup();

    public ProvapiApplication() {
        logger.info("ProvapiApplication constructor ... start");
        InteropFramework intF = new InteropFramework();
        ProvFactory factory = InteropFramework.getDefaultFactory();
        StorageConfiguration sc = StorageConfiguration.loadConfiguration();
        ServiceUtilsConfig config = this.storageSetup.makeConfig(factory, sc);
        PostService ps = new PostService(config);
        ps.addToConfiguration("storage.config", (Object)config.configuration);
        ps.addToConfiguration("cli.config", (Object)intF.getConfig());
        ps.addToConfiguration("version", (Object)Configuration.toolboxVersion);
        ps.addToConfiguration("long.version", (Object)Configuration.longToolboxVersion);
        this.singletons.add(ps);
        this.singletons.add(new TranslationService(ps));
        this.singletons.add(new TemplateService(ps));
        this.singletons.add(new org.openprovenance.prov.service.TemplateService(ps));
        this.singletons.add(new ResourcesService());
        this.singletons.add(new OpenApiResource());
        this.singletons.add(new AcceptHeaderOpenApiResource());
        this.singletons.add(new JsonOrCsvMessageBodyReader());
        this.singletons.add(new TableKeyListMessageBodyReader());
        this.singletons.add(new TemplatesVizConfigMessageBodyReader());
        this.singletons.add(new SearchConfigMessageBodyReader());
        this.singletons.add(new VanillaDocumentMessageBodyWriter((ProvDocumentWriter)new InteropFramework()));
        this.singletons.add(new NodeMessageBodyWriter());
        CorsFilter corsFilter = new CorsFilter();
        corsFilter.getAllowedOrigins().add("*");
        corsFilter.setAllowedMethods("OPTIONS, GET, POST, DELETE, PUT, PATCH");
        this.singletons.add(corsFilter);
        logger.info("ProvapiApplication constructor ... completion");
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

