/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.translator;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Activity;
import org.openprovenance.prov.model.DateTimeOption;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.interop.ApiUriFragments;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.service.ValidationReportMessageBodyReader;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.core.readers.VanillaDocumentMessageBodyReader;
import org.openprovenance.prov.service.core.writers.DocumentMessageBodyWriter;
import org.openprovenance.prov.service.translator.TranslateIT;
import org.openprovenance.prov.validation.report.ValidationReport;
import org.openprovenance.prov.vanilla.ProvFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class DateIT
extends TestCase
implements ApiUriFragments {
    static Logger logger = LogManager.getLogger(DateIT.class);
    static final ClientConfig config = new ClientConfig(TranslateIT.class);
    final org.openprovenance.prov.model.ProvFactory pf = new ProvFactory();
    final InteropFramework intF = new InteropFramework(this.pf);
    public static HashMap<String, String> table = new HashMap();

    public void testTranslationWithDate1() {
        this.doTestAction("src/test/resources/dates/date_with_tz_offset.provn", "provn", 1);
    }

    public void testTranslationWithDate2() {
        this.doTestAction("src/test/resources/dates/date_with_tz_offset.jsonld", "jsonld", 1);
    }

    public void testTranslationWithDate3() {
        this.doTestAction("src/test/resources/dates/date_with_tz_offset.json", "json", 1);
    }

    public void testTranslationWithDate4() {
        this.doTestAction("src/test/resources/dates/date_with_tz_offset.provx", "provx", 1);
    }

    public void testTranslationWithDate1b() {
        this.doTestAction("src/test/resources/dates/date_with_tz_offset.provn", "provn", 2);
    }

    public void doTestAction(String file, String extension, int postKind) {
        String location;
        logger.info(DateIT.escapeGreen("DateIt.testAction: " + file + " " + postKind));
        logger.debug("*** action 1");
        switch (postKind) {
            case 1: {
                location = this.doPostStatementsWithForm(DateIT.config.formURL, file, extension);
                break;
            }
            case 2: {
                location = this.doPostStatementsInProvEncoding(DateIT.config.postURL, file, extension);
                break;
            }
            default: {
                throw new UnsupportedOperationException("postKind " + postKind + " not supported");
            }
        }
        DateIT.assertNotNull((String)"location", (Object)location);
        location = location.replace("." + extension, "");
        table.put("location", location);
        logger.info("location " + location);
        String location_report_json = this.contentNegotiation(location, "application/json", "location_json");
        String location_report_jsonld = this.contentNegotiation(location, "application/ld+json", "location_jsonld");
        String location_report_provn = this.contentNegotiation(location, "text/provenance-notation", "location_provn");
        String location_report_provx = this.contentNegotiation(location, "application/provenance+xml", "location_provx");
        logger.info("location_report_json " + location_report_json);
        logger.info("location_report_jsonld " + location_report_jsonld);
        logger.info("location_report_provn " + location_report_provn);
        logger.info("location_report_provx " + location_report_provx);
        logger.info("Reading document with PRESERVE ...");
        Document doc1 = this.readDocument(location, "application/ld+json", ".jsonld", DateTimeOption.PRESERVE, null);
        Document doc2 = this.readDocument(location, "text/provenance-notation", ".provn", DateTimeOption.PRESERVE, null);
        Document doc3 = this.readDocument(location, "application/provenance+xml", ".provx", DateTimeOption.PRESERVE, null);
        Document doc4 = this.readDocument(location, "application/json", ".json", DateTimeOption.PRESERVE, null);
        this.checkDates_preserve(doc1, "preserve: jsonld");
        this.checkDates_preserve(doc2, "preserve: provn");
        this.checkDates_preserve(doc3, "preserve: provx");
        this.checkDates_preserve(doc4, "preserve: json");
        logger.info("Reading document with UTC ...");
        doc1 = this.readDocument(location, "application/ld+json", ".jsonld", DateTimeOption.UTC, null);
        doc2 = this.readDocument(location, "text/provenance-notation", ".provn", DateTimeOption.UTC, null);
        doc3 = this.readDocument(location, "application/provenance+xml", ".provx", DateTimeOption.UTC, null);
        doc4 = this.readDocument(location, "application/json", ".json", DateTimeOption.UTC, null);
        this.checkDates_utc(doc1, "UTC: jsonld");
        this.checkDates_utc(doc2, "UTC: provn");
        this.checkDates_utc(doc3, "UTC: provx");
        this.checkDates_utc(doc4, "UTC: json");
        logger.info("Reading document with TIMEZONE Japan ...");
        doc1 = this.readDocument(location, "application/ld+json", ".jsonld", DateTimeOption.TIMEZONE, "Japan");
        doc2 = this.readDocument(location, "text/provenance-notation", ".provn", DateTimeOption.TIMEZONE, "Japan");
        doc3 = this.readDocument(location, "application/provenance+xml", ".provx", DateTimeOption.TIMEZONE, "Japan");
        doc4 = this.readDocument(location, "application/json", ".json", DateTimeOption.TIMEZONE, "Japan");
        this.checkDates_japan(doc1, "UTC: jsonld");
        this.checkDates_japan(doc2, "UTC: provn");
        this.checkDates_japan(doc3, "UTC: provx");
        this.checkDates_japan(doc4, "UTC: json");
    }

    private void checkDates_preserve(Document document, String title) {
        DateIT.assertEquals((String)(title + " activity start"), (String)((Activity)document.getStatementOrBundle().get(0)).getStartTime().toXMLFormat(), (String)"2023-09-08T20:12:45.109-04:00");
        DateIT.assertEquals((String)(title + " activity end"), (String)((Activity)document.getStatementOrBundle().get(0)).getEndTime().toXMLFormat(), (String)"2023-10-15T20:35:06.793-02:00");
    }

    private void checkDates_utc(Document document, String title) {
        DateIT.assertEquals((String)(title + " activity start"), (String)((Activity)document.getStatementOrBundle().get(0)).getStartTime().toXMLFormat(), (String)"2023-09-09T00:12:45.109Z");
        DateIT.assertEquals((String)(title + " activity end"), (String)((Activity)document.getStatementOrBundle().get(0)).getEndTime().toXMLFormat(), (String)"2023-10-15T22:35:06.793Z");
    }

    private void checkDates_japan(Document document, String title) {
        DateIT.assertEquals((String)(title + " activity start"), (String)((Activity)document.getStatementOrBundle().get(0)).getStartTime().toXMLFormat(), (String)"2023-09-09T09:12:45.109+09:00");
        DateIT.assertEquals((String)(title + " activity end"), (String)((Activity)document.getStatementOrBundle().get(0)).getEndTime().toXMLFormat(), (String)"2023-10-16T07:35:06.793+09:00");
    }

    private String contentNegotiation(String location, String media, String title) {
        Response resp = this.getResource(location, media);
        logger.debug("response status " + resp.getStatus());
        String location_media = (String)resp.getHeaders().getFirst((Object)"Location");
        logger.info(title + " " + location_media);
        DateIT.assertNotNull((String)(title + " is null"), (Object)location_media);
        return location_media;
    }

    public Document readDocument(String location, String media, String extension, DateTimeOption dateTimeOption, String timezone) {
        try (Client client = ClientBuilder.newBuilder().build();){
            client.register((Object)new VanillaDocumentMessageBodyReader(this.pf));
            WebTarget target = client.target(location + extension);
            Invocation.Builder builder = target.request(new String[]{media}).header("X-PROVENANCE-ACCEPT-DATETIME-OPTION", (Object)dateTimeOption);
            if (timezone != null) {
                builder = builder.header("X-PROVENANCE-ACCEPT-TIMEZONE", (Object)timezone);
            }
            Response response2 = builder.get();
            MultivaluedMap headers = response2.getStringHeaders();
            DateIT.assertNotNull((String)"X-PROVENANCE-CONTENT-DATETIME-OPTION is null", (Object)headers.get((Object)"X-PROVENANCE-CONTENT-DATETIME-OPTION"));
            DateIT.assertEquals((String)"X-PROVENANCE-CONTENT-DATETIME-OPTION is different", (String)dateTimeOption.name(), (String)((String)((List)headers.get((Object)"X-PROVENANCE-CONTENT-DATETIME-OPTION")).get(0)));
            if (timezone != null) {
                DateIT.assertNotNull((String)"X-PROVENANCE-CONTENT-TIMEZONE is null", (Object)headers.get((Object)"X-PROVENANCE-CONTENT-TIMEZONE"));
                DateIT.assertEquals((String)"X-PROVENANCE-CONTENT-TIMEZONE is different", (String)timezone, (String)((String)((List)headers.get((Object)"X-PROVENANCE-CONTENT-TIMEZONE")).get(0)));
            }
            Document document = (Document)response2.readEntity(org.openprovenance.prov.vanilla.Document.class);
            return document;
        }
    }

    public String doPostStatementsWithForm(String url, String file, String extension) {
        Document doc = this.intF.readDocumentFromFile(file);
        DateIT.assertNotNull((String)(" document (" + file + ") is null"), (Object)doc);
        String s = this.SerializeDocumentToProv(doc, Formats.ProvFormat.valueOf((String)extension.toUpperCase()));
        try (Client client = ClientBuilder.newBuilder().build();){
            String string;
            block12: {
                WebTarget target = client.target(url);
                MultipartFormDataOutput output = new MultipartFormDataOutput();
                output.addFormData("statements", (Object)s, MediaType.TEXT_PLAIN_TYPE);
                output.addFormData("type", (Object)extension, MediaType.TEXT_PLAIN_TYPE);
                output.addFormData("translate", (Object)extension, MediaType.TEXT_PLAIN_TYPE);
                Response response = target.request().post(Entity.entity((Object)output, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
                try {
                    string = response.getHeaderString("Location");
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    public String doPostStatementsInProvEncoding(String url, String file, String extension) {
        Document doc = this.intF.readDocumentFromFile(file);
        DateIT.assertNotNull((String)(" document (" + file + ") is null"), (Object)doc);
        try (Client client = ClientBuilder.newBuilder().build();){
            WebTarget target = client.target(DateIT.config.postURL);
            target.register((Object)new DocumentMessageBodyWriter((ProvDocumentWriter)this.intF));
            Response response = target.request(new String[]{"text/provenance-notation"}).post(Entity.entity((Object)doc, (String)"text/provenance-notation"));
            String location = response.getHeaderString("Location");
            String string = location = location.replace(".provn", "");
            return string;
        }
    }

    private String SerializeDocumentToProv(Document doc, Formats.ProvFormat format) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.intF.writeDocument((OutputStream)baos, doc, format);
        return baos.toString();
    }

    public Object readObject(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        client.register(VanillaDocumentMessageBodyReader.class);
        WebTarget target = client.target(location);
        Response response2 = target.request(new String[]{media}).get();
        Object o = response2.readEntity(InputStream.class);
        client.close();
        return o;
    }

    public ValidationReport readValidationReport(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            client.register(ValidationReportMessageBodyReader.class);
            WebTarget target = client.target(location);
            Response response2 = target.request(new String[]{media}).get();
            ValidationReport validationReport = (ValidationReport)response2.readEntity(ValidationReport.class);
            return validationReport;
        }
    }

    public String readAsString(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            client.register(ValidationReportMessageBodyReader.class);
            WebTarget target = client.target(location);
            Response response2 = target.request(new String[]{media}).get();
            String string = (String)response2.readEntity(String.class);
            return string;
        }
    }

    public Response getResource(String location, String media) {
        try (Client client = ClientBuilder.newBuilder().build();){
            WebTarget target = client.target(location);
            Response response2 = media == null ? target.request().get() : target.request(new String[]{media}).get();
            Response response = response2;
            return response;
        }
    }

    public Response getResource2(String location, String media) {
        Client client = ClientBuilder.newBuilder().build();
        WebTarget target = client.target(location);
        Response response2 = media == null ? target.request().get() : target.request(new MediaType[]{MediaType.TEXT_HTML_TYPE}).get();
        String o = (String)response2.readEntity(String.class);
        client.close();
        return response2;
    }

    static String escapeRed(String str) {
        return "\u001b[31m" + str + "\u001b[0m";
    }

    static String escapeGreen(String str) {
        return "\u001b[32m" + str + "\u001b[0m";
    }
}

