/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.openprovenance.prov.service.TemplateService;
import org.openprovenance.prov.service.security.pac.ClientConfiguration;
import org.openprovenance.prov.service.security.pac.SecurityConfiguration;
import org.openprovenance.prov.service.security.pac.Utils;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.authorization.authorizer.CsrfAuthorizer;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.config.Config;
import org.pac4j.core.config.ConfigFactory;

public class SecurityConfigFactory
implements ConfigFactory {
    static Logger logger = LogManager.getLogger(SecurityConfigFactory.class);
    private final Utils utils = new Utils();

    public SecurityConfigFactory() {
        logger.info("########### SecurityConfigFactory constructor ###########");
    }

    public Config build(Object ... parameters) {
        SecurityConfiguration securityConfiguration = TemplateService.securityConfiguration;
        if (securityConfiguration == null) {
            logger.info("No SecurityConfiguration: " + TemplateService.tplSecurityConfig);
            return new Config();
        }
        logger.info("SecurityConfiguration read " + String.valueOf(securityConfiguration));
        List clients = securityConfiguration.configurations.keySet().stream().map(key -> ((ClientConfiguration)securityConfiguration.configurations.get(key)).configureClient()).collect(Collectors.toList());
        Config config = new Config(securityConfiguration.getCallbackUrl(), clients);
        config.addAuthorizer("defaultAuthorizer", (Authorizer)new RequireAnyRoleAuthorizer(new String[]{"provwriter"}));
        config.addAuthorizer("csrf", (Authorizer)new CsrfAuthorizer());
        logger.info("Config created " + String.valueOf(config.getAuthorizers()));
        System.out.println("--- Config created " + String.valueOf(config));
        return config;
    }
}

