/*
 * Decompiled with CFR 0.152.
 */
package org.openprovenance.prov.service.template;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
import org.openprovenance.prov.interop.InteropFramework;
import org.openprovenance.prov.model.Bundle;
import org.openprovenance.prov.model.Document;
import org.openprovenance.prov.model.ProvDocumentWriter;
import org.openprovenance.prov.model.interop.ApiUriFragments;
import org.openprovenance.prov.model.interop.Formats;
import org.openprovenance.prov.service.client.ClientConfig;
import org.openprovenance.prov.service.core.readers.VanillaDocumentMessageBodyReader;
import org.openprovenance.prov.service.core.writers.VanillaDocumentMessageBodyWriter;
import org.openprovenance.prov.service.translator.TranslateIT;
import org.openprovenance.prov.vanilla.ProvFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ExpandIT
extends TestCase
implements ApiUriFragments {
    static Logger logger = LogManager.getLogger(ExpandIT.class);
    static final ClientConfig config = new ClientConfig(TranslateIT.class);
    final org.openprovenance.prov.model.ProvFactory pf = new ProvFactory();
    final InteropFramework intF = new InteropFramework(this.pf);
    private final VanillaDocumentMessageBodyWriter bodyWriter = new VanillaDocumentMessageBodyWriter((ProvDocumentWriter)this.intF);
    public static Map<String, String> table = new HashMap<String, String>();

    public Client getClient() {
        Client client = ClientBuilder.newBuilder().build();
        client.register((Object)this.bodyWriter);
        client.register((Object)new VanillaDocumentMessageBodyReader(this.pf));
        return client;
    }

    public void testTemplateAction1() throws IOException {
        this.doTestAction("src/test/resources/test-templates/bindings1.json", "src/test/resources/test-templates/expansion-bindings1.provn");
    }

    public void doTestAction(String file, String expectedFile) throws IOException {
        logger.debug("/////////////////////////////////// testAction");
        String theTemplate = ExpandIT.config.resourcesURLprefix + "templates/org/openprovenance/generic/binaryop/1.provn";
        logger.debug("*** action 1");
        Response responseTemplate = this.getResource(theTemplate, "text/provenance-notation");
        ExpandIT.assertEquals((String)"Response template status is NOT OK", (int)Response.Status.OK.getStatusCode(), (int)responseTemplate.getStatus());
        String location = this.doPostStatements(ExpandIT.config.formURL, theTemplate, file);
        ExpandIT.assertNotNull((String)"location", (Object)location);
        table.put("location", location);
        Response response = this.getResource(location, "application/ld+json");
        logger.debug("++ response contents " + String.valueOf(response.getEntity()));
        logger.debug("++ response headers " + String.valueOf(response.getHeaders()));
        logger.debug("++ response links " + String.valueOf(response.getLinks()));
        String location_html = (String)response.getHeaders().getFirst((Object)"Location");
        logger.debug("location " + location_html);
        ExpandIT.assertNull((String)"location", (Object)location_html);
        Document doc = this.readDocument(location);
        Document doc2 = new InteropFramework().readDocument((InputStream)new FileInputStream(expectedFile), Formats.ProvFormat.PROVN);
        logger.debug("+++ ready to test");
        Bundle bundle1 = (Bundle)doc.getStatementOrBundle().get(0);
        Bundle bundle2 = (Bundle)doc2.getStatementOrBundle().get(0);
        bundle2.setId(bundle1.getId());
        ExpandIT.assertEquals((Object)bundle1, (Object)bundle2);
        String templateLocation = location.replace(".provn", "/template.provn");
        logger.debug(templateLocation);
        Document doc3 = this.readDocument(templateLocation);
        ExpandIT.assertNotNull((Object)doc3);
        String bindingsLocation = location.replace(".provn", "/bindings");
        logger.debug(bindingsLocation);
        Response response4 = this.getResource(bindingsLocation, null);
        ExpandIT.assertEquals((String)"Response status for Bindings request is OK", (int)Response.Status.OK.getStatusCode(), (int)response4.getStatus());
    }

    public String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }

    public String doPostStatements(String url, String template, String file) {
        String str;
        try {
            str = this.readFile(file, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.throwing(Level.WARN, (Throwable)e);
            str = null;
        }
        ExpandIT.assertNotNull((String)(" string (" + file + ") is not null"), (Object)str);
        Client client = this.getClient();
        WebTarget target = client.target(url);
        MultipartFormDataOutput output = new MultipartFormDataOutput();
        output.addFormData("url", (Object)template, MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("statements", (Object)str, MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("type", (Object)"provn", MediaType.TEXT_PLAIN_TYPE);
        output.addFormData("expand", (Object)"provn", MediaType.TEXT_PLAIN_TYPE);
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)output, (MediaType)MediaType.MULTIPART_FORM_DATA_TYPE));
        String location = response.getHeaderString("Location");
        System.out.println("*** write " + location);
        client.close();
        return location;
    }

    public Document readDocument(String location) {
        Client client = this.getClient();
        WebTarget target = client.target(location);
        Response response2 = target.request().get();
        return (Document)response2.readEntity(org.openprovenance.prov.vanilla.Document.class);
    }

    public Response getResource(String location, String media) {
        Client client = this.getClient();
        WebTarget target = client.target(location);
        Response response2 = media == null ? target.request().get() : target.request(new String[]{media}).get();
        client.close();
        return response2;
    }
}

